<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


class CClientsWidgetClientsWCarousel extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "1",
		"name"	=> "Clients w/ Carousel",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		switch ($widget["settings"]["set_type"]) {
			default:
			case "1":
				$order = " i.item_id DESC ";
				$cnt = $widget["settings"]["set_items"];
			break;
			

			case "2":
				$order = " rand() ";
				$cnt = $widget["settings"]["set_items"];
			break;

			case "3":

				if (!$widget["settings"]["set_item"]) {
					return "";
				}
				
				$cond = " AND i.item_id IN ({$widget[settings][set_item]}) ";
				$order = "item_order ASC";

				$cnt = 99999;
			break;
		}


		$items = $this->db->QFetchRowArray(
			"SELECT * 
			FROM 
				{$this->tables['plugin:clients_items']} as i,
				{$this->tables['plugin:clients_items_lang']} as l
			WHERE 
				i.item_id = l.item_id AND 
				i.module_id = {$widget[mod_id]} AND
				l.lang_id = {$widget[lang_id]}
				{$cond}

			ORDER BY  {$order} 
			LIMIT {$cnt}" 
		);
	
		if (!is_array($items)) {
			return "";
		}

		$elements = explode("," , $widget["settings"]["set_elements"]);

		foreach ($items as $key => $val) {

			$items[$key]["_link"] = $val["item_url"] ? $this->tpl->blockReplace("Link", $val) : "";
			$items[$key]["source"] = $val["item_image"] ? "upload/clients/{$val[item_id]}.jpg" : "upload/default-images/client.png";
			
			$items[$key]["_title"] = $items[$key]["_brief"] = $items[$key]["_link"] = "";

			if (in_array("title", $elements)) {
				$items[$key]["_title"] = $this->tpl->blockReplace(
					"Title" ,
					$val
				);
			} 

			if (in_array("button", $elements)) {

				$items[$key]["link"] = $val["link"] = $this->plugins["modules"]->BuildLink(array(
					"type"	=> $val["item_link_type"],
					"link"	=> $val["item_link_link"],
					"module"=> $val["item_link_module"],
					"global"=> $val["item_link_global"]
				));


				$items[$key]["_link"] = $val["link"] ? $this->tpl->blockReplace(
					"Link" ,
					$val
				) : "";
			} 

			if (in_array("brief", $elements)) {

				if ($val["item_description"]) {
					$val["item_description"] = nl2br($val["item_description"]);

					$items[$key]["_brief"] = $this->tpl->blockreplace(
						"Brief",
						$val
					);
				}

			} 


		}


		if ($widget["settings"]["set_type"] == "3") {
			$items = SortByKeys($items , "item_id" , $widget["settings"]["set_item"]);
		}
		

		return $this->tpl->blockReplace(
			"Main" ,
			array(
				"items"	=> $base->html->Table(
					$this->tpl, 
					"" , 
					$items
				),

				"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),
			),
			$widget , 
			$widget["settings"],
			$widget["mod_settings"]
		);
	}
	
	

}


?>