<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CTimeline extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);

		$this->name = "timeline";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == $this->name) {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;

				case "ajax.load":
					return $this->AjaxLoad();
				break;				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			//return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"landing"				=> "landing.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {

		global $base;
		

		$text = $this->pageTitleBlock();

		$this->module->plugins["seo"]->PageMeta($text);


		//get all the items

		$items = $this->GetItems(array(
			"items"	=> $this->tpl_module["settings"]["set_ipp_items"],
			"page"	=> "0"
		));


		$items["records"] = $this->ProcessItems($items["records"]);

		$this->SetComments($this->tpl_module["settings"]["set_comments"], array("link" => $this->tpl_module["link"]));

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),

			$this->private->templates["landing"]->blockREplacE(
				"Main" , 
				array(
					"content"	=> $base->html->table(
						$this->private->templates["landing"],
						"" ,
						$items["records"]
					),

					"script"	=> $this->plugins["modules"]->ScriptLink("timeline.ajax.load.php" , array("module_id" => $this->tpl_module["mod_id"])),
					"extra"		=> $items["pages"] <= $items["page"] ? $this->private->templates["landing"]->blockREplace("EmptyTopics") : "",
					"title"		=> $text["text_block_1_title"] ? $this->_t("landing")->blockReplace("MainTitle" , $text) : "",

				),
				$text,
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
	}


	/**
	* description

	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetItems($params = array()) {
	
		$count	= $params["items"];
		$page	= $params["page"];

		switch (strtoupper($this->tpl_module["settings"]["set_sort"])) {
			case "ASC":
				$order		= "item_date";
				$order_mode = "ASC";
			break;

			case "DESC":
				$order		= "item_date";
				$order_mode = "DESC";
			break;

			case "MANUAL":
				$order		= "item_order";
				$order_mode = "ASC";
			break;
		}		

		return $this->_GetItemsPage(
			"	{$this->tables['plugin:timeline_items']} as t,
				{$this->tables['plugin:timeline_items_lang']} as l
			",
			$count,
			$page,
			"
				t.module_id={$this->tpl_module[mod_id]} AND 
				t.item_id = l.item_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				item_status=1 
			",
			$order . " " . $order_mode			
		);
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($items) {

		$tpl = &$this->private->templates["landing"];

		$year = 0;

		if (is_array($items)) {
			foreach ($items as $key => $val) {

				$val["year"] = CDate::ToStr("Y" , $val["item_date"]);

				if ($val["year"] != $year) {
					$items[$key]["extra"] = $tpl->blockReplace("Year" , array("year" => $val["year"]) );
					$year = $val["year"];
				}  else {
					$items[$key]["extra"] = "";
				}
				

				$items[$key]["title"] = $val["item_title"] ? $tpl->blockReplace("Title" , $val) : "";
				$items[$key]["body"] = $val["item_body"] ? $tpl->blockReplace("Body" , $val) : "";

				$more = $this->plugins["modules"]->BuildLink(array(
					"type"	=> $val["item_link_type"],
					"link"	=> $val["item_link_link"],
					"module"=> $val["item_link_module"],
					"global"=> $val["item_link_global"]
				));

				$res = $this->plugins["media"]->Gallery(
					$val["item_id"] , 
					$val["module_id"] , 
					$val["link"] , 
					"" , 
					"html" , 
					array(
						"path" => "upload/timeline",
						"tn"	=> $this->tpl_module["settings"]["set_media_height"] ? "tn2" : "tn"
					)
				);

				$items[$key]["resource"] = $res ? $tpl->blockReplace("Resource" , array("res" => $res)) : "";


				if ($more) {
					$more = $tpl->blockReplace(
						"Link",
						array(
							"link"		=> $more,
							"target"	=> $val["item_link_target"],
							"text"		=> $val["item_link_text"],
							"size"		=> $val["item_link_size"],
							"style"		=> $val["item_link_style"],
							"rel"		=> $val["item_link_rel"],
						)
					);
				}


				$items[$key]["link"] = $more;


				$items[$key]["date"] = $val["item_show_date"] ? $tpl->blockReplace(
					"Date" , 
					array(
						"date" => cDate::ToStr($this->tpl_module["settings"]["set_date"] , $val["item_date"])
					)
				) : "";


				if ($more || $val["item_show_date"]) {
					$items[$key]["footer"] = $tpl->blockReplace(
						"Footer",
						$items[$key]
					);
				} else {
					$items[$key]["footer"] = "";	 
				}
				

				if ($items[$key]["title"] || $items[$key]["body"] || $items[$key]["footer"]) {
					$items[$key]["body"] = $tpl->blockreplace("Content" , $items[$key]);
				} else {
					$items[$key]["body"] = "";
				}
				
			}
			
		}
		
		return $items;
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AjaxLoad() {
		global $base;

		$items = $this->GetItems(array(
			"items"	=> $this->tpl_module["settings"]["set_ipp_items"],
			"page"	=> $_POST["page"]
		));

		$items["records"] = $this->ProcessItems($items["records"]);

		if (!is_array($items["records"])) {
			die("");
		}	

		return $this->private->templates["landing"]->blockREplacE(
			"Ajax" , 
			array(
				"content"	=> $base->html->table(
					$this->private->templates["landing"],
					"" ,
					$items["records"]
				),
				"extra"	=> $items["pages"] <= $items["page"] ? $this->private->templates["landing"]->blockREplace("EmptyTopics") : ""
			)
		);


	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SitemapGetMaps($module , $lang) {

		if ($module["mod_id"]) {
			return array($module["mod_id"] => true);
		} else {
			return array($module["module_code"] => true);
		}
		
	}


	function SitemapGetLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);
	}
	
}
