DROP TABLE IF EXISTS `site_plugin_popups`;
CREATE TABLE `site_plugin_popups` (
  `popup_id` int(11) NOT NULL AUTO_INCREMENT,
  `popup_code` varchar(32) NOT NULL,
  `popup_status` int(11) NOT NULL,
  `popup_type` int(11) NOT NULL,
  `popup_default` int(1) NOT NULL,
  `popup_modules` text NOT NULL,
  `popup_modules_global` text NOT NULL,
  `popup_label` varchar(255) NOT NULL,
  `popup_social` varchar(255) NOT NULL,
  `popup_social_label` int(1) NOT NULL,
  `popup_social_count` varchar(15) NOT NULL,
  `popup_social_theme` varchar(20) NOT NULL,
  `popup_social_size` int(2) NOT NULL,
  `popup_newsletter` int(11) NOT NULL,
  `popup_link_type` int(1) NOT NULL,
  `popup_link_module` int(11) NOT NULL,
  `popup_link_target` varchar(20) NOT NULL,
  `popup_show` int(11) NOT NULL,
  `popup_show_seconds` int(11) NOT NULL,
  `popup_show_scroll` int(11) NOT NULL,
  `popup_device` varchar(10) NOT NULL,
  `popup_social_twitter` varchar(100) NOT NULL,
  `popup_remember_for` int(11) NOT NULL,
  `popup_remember_times` int(11) NOT NULL,
  `popup_remember_in` int(1) NOT NULL,
  `popup_perm` int(1) NOT NULL,
  `popup_perm_groups` text NOT NULL,
  `popup_content_type` int(1) NOT NULL,
  `popup_content_align` int(1) NOT NULL,
  `popup_social_type` int(1) NOT NULL,
  `popup_resource` int(2) NOT NULL,
  `popup_image` int(1) NOT NULL,
  `popup_icon` varchar(100) NOT NULL,
  `popup_youtube` varchar(100) NOT NULL,
  `popup_vimeo` varchar(100) NOT NULL,
  `popup_link_global` int(11) NOT NULL,
  `popup_link_size` varchar(10) NOT NULL DEFAULT 'btn-small',
  `popup_content_bg` int(11) NOT NULL,
  `popup_action_bg` int(11) NOT NULL,
  `popup_action_css` varchar(255) NOT NULL,
  `popup_content_css` varchar(255) NOT NULL,
  `popup_link2_type` int(11) NOT NULL,
  `popup_link2_module` int(11) NOT NULL,
  `popup_link2_target` varchar(20) NOT NULL,
  `popup_link2_global` int(11) NOT NULL,
  `popup_link2_size` varchar(10) NOT NULL DEFAULT 'btn-small',
  `popup_close_btn` int(1) NOT NULL,
  `popup_close_out` int(1) NOT NULL,
  `popup_stat_show` int(1) NOT NULL,
  `popup_stat_close` int(1) NOT NULL,
  `popup_link_rel` varchar(30) NOT NULL,
  `popup_link2_rel` varchar(30) NOT NULL,
  `popup_link_style` varchar(50) NOT NULL,
  `popup_link2_style` varchar(50) NOT NULL,
  PRIMARY KEY (`popup_id`),
  KEY `popup_status` (`popup_status`,`popup_type`,`popup_default`),
  FULLTEXT KEY `popup_modules` (`popup_modules`),
  FULLTEXT KEY `popup_modules_global` (`popup_modules_global`),
  FULLTEXT KEY `popup_device` (`popup_device`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_popups_lang`;
CREATE TABLE `site_plugin_popups_lang` (
  `popup_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `popup_title` varchar(255) NOT NULL,
  `popup_headline` text NOT NULL,
  `popup_body` text NOT NULL,
  `popup_link_text` varchar(255) NOT NULL,
  `popup_link_link` text NOT NULL,
  `popup_social_link_fb` text NOT NULL,
  `popup_social_link_gp` text NOT NULL,
  `popup_social_link_tw` text NOT NULL,
  `popup_html` text NOT NULL,
  `popup_social_html` text NOT NULL,
  `popup_link2_text` varchar(255) NOT NULL,
  `popup_link2_link` text NOT NULL,
  `popup_classic_title` varchar(255) NOT NULL,
  `popup_classic_body` text NOT NULL,
  `popup_close_text` varchar(255) NOT NULL,
  KEY `popup_id` (`popup_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_popups_log`;
CREATE TABLE `site_plugin_popups_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `log_type` int(1) NOT NULL,
  `log_date` int(11) NOT NULL,
  `log_url` int(11) NOT NULL,
  `log_user_agent` text NOT NULL,
  `log_language` text NOT NULL,
  `log_remote_addr` varchar(20) NOT NULL,
  `log_referer` text NOT NULL,
  `log_page` text NOT NULL,
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `log_id` (`log_id`),
  KEY `log_remote_addr` (`log_remote_addr`),
  KEY `log_url` (`log_url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_popups_users`;
CREATE TABLE `site_plugin_popups_users` (
  `puid_user` int(11) NOT NULL,
  `puid_popup` int(11) NOT NULL,
  `puid_date` int(11) NOT NULL,
  KEY `puid_user` (`puid_user`,`puid_popup`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
