<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


class CWidgetsWidgetFeaturesWImage extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "",
		"name"	=> "Features w/ Resource",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;


		if (!is_array($widget)) {
			return "";
		}

		$items = $this->module->GetStaticItems($widget);

		if (!is_array($items)) {
			return "";
		}

		foreach ($items as $key => $val) {

			$link = $this->plugins["modules"]->BuildLink(array(
				"type"	=> $val["item_link_type"],
				"link"	=> $val["item_link_link"],
				"module"=> $val["item_link_module"],
				"global"=> $val["item_link_global"],
			));

			$val["link"] = $link;

			$val["icon"] = $val["item_icon"] ? $this->tpl->blockReplace("Icon", $val) : "";
			$val["title"] = $val["item_title"] ? $this->tpl->blockReplace($link ? "Link" : "Title", $val) : "";
			$val["subtitle"] = $val["item_desc"] ? $this->tpl->blockReplace("Subtitle", $val) : "";

			if ($val["item_type"] == "1") {
				$left[] = $val;
			} else {
				$right[] = $val;
			}			
		}
		

		if ($widget["settings"]["set_size"] == "2") {
			$block = "Manual";
		} elseif (is_array($left) && is_array($right)) {
			$block = "Both";
		} elseif (is_array($left)) {
			$block = "Left"; 
		} else {
			$block = "Right";
		}

				
		return $this->tpl->blockReplace(
			"Widget",
			array(
				"content"	=> $this->tpl->blockReplace(
					$block , 
					array(
						"left"	=> is_array($left) && count($left) ? $base->html->table(
							$this->tpl , 
							"",	
							$left,
							array(
								"pos"	=> "left"
							)
						) : "",

						"right"	=> is_array($right) && count($right) ? $base->html->table(
							$this->tpl , 
							"",	
							$right,
							array(
								"pos"	=> "right"
							)
						) : "",

						"image" => $this->Image($widget),
					)
				)
			),
			$widget,
			$widget["settings"]
		);

	}
			

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Image($widget) {

		switch ($widget["settings"]["set_res_type"]) {
			//image
			default:
				if (!$widget["settings"]["set_image"]) {
					return "";
				}
				
				return $this->tpl->blockReplace("Image" ,$widget);
			break;

			//youtube
			case "1":
				if (!$widget["settings"]["set_youtube"]) {
					return "";
				}				

				return $this->tpl->blockReplace("Youtube" ,$widget);

			break;

			//vimeo
			case "2":
				if (!$widget["settings"]["set_vimeo"]) {
					return "";
				}				

				return $this->tpl->blockReplace("Vimeo" ,$widget);
			break;

			//raw html
			case "3":
				if (!$widget["settings"]["set_html"]) {
					return "";
				}				

				return $this->tpl->blockReplace("RawHTML" ,$widget);
			break;
		}
		
	}
	

}


?>