<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


class CWidgetsWidgetFeatures extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "",
		"name"	=> "Features w/ Carousel",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;


		if (!is_array($widget)) {
			return "";
		}

		$items = $this->module->GetStaticItems($widget);

		if (!is_array($items)) {
			return "";
		}

		foreach ($items as $key => $val) {

			$link = $this->plugins["modules"]->BuildLink(array(
				"type"	=> $val["item_link_type"],
				"link"	=> $val["item_link_link"],
				"module"=> $val["item_link_module"],
				"global"=> $val["item_link_global"],
			));

			$val["link"] = $link;

			$val["icon"] = $val["item_icon"] ? $this->tpl->blockReplace("Icon", $val) : "";
			$val["title"] = $val["item_title"] ? $this->tpl->blockReplace($link ? "Link" : "Title", $val) : "";
			$val["subtitle"] = $val["item_desc"] ? $this->tpl->blockReplace("Subtitle", $val) : "";

			$items[$key] = $val;
		}
		
				
		return $this->tpl->blockReplace(
			"Widget",
			array(
				"content"	=> $base->html->table(
					$this->tpl , 
					"",	
					$items
				) ,

				"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),

			),
			$widget,
			$widget["settings"]
		);

	}
			

}


?>