<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


class CCTAWidgetCTA extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "1",
		"name"	=> "Call To Action",
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $_LANG_ID;


		if (!$widget["settings"]["set_cta"] && $widget["settings"]["set_usp"]) {
			$widget["settings"]["set_cta"] = $widget["settings"]["set_usp"];
		}		

		$cta = $this->db->QFetchArray(
			"SELECT * FROM {$this->tables['plugin:cta']} as c, {$this->tables['plugin:cta_lang']} as l  WHERE c.cta_id=l.cta_id AND lang_id={$_LANG_ID} AND c.cta_id={$widget[settings][set_cta]} AND cta_status=1"
		);

		if (is_array($cta)) {

			$cta["link"] = $this->plugins["modules"]->BuildLink(array(
				"type"	=> $cta["cta_link_type"],
				"link"	=> $cta["cta_link_link"],
				"module"=> $cta["cta_link_module"],
				"global"=> $cta["cta_link_global"]
			));


			if ($cta["link"]) {
				$cta["link_htm"] = $this->tpl->blockReplace("Link" , $cta);
			} else {
				$cta["link_htm"] = "";
			}


			$cta["link2"] = $this->plugins["modules"]->BuildLink(array(
				"type"	=> $cta["cta_link2_type"],
				"link"	=> $cta["cta_link2_link"],
				"module"=> $cta["cta_link2_module"],
				"global"=> $cta["cta_link2_global"]
			));


			if ($cta["link2"]) {
				$cta["link2_htm"] = $this->tpl->blockReplace("Link2" , $cta);
			} else {
				$cta["link2_htm"] = "";
			}


			$cta["text"] = $cta["cta_text"] ? $this->tpl->blockREplacE("Text" , $cta) : "";
			$cta["title"] = $cta["cta_title"] ? $this->tpl->blockREplacE("Title" , $cta) : "";
			

			return $this->tpl->blockReplace(
				"Main" , 
				array(
					"content"	=> $this->tpl->blockReplace($cta["cta_image"] ? "ContentImage" : "Content" , $cta)
				),
				$widget,
				$widget["settings"]
			);
		}
	}
			

}


?>