<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CCTA extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetCTA($mod_id , $system = false , $widget = false) {
		global $_CONF , $_LANG_ID , $base , $_SESS;


		//device detection tablet
		if ($base->isTablet) {
				$cond = " AND find_in_set(2,cta_device) ";
		} elseif ($base->isMobile) {
				//phone
				$cond = " AND find_in_set(3,cta_device) ";
			} else {
				//desktop
				$cond = " AND find_in_set(1,cta_device) ";
			}


		//permission detection
		if (is_array($_SESS["client"])) {

			if (is_array($_SESS["client"]["groups"])) {
				foreach ($_SESS["client"]["groups"] as $k => $v) {
					$tmp[] = " find_in_set({$v} , cta_perm_groups) ";
				}
				
				$cond .= " AND ( 
					cta_perm in ( 1,0) OR  
					(
						cta_perm = 3 AND 
						(
							cta_perm_groups='' OR ( " . implode(" OR "  , $tmp ) . " )
						)
					)
				)";

			} else {
				$cond .= " AND cta_perm in (0,1,3)";
			}
			
		} else {
			$cond .= " AND cta_perm in (0,1,2) ";
		}		


		if ($system) {
			$cta = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:cta']} as c, 
					{$this->tables['plugin:cta_lang']} as l  
				WHERE 
					cta_default=0 AND 
					c.cta_id=l.cta_id AND 
					lang_id={$_LANG_ID} AND 
					find_in_set({$mod_id} , cta_modules_global) AND 
					cta_status=1
					{$cond}
				ORDER BY 
					rand() LIMIT 1"
			);
		} else {
			
			$cta = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:cta']} as c, 
					{$this->tables['plugin:cta_lang']} as l  
				WHERE 
					cta_default=0 AND 
					c.cta_id=l.cta_id AND 
					lang_id={$_LANG_ID} AND 
					find_in_set({$mod_id} , cta_modules) AND 
					cta_status=1 
					{$cond}
				ORDER BY 
					rand() LIMIT 1"
			);
		}

		//load the default if exits
		if (!is_array($cta)) {

			$cta = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:cta']} as c, 
					{$this->tables['plugin:cta_lang']} as l  
				WHERE 
					c.cta_id=l.cta_id AND 
					lang_id={$_LANG_ID} AND 
					cta_default=1 AND 
					cta_status=1 
					{$cond}
				ORDER BY 
					rand() LIMIT 1"
			);

		}
		

		if (is_array($cta)) {
			
			$this->tpl = new CTemplateDynamic($this->tpl_path . "cta.htm");

			switch ($cta["cta_type"]) {

				//classic content
				default:
					$cta["link"] = $this->plugins["modules"]->BuildLink(array(
						"type"	=> $cta["cta_link_type"],
						"link"	=> $cta["cta_link_link"],
						"module"=> $cta["cta_link_module"],
						"global"=> $cta["cta_link_global"]
					));


					if ($cta["link"]) {
						$cta["link_htm"] = $this->tpl->blockReplace("Link" , $cta);
					} else {
						$cta["link_htm"] = "";
					}


					$cta["link2"] = $this->plugins["modules"]->BuildLink(array(
						"type"	=> $cta["cta_link2_type"],
						"link"	=> $cta["cta_link2_link"],
						"module"=> $cta["cta_link2_module"],
						"global"=> $cta["cta_link2_global"]
					));


					if ($cta["link2"]) {
						$cta["link2_htm"] = $this->tpl->blockReplace("Link2" , $cta);
					} else {
						$cta["link2_htm"] = "";
					}


					$cta["text"] = $cta["cta_text"] ? $this->tpl->blockREplacE("Text" , $cta) : "";
					$cta["title"] = $cta["cta_title"] ? $this->tpl->blockREplacE("Title" , $cta) : "";

					$content = $this->tpl->blockReplace(
						"Main" , 
						array(
							"content"	=> $this->tpl->blockReplace($cta["cta_image"] ? "ContentImage" : "Content" , $cta)
						)
					);
				break;

				//raw html
				case "1":
					$content = $cta["cta_html"];
				break;

			}
			


			if ($widget == true) {
				return $content;
			}

				
			return array(
				"content"	=> $content,
				"pos"			=> $cta["cta_position"],
				"cta_id"		=> $cta["cta_id"],
				"cta_bg"		=> $cta["cta_bg"],
				"cta_bg_style"	=> $cta["cta_bg_style"]
			);

		}
		
	}
	



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {


		if ($module["mod_id"]) {
			$cta  = $this->GetCTA($module["mod_id"]);
		} elseif ($module["module_id"]) {
			$cta  = $this->GetCTA($module["module_id"] , true);
		}
		

		global $_TSM;

		//clear all cta variables
		$_TSM["PUB:CTA"] = "";
		$_TSM["PUB:CTA_TOP"] = "";
		$_TSM["PUB:CTA_FOOTER"] = "";
		$_TSM["PUB:CTA_BOTTOM"] = "";


		if (is_Array($cta)) {

			if ($cta["cta_bg"]) {
				//prepare the background
				$bg = $this->plugins["backgrounds"]->GetBg($cta["cta_bg"]);

				if ($bg["bg:scheme"]) {
					$scheme = array("bg:scheme" => $bg["bg:scheme"]);
				}
				

				$cta["content"] = $this->tpl->blockReplace(
					"Section",
					array(
						"content"			=> $cta["content"],
						"cta_id"			=> $cta["cta_id"],

						"bg_s_class"		=> $cta["cta_bg_style"] ? "" : $bg["class"],
						"bg_s_html"			=> $cta["cta_bg_style"] ? "" : $bg["html"],

						"bg_c_class"		=> $cta["cta_bg_style"] ? $bg["class"] : "",
						"bg_c_html"			=> $cta["cta_bg_style"] ? $bg["html"] : "",

						"background_class"	=> $bg["class"],
						"background_html"	=> $bg["html"]
					),$scheme
				);

			} else {
				$cta["content"] = $this->tpl->blockReplace(
					"Section",
					array(
						"content"			=> $cta["content"],
						"bg_s_class"		=> "",//$this->tpl->blockReplace("DefaultBg"),
						"bg_s_html"			=> "",
						"bg_c_class"		=> "",
						"bg_c_html"			=> "",
						"cta_id"			=> $cta["cta_id"]						
					),$scheme
				);
			}

			switch ($cta["pos"]) {
				case "2":
					$_TSM["PUB:CTA"] = $cta["content"];
				break;

				case "1":
					$_TSM["PUB:CTA_TOP"] = $cta["content"];
				break;

				case "3":
					$_TSM["PUB:CTA_FOOTER"] = $cta["content"];
				break;

				case "4":
					$_TSM["PUB:CTA_BOTTOM"] = $cta["content"];
				break;

			}
			
		}
		
	}


}

?>