<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class COwlCarousel extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
		$this->name = "owlcarousel";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		if ($_GET["mod"] == $this->name) {
			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule($this->name);	
			$this->tpl_module["module_name"] = "Sliders";

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

			
			switch ($sub) {
				case "landing":
					$sub = "sliders";
				case "sliders":					
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);

					$data->functions = array( 
						"onstore" => array(&$this , "StoreItem"),
						"ondelete" => array(&$this , "DeleteItem"),
					);					

					$this->PrepareFields($data->forms["forms"]);
					$this->PrepareEditFields($data->forms["forms"]);

					return $data->DoEvents();
				break;


				case "slider.images":
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$this->PrepareFields($data->forms["forms"]);
					return $data->DoEvents();
				break;


			}
		}
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/

	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareEditFields(&$forms) {

		if ($_GET["owl_id"] && !$_GET["section"]) {
			$slider = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:owlcarousel']} WHERE owl_id={$_GET[owl_id]}");

			$slider_data = $this->plugins["sliders"]->GetSlider($slider["owl_slider"]);

			$forms["edit"]["fields"]["box"]["1"]["fields"]["slider_modules"]["default"] = 
			$forms["details"]["fields"]["box"]["1"]["fields"]["slider_modules"]["default"] = $slider_data["slider_modules"];

			$forms["edit"]["fields"]["box"]["0"]["fields"]["slider_status"]["default"] = 
			$forms["details"]["fields"]["box"]["0"]["fields"]["slider_status"]["default"] = $slider_data["slider_status"];

			$forms["edit"]["fields"]["box"]["1"]["fields"]["slider_modules_global"]["default"] = 
			$forms["details"]["fields"]["box"]["1"]["fields"]["slider_modules_global"]["default"] = $slider_data["slider_modules_global"];

			$forms["edit"]["fields"]["box"]["1"]["fields"]["slider_default"]["default"] = 
			$forms["details"]["fields"]["box"]["1"]["fields"]["slider_default"]["default"] = $slider_data["slider_default"];

			$forms["edit"]["fields"]["box"]["0"]["fields"]["slider_device"]["default"] = 
			$forms["details"]["fields"]["box"]["0"]["fields"]["slider_device"]["default"] = $slider_data["slider_device"];

			$forms["edit"]["fields"]["box"]["0"]["fields"]["slider_show_header"]["default"] = 
			$forms["details"]["fields"]["box"]["0"]["fields"]["slider_show_header"]["default"] = $slider_data["slider_show_header"];

			$forms["edit"]["fields"]["box"]["0"]["fields"]["slider_under_menu"]["default"] = 
			$forms["details"]["fields"]["box"]["0"]["fields"]["slider_under_menu"]["default"] = $slider_data["slider_under_menu"];

			$forms["edit"]["fields"]["box"]["1"]["fields"]["slider_menu_inverted"]["default"] = 
			$forms["details"]["fields"]["box"]["1"]["fields"]["slider_menu_inverted"]["default"] = $slider_data["slider_menu_inverted"];

			$forms["edit"]["fields"]["box"]["1"]["fields"]["slider_menu_overlay"]["default"] = 
			$forms["details"]["fields"]["box"]["1"]["fields"]["slider_menu_overlay"]["default"] = $slider_data["slider_menu_overlay"];

		}
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreItem($record) {
		if ($record["owl_id"]) {


			$slider_data = 	array(
				"slider_module"			=> $this->name,
				"slider_id"				=> $record["owl_slider"],
				"slider_sid"			=> $record["owl_id"],
				"slider_status"			=> $record["slider_status"],
				"slider_default"		=> $record["slider_default"],
				"slider_modules"		=> $record["slider_modules"],
				"slider_modules_global"	=> $record["slider_modules_global"],
				"slider_device"			=> $record["slider_device"],
				"slider_show_header"	=> $record["slider_show_header"],
				"slider_under_menu"		=> $record["slider_under_menu"],
				"slider_menu_inverted"	=> $record["slider_menu_inverted"],
				"slider_menu_overlay"	=> $record["slider_menu_overlay"],
			);

			if ($record["owl_slider"]) {
				$record["owl_slider"] = $this->plugins["sliders"]->UpdateSlider(
					$slider_data
				);
			} else {
				$record["owl_slider"] = $this->plugins["sliders"]->AddSlider(
					$slider_data
				);
			}
			
			$this->db->QueryUpdate(
				$this->tables["plugin:owlcarousel"],
				array(
					"owl_slider" => $record["owl_slider"]
				),
				"owl_id={$record[owl_id]}"
			);

		}		
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DeleteItem($record) {
		$this->plugins["sliders"]->DeleteSlider($record["owl_slider"]);
	}


	function ShortcodesBrowser() {
		global $_LANG_ID , $base;

		$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("owlcarousel");

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:sliders']},
				{$this->tables['plugin:owlcarousel']}
			WHERE slider_id=owl_slider 
			ORDER BY owl_name ASC
			"
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$items[$key]["cnt"] = ++$cnt;

				$tmp = explode("," , $val["slider_device"]);
				$data = null;


				if (in_array("1" , $tmp))
					$data[] = '<span class="f16 sign sign-desktop"></span>';

				if (in_array("2" , $tmp))
					$data[] = '<span class="f16 sign sign-tablet"></span>';

				if (in_array("3" , $tmp))
					$data[] = '<span class="f16 sign sign-mobile"></span>';

				
				if (is_Array($data)) {
					$items[$key]["devices"] = implode(", " , $data);
				} else {
					$items[$key]["devices"] = "";
				}

			}
			
		}

	

		$tpl = new CTEmplateDynamic($this->tpl_path . "admin.shortcodes.htm");

		return array(
			"title"				=> $this->tpl_module["module_name"] , 
			"html"				=> $base->html->Table(
				$tpl, 
				"" , 
				$items
			)
		);
			
	}
}

?>