
DROP TABLE IF EXISTS `site_plugin_jobs_cats`;
CREATE TABLE `site_plugin_jobs_cats` (
  `cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `cat_order` int(11) NOT NULL,
  `cat_status` int(11) NOT NULL,
  `cat_date` int(11) NOT NULL,
  `cat_icon` varchar(100) NOT NULL,
  `cat_tn_type` int(2) NOT NULL,
  `cat_tn_icon` varchar(255) NOT NULL,
  `cat_tn_image` int(1) NOT NULL,
  `cat_css_list` varchar(255) NOT NULL,
  `cat_css_details` varchar(255) NOT NULL,
  PRIMARY KEY (`cat_id`),
  KEY `module_id` (`module_id`,`cat_order`,`cat_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_jobs_cats_lang`;
CREATE TABLE `site_plugin_jobs_cats_lang` (
  `cat_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `cat_title` varchar(255) NOT NULL,
  `cat_url` varchar(255) NOT NULL,
  `cat_description` text NOT NULL,
  `cat_brief` text NOT NULL,
  `seo_title` text NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  KEY `cat_id` (`cat_id`,`module_id`,`lang_id`),
  KEY `cat_url` (`cat_url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_jobs_fields`;
CREATE TABLE `site_plugin_jobs_fields` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_field` varchar(255) NOT NULL,
  `item_type` varchar(30) NOT NULL,
  `item_required` int(1) NOT NULL,
  `item_size` int(2) NOT NULL,
  `item_size_lg` int(2) NOT NULL,
  `item_size_md` int(2) NOT NULL,
  `item_size_sm` int(2) NOT NULL,
  `item_size_xs` int(2) NOT NULL,
  `item_system` int(1) NOT NULL,
  `item_radio_new` int(1) NOT NULL,
  `item_cat` text NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `module_id` (`module_id`,`item_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_jobs_fields_lang`;
CREATE TABLE `site_plugin_jobs_fields_lang` (
  `item_id` int(11) NOT NULL,
  `lang_id` int(3) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_error_msg` varchar(255) NOT NULL,
  `item_options` text NOT NULL,
  KEY `lang_id` (`lang_id`),
  KEY `item_id` (`item_id`),
  KEY `lang_id_2` (`lang_id`),
  KEY `item_id_2` (`item_id`,`lang_id`,`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_jobs_items`;
CREATE TABLE `site_plugin_jobs_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_fax` varchar(255) NOT NULL,
  `item_phone` varchar(255) NOT NULL,
  `item_email` varchar(255) NOT NULL,
  `item_email_job` int(1) NOT NULL,
  `item_date` int(11) NOT NULL,
  `item_date_expire` int(11) NOT NULL,
  `item_status` int(2) NOT NULL,
  `item_icon` varchar(50) NOT NULL,
  `item_cat` text NOT NULL,
  `item_css_list` varchar(255) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `item_id` (`item_id`,`module_id`),
  KEY `item_order` (`item_order`,`item_date`,`item_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_jobs_items_lang`;
CREATE TABLE `site_plugin_jobs_items_lang` (
  `item_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_url` varchar(255) NOT NULL,
  `item_location` varchar(255) NOT NULL,
  `item_brief` text NOT NULL,
  `item_details` text NOT NULL,
  `item_contact` varchar(255) NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  KEY `item_id` (`item_id`,`module_id`,`lang_id`),
  KEY `item_url` (`item_url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_jobs_resumes`;
CREATE TABLE `site_plugin_jobs_resumes` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_code` varchar(32) DEFAULT NULL,
  `item_job` int(11) NOT NULL,
  `item_file` int(1) DEFAULT NULL,
  `item_file_file` varchar(255) DEFAULT NULL,
  `module_id` int(11) DEFAULT NULL,
  `item_new` int(1) DEFAULT NULL,
  `item_date` int(11) DEFAULT NULL,
  `item_email` varchar(255) DEFAULT NULL,
  `item_name` varchar(255) DEFAULT NULL,
  `item_message` text,
  `item_spam` int(1) NOT NULL,
  `log_ip` varchar(50) NOT NULL,
  `log_domain` varchar(255) NOT NULL,
  `log_agent` varchar(255) NOT NULL,
  `item_replied` int(1) NOT NULL,
  `item_replied_date` int(11) NOT NULL,
  `item_reply` text NOT NULL,
  `item_vars` text NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `item_job` (`item_job`,`module_id`,`item_new`,`item_date`,`item_spam`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
