<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CTestimonials extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();


		if ($_GET["mod"] == "testimonials") {


			$this->__init();


			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"items"					=> "items.htm",
			"onepage"				=> "onepage.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {
		global $base;

		$text = $this->pageTitleBlock();				
		$this->module->plugins["seo"]->PageMeta($text);


		$cats = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:testimonials_cats']} as c,
				{$this->tables['plugin:testimonials_cats_lang']} as l
			WHERE
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_id = l.cat_id AND 
				c.cat_status = 1 AND 
				l.lang_id = {$this->tpl_module[lang_id]} 
			ORDER BY
				c.cat_order ASC
			",
			array( time() )
		);

		if (is_Array($cats)) {
			foreach ($cats as $key => $val) {
				$items = $this->db->QFetchRowArray("
					SELECT * FROM 
						{$this->tables['plugin:testimonials_items']} as p , 
						{$this->tables['plugin:testimonials_items_lang']} as l
					WHERE
						p.item_id = l.item_id and 
						l.lang_id = {$this->tpl_module[lang_id]} AND 
						find_in_set({$val[cat_id]}  , p.item_cat) 
				");

				if (is_array($items)) {
					foreach ($items as $k => $v) {

						$v["link"] = 	$this->plugins["modules"]->BuildLink(array(
							"type"	=> $v["item_link_type"],
							"link"	=> $v["item_link_link"],
							"module"=> $v["item_link_module"],
							"global"=> $v["item_link_global"]
						));

						$items[$k]["image"] = $this->_t("onepage")->blockReplace($v["item_image"] ? "Image" : "NoImage", $v);				
						$items[$k]["_name"] = $this->_t("onepage")->blockReplace($v["link"] ? "NameLink" : "NameNoLink" , $v);
						$items[$k]["_company"] = $v["item_company"] ? $this->_t("onepage")->blockReplace("Company" , $v) : "";
					}			
				}


				$cats[$key]["items"] = $base->html->table(
					$this->_t("onepage"),
					"Items",
					$items,
					$val
				);

				$cats[$key]["_title"]	= $this->tpl_module["settings"]["set_title"] == "1" ? $this->_t("onepage")->blockReplace("CatTitle" , $val) : "";
			}
			
		}

		$this->SetComments($this->tpl_module["settings"]["set_comments"], array("link" => $this->tpl_module["link"]));

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),

			$this->_t("onepage")->blockREplacE(
				"Main" , 
				array(
					"items"		=> $base->html->table(
						$this->_t("onepage"),
						"Cats" , 
						$cats
					),

					"_title"	=> $text["text_block_1_title"] ? $this->_t("onepage")->blockReplace("MainTitle" , $text) : "",

				), 
				$text,				
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SitemapGetMaps($module , $lang) {

		if ($module["mod_id"]) {
			return array($module["mod_id"] => true);
		} else {
			return array($module["module_code"] => true);
		}
		
	}


	function SitemapGetLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);
	}

}
