
DROP TABLE IF EXISTS `site_core_languages`;
CREATE TABLE IF NOT EXISTS `site_core_languages` (
  `lang_id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_order` int(11) NOT NULL,
  `lang_code` varchar(3) NOT NULL,
  `lang_title` varchar(255) NOT NULL,
  `lang_status` int(1) NOT NULL,
  `lang_dir` varchar(3) NOT NULL,
  `lang_default` int(1) NOT NULL,
  `lang_locale` text NOT NULL,
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `lang_id` (`lang_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

INSERT INTO `site_core_languages` (`lang_id`, `lang_order`, `lang_code`, `lang_title`, `lang_status`, `lang_dir`, `lang_default`, `lang_locale`) VALUES
(1, 0, 'en', 'English', 1, 'ltr', 1, ''),
(4, 4, 'ar', 'عربي', 1, 'rtl', 0, ''),
(8, 8, 'fr', 'French', 1, 'ltr', 0, '');

DROP TABLE IF EXISTS `site_core_languages_vars`;
CREATE TABLE IF NOT EXISTS `site_core_languages_vars` (
  `var_id` int(11) NOT NULL AUTO_INCREMENT,
  `var_name` varchar(100) NOT NULL,
  `var_protected` int(1) NOT NULL,
  PRIMARY KEY (`var_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

INSERT INTO `site_core_languages_vars` (`var_id`, `var_name`, `var_protected`) VALUES
(1, 'COPYRIGHT', 1),
(2, 'Tesdt', 0),
(3, 'MONTH_JANUARY', 0),
(4, 'MONTH_MARCH', 0),
(5, 'MONTH_FEBRUARY', 0),
(6, 'MONTH_APRIL', 0),
(7, 'MONTH_MAY', 0),
(8, 'MONTH_JUNE', 0);

DROP TABLE IF EXISTS `site_core_languages_vars_lang`;
CREATE TABLE IF NOT EXISTS `site_core_languages_vars_lang` (
  `var_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `var_value` text NOT NULL,
  KEY `var_id` (`var_id`),
  KEY `lang_id` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `site_core_languages_vars_lang` (`var_id`, `lang_id`, `var_value`) VALUES
(1, 1, 'Copyright 2013 Deliver. All Rights Reserved.'),
(1, 4, '© جميع الحقوق محفوظة، مستشفى المقاصد العام، 2014'),
(1, 8, '© Tous droits réservés, 2014. AL-Makassed General Hospital'),
(2, 1, 'test'),
(3, 1, 'January'),
(4, 1, 'March'),
(5, 1, 'February'),
(6, 1, 'April'),
(7, 1, 'May'),
(8, 1, 'June');

DROP TABLE IF EXISTS `site_core_layouts`;
CREATE TABLE IF NOT EXISTS `site_core_layouts` (
  `layout_id` int(11) NOT NULL AUTO_INCREMENT,
  `layout_parent` int(11) NOT NULL,
  `layout_order` int(11) NOT NULL,
  `layout_name` varchar(255) NOT NULL,
  `layout_generic` int(1) NOT NULL,
  `layout_columns` int(2) NOT NULL,
  `layout_c1` int(2) NOT NULL,
  `layout_c2` int(2) NOT NULL,
  `layout_c3` int(2) NOT NULL,
  `layout_c4` int(2) NOT NULL,
  `layout_c5` int(2) NOT NULL,
  `layout_c6` int(2) NOT NULL,
  `layout_template` varchar(255) NOT NULL,
  `layout_system` int(1) NOT NULL,
  PRIMARY KEY (`layout_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=201 ;

INSERT INTO `site_core_layouts` (`layout_id`, `layout_parent`, `layout_order`, `layout_name`, `layout_generic`, `layout_columns`, `layout_c1`, `layout_c2`, `layout_c3`, `layout_c4`, `layout_c5`, `layout_c6`, `layout_template`, `layout_system`) VALUES
(1, 0, 1, 'Footer - Generic', 0, 4, 3, 3, 3, 3, 1, 1, '2', 1),
(2, 0, 2, 'Content - Generic', 1, 2, 9, 3, 1, 1, 1, 1, '1', 1),
(197, 0, 0, 'tralaaaaaaaaaaaa', 0, 0, 0, 0, 0, 0, 0, 0, '1', 0),
(196, 195, 196, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(195, 0, 0, 'wazaa', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(194, 193, 194, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(192, 191, 192, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(193, 0, 0, 'Clienti Test', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(190, 189, 190, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(189, 0, 0, 'Dex Faq', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(188, 187, 188, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(187, 0, 0, 'Del 2', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(186, 185, 186, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(185, 0, 0, 'Del 1', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(184, 182, 184, '', 0, 1, 12, 1, 1, 1, 1, 1, '2', 0),
(183, 182, 183, '', 0, 2, 6, 6, 1, 1, 1, 1, '1', 0),
(182, 0, 0, 'blog mihai replica cms', 0, 0, 0, 0, 0, 0, 0, 0, '1', 0),
(181, 180, 181, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(180, 0, 0, 'Clients', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(179, 178, 179, '', 0, 2, 3, 9, 1, 1, 1, 1, '1', 0),
(178, 0, 0, 'Account', 0, 0, 0, 0, 0, 0, 0, 0, '1', 0),
(177, 176, 177, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(176, 0, 0, 'Blog 2', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(175, 174, 175, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(174, 0, 0, 'Blog Test', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(173, 172, 173, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(172, 0, 0, 'Test', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(168, 167, 168, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(167, 0, 0, 'tralala', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(169, 0, 0, 'mihai layout', 0, 0, 0, 0, 0, 0, 0, 0, '1', 0),
(170, 169, 170, '', 0, 3, 6, 3, 3, 1, 1, 1, '1', 0),
(164, 163, 164, '', 0, 2, 8, 4, 1, 1, 1, 1, '1', 0),
(163, 0, 0, 'Portfolio', 0, 0, 0, 0, 0, 0, 0, 0, '1', 0),
(171, 169, 171, '', 0, 2, 6, 6, 1, 1, 1, 1, '2', 0),
(161, 160, 161, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(160, 0, 0, 'Stiri Fantastice', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(159, 158, 159, '', 0, 2, 9, 3, 1, 1, 1, 1, '1', 0),
(158, 0, 0, 'LInks', 0, 0, 0, 0, 0, 0, 0, 0, '1', 0),
(157, 156, 157, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(156, 0, 0, 'Gallery', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(155, 154, 155, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(154, 0, 0, 'FAQ', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(153, 2, 153, '', 0, 1, 12, 3, 3, 1, 1, 1, '1', 0),
(151, 150, 151, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(150, 0, 0, 'Clienti', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(149, 148, 149, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(148, 0, 0, 'Cel Mai Tare Blog', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(147, 146, 147, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(146, 0, 0, 'The second blog', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(145, 144, 145, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(144, 0, 0, 'The second test blog', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(143, 142, 143, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(142, 0, 0, 'tra la la', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(141, 140, 141, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(140, 0, 0, 'Another blog 22', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(139, 138, 139, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(138, 0, 0, 'Another blog 2', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(137, 136, 137, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(136, 0, 0, 'Another Blog', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(135, 134, 135, '', 0, 2, 9, 3, 0, 0, 0, 0, '', 0),
(134, 0, 0, 'Test Blog', 0, 0, 0, 0, 0, 0, 0, 0, '', 0),
(198, 197, 198, '', 0, 3, 5, 4, 3, 1, 1, 1, '1', 0),
(199, 0, 0, 'gigi', 0, 0, 0, 0, 0, 0, 0, 0, '1', 0),
(200, 199, 200, '', 0, 6, 2, 2, 2, 2, 2, 2, '1', 0);

DROP TABLE IF EXISTS `site_core_layouts_items`;
CREATE TABLE IF NOT EXISTS `site_core_layouts_items` (
  `layitem_id` int(11) NOT NULL AUTO_INCREMENT,
  `layitem_order` int(11) NOT NULL,
  `layitem_layout` int(11) NOT NULL,
  `layitem_widget` int(11) NOT NULL,
  `layitem_column` int(11) NOT NULL,
  PRIMARY KEY (`layitem_id`),
  KEY `layitem_order` (`layitem_order`,`layitem_layout`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=964 ;

INSERT INTO `site_core_layouts_items` (`layitem_id`, `layitem_order`, `layitem_layout`, `layitem_widget`, `layitem_column`) VALUES
(196, 520, 1, 8, 3),
(195, 520, 1, 9, 2),
(194, 520, 1, 9, 2),
(193, 520, 1, 3, 1),
(79, 520, 2, 2, 2),
(76, 520, 2, -1, 1),
(192, 520, 1, 9, 1),
(963, 963, 198, 70, 3),
(962, 962, 198, 64, 2),
(961, 961, 198, -1, 1),
(960, 960, 196, 99, 2),
(959, 959, 196, 98, 2),
(958, 958, 196, 101, 2),
(957, 957, 196, 97, 2),
(956, 956, 196, 100, 2),
(955, 955, 196, -1, 1),
(954, 954, 194, 0, 2),
(953, 953, 194, -1, 1),
(952, 952, 192, 69, 2),
(951, 951, 192, 73, 2),
(950, 950, 192, 75, 2),
(949, 949, 192, 68, 2),
(948, 948, 192, 71, 2),
(947, 947, 192, 67, 2),
(946, 946, 192, 70, 2),
(945, 945, 192, 89, 1),
(944, 944, 192, 73, 1),
(943, 943, 192, -1, 1),
(942, 942, 177, 69, 2),
(932, 932, 190, 0, 2),
(931, 931, 190, -1, 1),
(930, 930, 188, 85, 2),
(929, 929, 188, 84, 2),
(928, 928, 188, 87, 2),
(927, 927, 188, 83, 2),
(926, 926, 188, 86, 2),
(925, 925, 188, -1, 1),
(924, 924, 186, 79, 2),
(923, 923, 186, 78, 2),
(922, 922, 186, 81, 2),
(921, 921, 186, 77, 2),
(920, 920, 186, 80, 2),
(919, 919, 186, -1, 1),
(918, 918, 184, -1, 1),
(917, 917, 183, 70, 2),
(916, 916, 183, 68, 1),
(941, 941, 177, 73, 2),
(903, 903, 179, -1, 2),
(940, 940, 177, 75, 2),
(939, 939, 177, 68, 2),
(886, 886, 181, 0, 2),
(885, 885, 181, -1, 1),
(902, 902, 179, 74, 1),
(938, 938, 177, 71, 2),
(937, 937, 177, 67, 2),
(936, 936, 177, 70, 2),
(935, 935, 177, 89, 1),
(934, 934, 177, 73, 1),
(933, 933, 177, -1, 1),
(877, 877, 175, 63, 2),
(876, 876, 175, 62, 2),
(875, 875, 175, 65, 2),
(874, 874, 175, 61, 2),
(873, 873, 175, 64, 2),
(872, 872, 175, -1, 1),
(871, 871, 173, 57, 2),
(870, 870, 173, 56, 2),
(869, 869, 173, 59, 2),
(868, 868, 173, 55, 2),
(867, 867, 173, 58, 2),
(866, 866, 173, -1, 1),
(865, 865, 171, 50, 2),
(864, 864, 171, 52, 2),
(863, 863, 171, 53, 1),
(862, 862, 171, 52, 1),
(861, 861, 170, 52, 3),
(860, 860, 170, 53, 3),
(856, 856, 168, 0, 2),
(855, 855, 168, -1, 1),
(857, 857, 170, -1, 1),
(858, 858, 170, 2, 2),
(852, 852, 164, 53, 2),
(851, 851, 164, -1, 1),
(859, 859, 170, 7, 2),
(849, 849, 161, 52, 2),
(848, 848, 161, -1, 1),
(847, 847, 159, 51, 2),
(846, 846, 159, -1, 1),
(845, 845, 157, 50, 2),
(844, 844, 157, 0, 2),
(843, 843, 157, -1, 1),
(842, 842, 155, 0, 2),
(841, 841, 155, -1, 1),
(840, 840, 153, -1, 1),
(839, 839, 152, -1, 1),
(838, 838, 151, 0, 2),
(837, 837, 151, -1, 1),
(836, 836, 149, 45, 2),
(835, 835, 149, 44, 2),
(834, 834, 149, 47, 2),
(833, 833, 149, 43, 2),
(832, 832, 149, 46, 2),
(831, 831, 149, -1, 1),
(830, 830, 147, 39, 2),
(829, 829, 147, 38, 2),
(828, 828, 147, 41, 2),
(827, 827, 147, 37, 2),
(826, 826, 147, 40, 2),
(825, 825, 147, -1, 1),
(824, 824, 145, 33, 2),
(823, 823, 145, 32, 2),
(822, 822, 145, 35, 2),
(821, 821, 145, 31, 2),
(820, 820, 145, 34, 2),
(819, 819, 145, -1, 1),
(818, 818, 143, 27, 2),
(817, 817, 143, 26, 2),
(816, 816, 143, 29, 2),
(815, 815, 143, 25, 2),
(814, 814, 143, 28, 2),
(813, 813, 143, -1, 1),
(812, 812, 141, 21, 2),
(811, 811, 141, 20, 2),
(810, 810, 141, 23, 2),
(809, 809, 141, 19, 2),
(808, 808, 141, 22, 2),
(807, 807, 141, -1, 1),
(806, 806, 139, 15, 2),
(805, 805, 139, 14, 2),
(804, 804, 139, 17, 2),
(803, 803, 139, 13, 2),
(802, 802, 139, 16, 2),
(801, 801, 139, -1, 1),
(800, 800, 137, 9, 2),
(799, 799, 137, 8, 2),
(798, 798, 137, 11, 2),
(797, 797, 137, 7, 2),
(796, 796, 137, 10, 2),
(795, 795, 137, -1, 1),
(794, 794, 135, 3, 2),
(793, 793, 135, 2, 2),
(792, 792, 135, 5, 2),
(791, 791, 135, 1, 2),
(790, 790, 135, -1, 1);

DROP TABLE IF EXISTS `site_core_mail_emails`;
CREATE TABLE IF NOT EXISTS `site_core_mail_emails` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `email_code` varchar(50) NOT NULL,
  `email_status` int(11) NOT NULL,
  PRIMARY KEY (`email_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=35 ;

INSERT INTO `site_core_mail_emails` (`email_id`, `email_code`, `email_status`) VALUES
(1, 'account_confirm', 1),
(2, 'account_welcome', 1),
(3, 'account_forgot_password_link', 1),
(4, 'account_forgot_password_new', 1),
(8, 'account_pending_activation', 0),
(30, 'resume_admin', 1),
(17, 'contact_admin', 1),
(18, 'contact_client', 1),
(19, 'account_notify_admin', 1),
(31, 'resume_autoresponder', 1),
(32, 'addressbook_notify', 1),
(33, 'messaging_notify', 1),
(29, 'account_suspended', 1),
(34, 'maintenance_notify', 1);

DROP TABLE IF EXISTS `site_core_mail_emails_lang`;
CREATE TABLE IF NOT EXISTS `site_core_mail_emails_lang` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_id` int(11) NOT NULL,
  `email_subject` varchar(255) NOT NULL,
  `email_from` varchar(255) NOT NULL,
  `email_from_name` varchar(255) NOT NULL,
  `email_to` varchar(255) NOT NULL,
  `email_to_name` varchar(255) NOT NULL,
  `email_body` text NOT NULL,
  KEY `email_id` (`email_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=35 ;

INSERT INTO `site_core_mail_emails_lang` (`email_id`, `lang_id`, `email_subject`, `email_from`, `email_from_name`, `email_to`, `email_to_name`, `email_body`) VALUES
(1, 1, 'Please confirm your account', 'no-reply@yoursite.web', 'Account', '{USER_EMAIL} {ORDER_SHIPPING_METHOD_NAME}{SITE:URL}user-reset.php?key={USER_KEY_CODE}', '{USER_FIRST_NAME} {USER_LAST_NAME}', '<p>Dear {USER_FIRST_NAME} {ORDER_BILLING_LAST_NAME},</p>\r\n\r\n<p>Welcome to our site</p>\r\n\r\n<p>user: {USER_EMAIL}<br />\r\npass: {USER_PASSWORD_PLAIN}<br />\r\n<br />\r\nConfirm Link: {SITE:URL}user-confirm.php?key={USER_KEY_CODE}</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>{SITE:URL}user-confirm.php?key={USER_KEY_CODE}</p>\r\n'),
(2, 1, 'Your account was activated', 'no-reply@yoursite.web', 'Account', '{USER_EMAIL}', '{USER_FIRST_NAME} {USER_LAST_NAME}', '<p>Dear {USER_FIRST_NAME},</p>\r\n<p>Welcome to our site</p>\r\n<p>user: {USER_EMAIL}</p>'),
(3, 1, 'Your password recovery link', 'no-reply@yoursite.web', 'Accounts', '{USER_EMAIL}', '{USER_FIRST_NAME} {USER_LAST_EMAIL}', '<p>Link: {SITE:URL}user-reset.php?key={USER_KEY_CODE}</p>'),
(4, 1, 'Your new password', 'no-reply@yoursite.web', 'Your site name', '{USER_EMAIL}', '{USER_FIRST_NAME} {USER_LAST_EMAIL}', '<p>{USER_EMAIL}</p>\r\n<p>{USER_PASSWORD}</p>'),
(8, 1, 'Your acocunt is waiting for admin moderation', '', '', '', '', '<p>sasasa</p>'),
(30, 1, 'You received a new resume', '{EMAIL}', '{NAME}', 'emanuel@stempora.com', 'Emanuel GIurgea', '<p>Name:&nbsp;{NAME}</p>\r\n\r\n<p>Phone:&nbsp;{PHONE}</p>\r\n\r\n<p>Email: {EMAIL<span style="line-height: 1.6em;">}</span></p>\r\n\r\n<p>Message:</p>\r\n\r\n<p>{MESSAGE}</p>\r\n'),
(17, 1, 'You received a new message: {SUBJECT}', '{EMAIL}', '{NAME}', 'no-reply@yoursite.web', 'Emanuel Giurgea', '<p>Hello,</p>\r\n<p>You received a new message:</p>\r\n<p>Name: {NAME}</p>\r\n<p>Email:{EMAIL}</p>\r\n<p>Subject:{SUBJECT}</p>\r\n<p>Body:</p>\r\n<p>{MESSAGE}</p>'),
(18, 1, 'Thank you for contacting us', 'no-reply@yoursite.web', 'Autoresponder', '{EMAIL}', '{NAME}', '<p>Hello {NAME},</p>\r\n<p>Thank you for contacting us, You will be contacted by one of our representatives asap.</p>'),
(19, 1, 'New user registered on your site', '{USER_EMAIL}', '{USER_FIRST_NAME} {USER_LAST_NAME}', 'no-reply@yoursite.web', 'Emanuel', '<p>New user registerd on your site.</p>'),
(31, 1, 'We received your resume', 'jobs@makasedhospital.org', 'Makassed', '{EMAIL}', '{NAME}', '<p>Thanks</p>\r\n'),
(32, 1, 'You received a new message', '{EMAIL}', '{NAME}', '{ITEM_EMAIL}', '{ITEM_FIRST_NAME} {ITEM_LAST_NAME}', '<p>Dear {ITEM_FIRST_NAME}</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>You received the following message</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Sender: {NAME}</p>\r\n\r\n<p>Email: {EMAIL}</p>\r\n\r\n<p>MEssage {MESSAGE}</p>\r\n\r\n<p>&nbsp;</p>\r\n'),
(33, 1, 'New message received: {MSG_SUBJECT}', 'no-reply@makassedhospital.org', 'Notifier', '{USER_EMAIL}', '{USER_FIRST_NAME} {USER_LAST_NAME}', '<p>You received a new message from&nbsp;</p>\r\n\r\n<p>Sender:&nbsp;{USER_FIRST_NAME} {USER_LAST_NAME}</p>\r\n\r\n<p>Email: {USER_EMAIL}</p>\r\n\r\n<p>Message:</p>\r\n\r\n<p>{MSG_BODY}</p>\r\n\r\n<p>Read More: {LINK}</p>\r\n'),
(29, 1, 'Your account was suspended', 'no-reply@yoursite.web', 'Account', '{USER_EMAIL}', '{USER_FIRST_NAME} {USER_LAST_NAME}', '<p>Dear {USER_FIRST_NAME},</p>\r\n<p>Your account was suspended please contact us at +01-555-OURSITE</p>\r\n<p>user: {USER_EMAIL}</p>'),
(34, 1, 'Invitation to test our website', 'maintenance@mgh.com.lb', 'Makassed General Hospital', '{USER_EMAIL}', '{USER_FIRST_NAME} {USER_LAST_NAME}', '<p>Dear {USER_FIRST_NAME}</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>We are ....</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Please click http://www.makassedhospital2.office.stempora.com/?invite={USER_KEY}&nbsp;to test our website before we go live.</p>\r\n');

DROP TABLE IF EXISTS `site_core_mail_queue`;
CREATE TABLE IF NOT EXISTS `site_core_mail_queue` (
  `mail_id` int(11) NOT NULL AUTO_INCREMENT,
  `mail_date` int(11) NOT NULL,
  `mail_date_sent` int(11) NOT NULL,
  `mail_from_name` varchar(255) NOT NULL,
  `mail_from_email` varchar(255) NOT NULL,
  `mail_to_name` varchar(255) NOT NULL,
  `mail_to_email` varchar(255) NOT NULL,
  `mail_subject` varchar(255) NOT NULL,
  `mail_body` text NOT NULL,
  `mail_type` varchar(4) NOT NULL,
  `mail_status` int(1) NOT NULL,
  `mail_priority` int(1) NOT NULL,
  PRIMARY KEY (`mail_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `site_core_modules`;
CREATE TABLE IF NOT EXISTS `site_core_modules` (
  `module_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_code` varchar(255) DEFAULT NULL,
  `module_type_name` varchar(255) NOT NULL,
  `module_type` int(1) DEFAULT NULL,
  `module_status` int(1) DEFAULT NULL,
  `module_help` text,
  `module_system` int(1) NOT NULL,
  `module_enabled` int(1) NOT NULL,
  `module_version` varchar(11) NOT NULL,
  `module_last_update` int(11) NOT NULL,
  `module_groups` text NOT NULL,
  `module_user_position` int(11) NOT NULL,
  `module_protected` int(1) NOT NULL,
  `module_users` text NOT NULL,
  `module_allow_linking` int(1) NOT NULL,
  `module_allow_onepage` int(1) NOT NULL,
  `module_allow_url` int(1) NOT NULL,
  `module_allow_protected` int(1) NOT NULL,
  PRIMARY KEY (`module_id`),
  KEY `module_code` (`module_code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1017 ;

INSERT INTO `site_core_modules` (`module_id`, `module_code`, `module_type_name`, `module_type`, `module_status`, `module_help`, `module_system`, `module_enabled`, `module_version`, `module_last_update`, `module_groups`, `module_user_position`, `module_protected`, `module_users`, `module_allow_linking`, `module_allow_onepage`, `module_allow_url`, `module_allow_protected`) VALUES
(1, 'externallink', 'externallink', 1, 1, NULL, 1, 1, '1.0', 0, '', 0, 0, '', 0, 0, 0, 0),
(2, 'category', 'category', 1, 1, NULL, 1, 1, '1.0', 0, '', 0, 0, '', 0, 0, 0, 0),
(106, 'widgets', 'Widgets', 2, 1, NULL, 0, 0, '1.0', 1408840106, '', 0, 0, '', 0, 0, 0, 0),
(108, 'shortcodes', 'Shortcodes', 2, 1, NULL, 0, 0, '1.1', 1408840594, '', 0, 0, '', 0, 0, 0, 0),
(110, 'comments', 'User Comments', 2, 1, NULL, 0, 0, '1.0', 1408840371, '', 0, 0, '', 0, 0, 0, 0),
(133, 'clients', 'Clients List', 1, 1, NULL, 0, 0, '1.0', 1408842056, '', 0, 0, '', 0, 0, 0, 0),
(105, 'currency', 'Currency', 2, 1, NULL, 0, 0, '1.0', 1408842062, '', 0, 0, '', 0, 0, 0, 0),
(128, 'contact', 'Contact', 1, 1, NULL, 0, 0, '1.0', 1408842064, '', 0, 0, '', 0, 0, 0, 0);

DROP TABLE IF EXISTS `site_core_modules_lang`;
CREATE TABLE IF NOT EXISTS `site_core_modules_lang` (
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `module_name` varchar(255) DEFAULT NULL,
  `module_url` varchar(255) NOT NULL,
  KEY `module_id` (`module_id`),
  KEY `lang_id` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `site_core_modules_lang` (`module_id`, `lang_id`, `module_name`, `module_url`) VALUES
(1, 1, 'External Link', ''),
(2, 1, 'Category - Dropdown', ''),
(106, 1, 'Widgets', ''),
(108, 1, 'Shortcodes', ''),
(110, 1, 'User Comments', ''),
(133, 1, 'Clients List', ''),
(105, 1, 'Currency', ''),
(128, 1, 'Contact', '');

DROP TABLE IF EXISTS `site_core_modules_settings`;
CREATE TABLE IF NOT EXISTS `site_core_modules_settings` (
  `module` varchar(50) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `type` int(1) NOT NULL,
  `type_var` int(1) NOT NULL,
  `setting` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `default` text NOT NULL,
  `array` int(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `site_core_modules_settings` (`module`, `lang_id`, `type`, `type_var`, `setting`, `value`, `default`, `array`) VALUES
('3', 1, 2, 0, 'set_rss_description', 'Feed description', '', 0),
('3', 1, 2, 0, 'set_rss_title', 'Feed Name', '', 0),
('3', 0, 2, 0, 'set_layout_author', '174', '', 0),
('3', 0, 2, 0, 'set_layout_topic', '174', '', 0),
('3', 0, 2, 0, 'set_layout_search', '174', '', 0),
('5', 0, 2, 1, 'set_rss_webmaster_name', 'Webmaster Name', '', 0),
('5', 0, 2, 1, 'set_rss_webmaster', 'webmaster@your.site', '', 0),
('5', 1, 2, 2, 'lang_widget_topics_more', 'more', '', 0),
('3', 0, 2, 0, 'set_layout', '174', '', 0),
('3', 0, 2, 0, 'set_layout_archive', '174', '', 0),
('3', 0, 2, 0, 'set_slider', '', '', 0),
('3', 0, 2, 0, 'set_ipp_items', '5', '', 0),
('3', 0, 2, 0, 'set_rss_webmaster', 'webmaster@your.site', '', 0),
('5', 1, 2, 2, 'lang_widget_comments_more', 'more', '', 0),
('5', 1, 2, 2, 'lang_widget_search', 'Keyword', '', 0),
('5', 1, 2, 2, 'lang_widget_authors_more', 'more', '', 0),
('5', 1, 2, 2, 'lang_topic_cat', 'Categories: ', '', 0),
('5', 0, 2, 0, 'lang_author_topics', 'Topics: ', '', 0),
('5', 0, 2, 0, 'lang_widget_search', 'Keyword', '', 0),
('5', 0, 2, 0, 'lang_widget_topics_more', 'more', '', 0),
('5', 0, 2, 0, 'lang_widget_comments_more', 'more', '', 0),
('5', 0, 2, 0, 'lang_widget_authors_more', 'more', '', 0),
('5', 0, 2, 0, 'lang_widget_archive', 'posts', '', 0),
('5', 0, 2, 0, 'lang_author_about', 'About author - ', '', 0),
('5', 0, 2, 0, 'lang_slider_photos', 'Photos', '', 0),
('5', 0, 2, 0, 'lang_topic_by', 'By: ', '', 0),
('5', 1, 2, 0, 'lang_archive', 'Archive {MONTH} {YEAR}', '', 0),
('5', 1, 2, 0, 'lang_archive_page', 'Archive {MONTH} {YEAR} - Page {PAGE}', '', 0),
('5', 1, 2, 0, 'lang_archive_seo_title', 'Archive', '', 0),
('5', 1, 2, 0, 'lang_search', 'Results for {Q}', '', 0),
('5', 1, 2, 0, 'lang_search_page', 'Results for {Q} - Page {PAGE}', '', 0),
('5', 1, 2, 0, 'lang_search_seo_title', 'Results for {Q}', '', 0),
('5', 0, 2, 0, 'set_ipp_items', '5', '', 0),
('5', 0, 2, 0, 'set_rss_webmaster', 'webmaster@your.site', '', 0),
('5', 0, 2, 0, 'set_rss_items', '10', '', 0),
('5', 0, 2, 0, 'set_rss_webmaster_name', 'Webmaster Name', '', 0),
('5', 1, 2, 0, 'set_rss_title', 'Feed Name', '', 0),
('5', 0, 2, 0, 'set_layout_topic', '176', '', 0),
('5', 0, 2, 0, 'set_layout_author', '176', '', 0),
('5', 0, 2, 0, 'set_layout_search', '176', '', 0),
('5', 0, 2, 0, 'set_layout_archive', '176', '', 0),
('5', 0, 2, 0, 'set_layout', '176', '', 0),
('5', 0, 2, 0, 'set_slider', '', '', 0),
('5', 1, 2, 0, 'lang_author_page', 'Topics by {AUTHOR_NAME} - Page {PAGE}', '', 0),
('5', 0, 2, 0, 'lang_author_other', 'Other posts by this author', '', 0),
('5', 1, 2, 0, 'lang_author', 'Topics by {AUTHOR_NAME}', '', 0),
('5', 0, 2, 0, 'lang_topic_cat', 'Categories: ', '', 0),
('3', 0, 2, 0, 'set_comments', '1', '', 0),
('5', 1, 2, 0, 'set_rss_description', 'Feed description', '', 0),
('5', 1, 2, 2, 'lang_widget_archive', 'posts', '', 0),
('5', 1, 2, 2, 'lang_topic_by', 'By: ', '', 0),
('5', 1, 2, 2, 'lang_slider_photos', 'Photos', '', 0),
('5', 0, 2, 0, 'set_comments', '1', '', 0),
('3', 0, 2, 0, 'set_rss_webmaster_name', 'Webmaster Name', '', 0),
('3', 0, 2, 0, 'set_rss_items', '10', '', 0),
('3', 0, 2, 0, 'lang_widget_topics_more', 'more', '', 0),
('3', 0, 2, 0, 'lang_widget_search', 'Keyword', '', 0),
('3', 0, 2, 0, 'lang_widget_comments_more', 'more', '', 0),
('3', 0, 2, 0, 'lang_widget_authors_more', 'more', '', 0),
('3', 0, 2, 0, 'lang_widget_archive', 'posts', '', 0),
('3', 0, 2, 0, 'lang_author_about', 'About author - ', '', 0),
('3', 0, 2, 0, 'lang_topic_by', 'By: ', '', 0),
('3', 0, 2, 0, 'lang_slider_photos', 'Photos', '', 0),
('3', 1, 2, 0, 'lang_archive', 'Archive {MONTH} {YEAR}', '', 0),
('3', 1, 2, 0, 'lang_archive_seo_title', 'Archive', '', 0),
('3', 1, 2, 0, 'lang_archive_page', 'Archive {MONTH} {YEAR} - Page {PAGE}', '', 0),
('3', 1, 2, 0, 'lang_search', 'Results for {Q}', '', 0),
('3', 1, 2, 0, 'lang_search_seo_title', 'Results for {Q}', '', 0),
('3', 1, 2, 0, 'lang_search_page', 'Results for {Q} - Page {PAGE}', '', 0),
('3', 1, 2, 0, 'lang_author', 'Topics by {AUTHOR_NAME}', '', 0),
('3', 1, 2, 0, 'lang_author_page', 'Topics by {AUTHOR_NAME} - Page {PAGE}', '', 0),
('3', 0, 2, 0, 'lang_author_topics', 'Topics: ', '', 0),
('3', 0, 2, 0, 'lang_author_other', 'Other posts by this author', '', 0),
('3', 0, 2, 0, 'lang_topic_cat', 'Categories: ', '', 0),
('5', 1, 2, 1, 'set_rss_description', 'Feed description', '', 0),
('5', 0, 2, 1, 'set_layout_topic', '176', '', 0),
('5', 1, 2, 1, 'set_rss_title', 'Feed Name', '', 0),
('5', 0, 2, 1, 'set_layout_search', '176', '', 0),
('5', 0, 2, 1, 'set_layout_author', '176', '', 0),
('5', 0, 2, 1, 'set_layout_archive', '176', '', 0),
('5', 0, 2, 1, 'set_layout', '176', '', 0),
('5', 0, 2, 1, 'set_slider', '', '', 0),
('5', 0, 2, 1, 'set_ipp_items', '5', '', 0),
('5', 0, 2, 1, 'set_comments', '1', '', 0),
('5', 1, 2, 2, 'lang_author_about', 'About author - ', '', 0),
('5', 1, 2, 2, 'lang_author_other', 'Other posts by this author', '', 0),
('5', 1, 2, 2, 'lang_author_topics', 'Topics: ', '', 0),
('5', 1, 2, 2, 'lang_author_page', 'Topics by {AUTHOR_NAME} - Page {PAGE}', '', 0),
('5', 1, 2, 2, 'lang_author', 'Topics by {AUTHOR_NAME}', '', 0),
('5', 1, 2, 2, 'lang_search_seo_title', 'Results for {Q}', '', 0),
('5', 1, 2, 2, 'lang_search_page', 'Results for {Q} - Page {PAGE}', '', 0),
('5', 1, 2, 2, 'lang_search', 'Results for {Q}', '', 0),
('5', 1, 2, 2, 'lang_archive_seo_title', 'Archive', '', 0),
('5', 0, 2, 2, 'redir_lang_id', '8', '', 0),
('5', 1, 2, 2, 'lang_archive', 'Archive {MONTH} {YEAR}', '', 0),
('5', 1, 2, 2, 'lang_archive_page', 'Archive {MONTH} {YEAR} - Page {PAGE}', '', 0),
('14', 0, 2, 0, 'set_comments', '1', '', 0),
('14', 1, 2, 0, 'set_rss_description', 'Feed description', '', 0),
('14', 1, 2, 0, 'set_rss_title', 'Feed Name', '', 0),
('14', 0, 2, 0, 'set_layout_topic', '195', '', 0),
('14', 0, 2, 0, 'set_slider', '', '', 0),
('14', 0, 2, 0, 'set_ipp_items', '5', '', 0),
('14', 0, 2, 0, 'set_layout_author', '195', '', 0),
('14', 0, 2, 0, 'set_layout_search', '195', '', 0),
('14', 0, 2, 0, 'set_layout_archive', '195', '', 0),
('14', 0, 2, 0, 'set_layout', '195', '', 0),
('14', 0, 2, 0, 'set_rss_webmaster', 'webmaster@your.site', '', 0),
('14', 0, 2, 0, 'set_rss_webmaster_name', 'Webmaster Name', '', 0),
('14', 0, 2, 0, 'set_rss_items', '10', '', 0),
('14', 0, 2, 0, 'lang_widget_topics_more', 'more', '', 0),
('14', 0, 2, 0, 'lang_widget_search', 'Keyword', '', 0),
('14', 0, 2, 0, 'lang_widget_comments_more', 'more', '', 0),
('14', 0, 2, 0, 'lang_widget_authors_more', 'more', '', 0),
('14', 0, 2, 0, 'lang_widget_archive', 'posts', '', 0),
('14', 0, 2, 0, 'lang_author_about', 'About author - ', '', 0),
('14', 0, 2, 0, 'lang_slider_photos', 'Photos', '', 0),
('14', 0, 2, 0, 'lang_topic_by', 'By: ', '', 0),
('14', 1, 2, 0, 'lang_archive', 'Archive {MONTH} {YEAR}', '', 0),
('14', 1, 2, 0, 'lang_archive_page', 'Archive {MONTH} {YEAR} - Page {PAGE}', '', 0),
('14', 1, 2, 0, 'lang_archive_seo_title', 'Archive', '', 0),
('14', 1, 2, 0, 'lang_search', 'Results for {Q}', '', 0),
('14', 1, 2, 0, 'lang_search_page', 'Results for {Q} - Page {PAGE}', '', 0),
('14', 1, 2, 0, 'lang_search_seo_title', 'Results for {Q}', '', 0),
('14', 0, 2, 0, 'lang_author_topics', 'Topics: ', '', 0),
('14', 1, 2, 0, 'lang_author', 'Topics by {AUTHOR_NAME}', '', 0),
('14', 1, 2, 0, 'lang_author_page', 'Topics by {AUTHOR_NAME} - Page {PAGE}', '', 0),
('14', 0, 2, 0, 'lang_author_other', 'Other posts by this author', '', 0),
('14', 0, 2, 0, 'lang_topic_cat', 'Categories: ', '', 0),
('5', 0, 2, 1, 'set_rss_items', '10', '', 0),
('clients', 0, 2, 1, 'set_ipp_items', '10', '', 0),
('comments', 1, 2, 2, 'lang_capcha_field', 'Capcha', '', 0),
('comments', 1, 2, 2, 'lang_name', 'Name', '', 0),
('comments', 1, 2, 2, 'lang_message', 'Message', '', 0),
('comments', 1, 2, 2, 'lang_email', 'E-mail', '', 0),
('comments', 1, 2, 2, 'lang_title', 'New Comment', '', 0),
('comments', 1, 2, 2, 'lang_title_reply', 'Reply...', '', 0),
('comments', 1, 2, 2, 'lang_button', 'Post Comment', '', 0),
('comments', 1, 2, 2, 'lang_button_reply', 'Post Reply', '', 0),
('comments', 1, 2, 2, 'lang_error_name', 'Please enter your name !', '', 0),
('comments', 1, 2, 2, 'lang_error_unknown', 'Unknown Error', '', 0),
('comments', 1, 2, 2, 'lang_error_parent', 'Invalid parent message !', '', 0),
('comments', 1, 2, 2, 'lang_error_mail', 'Please enter your email. It wont appear on site !', '', 0),
('comments', 1, 2, 2, 'lang_capcha', 'Invalid Verification Code', '', 0),
('comments', 1, 2, 2, 'lang_success', 'Comment successfuly posted !', '', 0),
('comments', 1, 2, 2, 'lang_error_message', 'Please enter your comment !', '', 0);

DROP TABLE IF EXISTS `site_core_modules_texts`;
CREATE TABLE IF NOT EXISTS `site_core_modules_texts` (
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `type` int(1) NOT NULL,
  `setting` varchar(255) NOT NULL,
  `value` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_core_modules_user`;
CREATE TABLE IF NOT EXISTS `site_core_modules_user` (
  `mod_id` int(11) NOT NULL AUTO_INCREMENT,
  `mod_parent` int(11) NOT NULL,
  `mod_order` int(11) NOT NULL DEFAULT '0',
  `mod_status` int(1) NOT NULL DEFAULT '0',
  `mod_invisible` int(1) NOT NULL,
  `mod_module` int(11) NOT NULL DEFAULT '0',
  `mod_module_code` varchar(255) DEFAULT NULL,
  `mod_settings` longtext,
  `mod_shopping` int(1) NOT NULL,
  `mod_protected` int(11) NOT NULL,
  `mod_background` int(1) NOT NULL,
  `mod_background_file` varchar(255) NOT NULL,
  `mod_set_protect_delete` int(1) NOT NULL,
  `mod_set_protect_seo` int(1) NOT NULL,
  `mod_set_protect_m` int(1) NOT NULL,
  `mod_users` text NOT NULL,
  `mod_user_position` int(11) NOT NULL,
  `mod_groups` text NOT NULL,
  `mod_global` varchar(255) NOT NULL,
  `mod_external_target` int(1) NOT NULL,
  `mod_onepage_theme` int(1) NOT NULL,
  `mod_onepage_bgcolor` varchar(10) NOT NULL,
  `mod_onepage_image` int(11) NOT NULL,
  `mod_onepage_bgtype` int(11) NOT NULL,
  PRIMARY KEY (`mod_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

INSERT INTO `site_core_modules_user` (`mod_id`, `mod_parent`, `mod_order`, `mod_status`, `mod_invisible`, `mod_module`, `mod_module_code`, `mod_settings`, `mod_shopping`, `mod_protected`, `mod_background`, `mod_background_file`, `mod_set_protect_delete`, `mod_set_protect_seo`, `mod_set_protect_m`, `mod_users`, `mod_user_position`, `mod_groups`, `mod_global`, `mod_external_target`, `mod_onepage_theme`, `mod_onepage_bgcolor`, `mod_onepage_image`, `mod_onepage_bgtype`) VALUES
(3, 2, 3, 1, 0, 131, 'blog', NULL, 0, 0, 0, '', 0, 0, 0, '', 0, '', '', 0, 0, '', 0, 0),
(2, 0, 4, 1, 0, 2, 'category', NULL, 0, 0, 0, '', 0, 0, 0, '', 0, '', '', 0, 0, '', 0, 0),
(4, 0, 2, 1, 0, 2, 'category', NULL, 0, 1, 0, '', 0, 0, 0, '', 0, '', '', 0, 0, '', 0, 0),
(5, 0, 5, 1, 0, 131, 'blog', NULL, 0, 0, 0, '', 0, 0, 0, '', 0, '', '', 0, 0, '', 0, 0),
(14, 0, 14, 1, 1, 131, 'blog', NULL, 0, 0, 0, '', 0, 0, 0, '', 0, '', '', 0, 0, '', 0, 0);

DROP TABLE IF EXISTS `site_core_modules_user_lang`;
CREATE TABLE IF NOT EXISTS `site_core_modules_user_lang` (
  `mod_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `mod_name` varchar(255) DEFAULT NULL,
  `mod_long_name` varchar(255) DEFAULT NULL,
  `mod_urltitle` varchar(255) DEFAULT NULL,
  `mod_url` varchar(255) DEFAULT NULL,
  `mod_subtitle` varchar(255) NOT NULL,
  `mod_external_link` text NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  KEY `mod_id` (`mod_id`),
  KEY `lang_id` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `site_core_modules_user_lang` (`mod_id`, `lang_id`, `mod_name`, `mod_long_name`, `mod_urltitle`, `mod_url`, `mod_subtitle`, `mod_external_link`, `seo_title`, `seo_desc`, `seo_meta`) VALUES
(2, 1, 'Dropdown Test', 'Dropdown Test', 'Dropdown Test', 'dropdown-test', '', '', '', '', ''),
(3, 1, 'Blog Test', 'Blog Test', 'Blog Test', 'blog-test', '', '', '', '', ''),
(4, 1, 'Dropdown 2', 'Dropdown 2', 'Dropdown 2', 'dropdown-2', '', '', '', '', ''),
(5, 1, 'Blog 2', 'Blog 2', 'Blog 2', 'blog-2', '', '', '', '', ''),
(4, 8, '', NULL, NULL, NULL, '', '', '', '', ''),
(4, 4, '', NULL, NULL, NULL, '', '', '', '', ''),
(5, 8, '', NULL, NULL, '', '', '', '', '', ''),
(14, 1, 'wazaa', 'wazaa', 'wazaa', 'wazaa', '', '', '', '', '');

DROP TABLE IF EXISTS `site_core_skins`;
CREATE TABLE IF NOT EXISTS `site_core_skins` (
  `skin_id` int(11) NOT NULL AUTO_INCREMENT,
  `skin_name` varchar(200) NOT NULL,
  `skin_status` int(1) NOT NULL,
  `skin_data` longtext NOT NULL,
  `skin_system` int(1) NOT NULL,
  `skin_css` longtext NOT NULL,
  PRIMARY KEY (`skin_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `site_core_skins` (`skin_id`, `skin_name`, `skin_status`, `skin_data`, `skin_system`, `skin_css`) VALUES
(1, 'Default Skin', 0, '', 1, '.news {\r\n  	background: red; \r\n  	color: #fff;\r\n  	invalid_prop: test;\r\n}\r\n\r\nglobal{\r\n  \r\n}\r\n\r\n/*comment */\r\n\r\n\r\nclass{\r\n  backgroung:alternate;\r\n  color\r\n  \r\n}');

DROP TABLE IF EXISTS `site_core_texts`;
CREATE TABLE IF NOT EXISTS `site_core_texts` (
  `module_id` int(11) NOT NULL,
  `sub_id` varchar(50) NOT NULL,
  `text_image` int(1) NOT NULL,
  KEY `module_id` (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `site_core_texts` (`module_id`, `sub_id`, `text_image`) VALUES
(1, '', 0),
(30, '', 0),
(33, '', 0),
(36, '', 0),
(37, '', 0),
(38, '', 0),
(39, '', 0),
(40, '', 0),
(42, '', 0),
(44, '', 0),
(45, '', 0),
(47, '', 0),
(48, '', 0),
(50, '', 0),
(51, '', 0),
(52, '', 0),
(53, '', 0),
(54, '', 0),
(16, '', 0),
(17, '', 0),
(19, '', 0),
(20, '', 0),
(21, '', 0),
(22, '', 0),
(23, '', 0),
(24, '', 0),
(25, '', 0),
(18, '', 0);

DROP TABLE IF EXISTS `site_core_texts_lang`;
CREATE TABLE IF NOT EXISTS `site_core_texts_lang` (
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `text_title` varchar(255) NOT NULL,
  `text_header` text NOT NULL,
  `text_footer` text NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` longtext NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  `text_title_page` varchar(255) NOT NULL,
  `text_header_page` text NOT NULL,
  `seo_title_page` text NOT NULL,
  `seo_desc_page` text NOT NULL,
  `seo_conv_head_page` text NOT NULL,
  `seo_conv_body_page` text NOT NULL,
  KEY `module_id` (`module_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `site_core_texts_lang` (`module_id`, `lang_id`, `text_title`, `text_header`, `text_footer`, `seo_title`, `seo_desc`, `seo_meta`, `seo_conv_head`, `seo_conv_body`, `text_title_page`, `text_header_page`, `seo_title_page`, `seo_desc_page`, `seo_conv_head_page`, `seo_conv_body_page`) VALUES
(44, 1, 'Frequently Asked Questions', '', '', 'Frequently Asked Questions', '', '', '', '', '', '', '', '', '', ''),
(40, 1, '', '', '', 'Contact Us', '', '', '', '', 'Send a message', '<p style="font-family: ''Alegreya Sans'', sans-serif;">Please don&#39;t heristate to contact us for more information about work.</p>\r\n\r\n<p style="font-family: ''Alegreya Sans'', sans-serif;">We&#39;d really love to hear from you so why not drop us an email and we&#39;ll get back to you as soon as we can.</p>\r\n', '', '', '', ''),
(1, 1, 'Latest News', '', '', 'Latest News', '', '', '', '', 'Latest News - {PAGE}', '', 'Latest News - {PAGE}', '', '', ''),
(42, 1, 'Our Team', '<p style="text-align: justify;">Legebantur sive illas triones. Diffundi habentem sectamque imagine. Radiis litora invasit auroram est porrexerat. Quia homini inposuit undis utramque emicuit orba cognati quoque. Recens formas quia orbem media. Nubibus nisi capacius valles suis campos figuras. Conversa colebat retinebat habitandae piscibus faecis bene terrarum.</p>\r\n\r\n<p style="text-align: justify;">Regio obsistitur sanctius nisi caeca toto metusque flamina sinistra. Inposuit secuit satus primaque secuit ad proxima locum discordia? Temperiemque liquidas recepta carentem cinxit hanc capacius mutastis. Titan ultima levitate ille mea bene. Sponte utque spectent coercuit. Forma ponderibus deerat mundo naturae aere spectent.</p>\r\n', '', 'Our Team', '', '', '', '', '', '', '', '', '', ''),
(39, 1, 'Links', '<p>Legebantur sive illas triones. Diffundi habentem sectamque imagine. Radiis litora invasit auroram est porrexerat. Quia homini inposuit undis utramque emicuit orba cognati quoque. Recens formas quia orbem media. Nubibus nisi capacius valles suis campos figuras. Conversa colebat retinebat habitandae piscibus faecis bene terrarum.</p>\r\n\r\n<p>Regio obsistitur sanctius nisi caeca toto metusque flamina sinistra. Inposuit secuit satus primaque secuit ad proxima locum discordia? Temperiemque liquidas recepta carentem cinxit hanc capacius mutastis. Titan ultima levitate ille mea bene. Sponte utque spectent coercuit. Forma ponderibus deerat mundo naturae aere spectent.</p>\r\n', '', 'Links', '', '', '', '', '', '', '', '', '', ''),
(30, 1, 'Our Clients', '', '', '', '', '', '', '', 'Our Clients', '', '', '', '', ''),
(47, 1, 'Welcome ', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(33, 1, 'Gallery', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(48, 1, 'Complex Page', '<p>Regna prima homo sibi surgere gravitate toto piscibus. Primaque astra sole non fossae? Eodem auroram! Rectumque emicuit supplex coeperunt. Derecti securae effervescere triones spisso deorum cetera. Aquae pronaque di effervescere onus. Peregrinum fuerant pondus rerum dixere membra. Videre erat posset: rudis recens limitibus.</p>\r\n', '<p>Cornua fuerat colebat uno humanas legebantur unus verba iuga. Nubes ensis altae. Arce ambitae erat aetas sublime invasit ponderibus quisque. Magni iners pondere mentisque. Uno formaeque. Rudis pinus. Terrenae campoque ab motura levius chaos: astra volucres. Obstabatque fronde peragebant spectent umentia premuntur animalibus?</p>\r\n', 'Complex Page', '', '', '', '', '', '', '', '', '', ''),
(45, 1, 'Text Page', '<p style="text-align: justify;">Regna prima homo sibi surgere gravitate toto piscibus. Primaque astra sole non fossae? Eodem auroram! Rectumque emicuit supplex coeperunt. Derecti securae effervescere triones spisso deorum cetera. Aquae pronaque di effervescere onus. Peregrinum fuerant pondus rerum dixere membra. Videre erat posset: rudis recens limitibus. Cornua fuerat colebat uno humanas legebantur unus verba iuga. Nubes ensis altae.</p>\r\n\r\n<p style="text-align: justify;">Arce ambitae erat aetas sublime invasit ponderibus quisque. Magni iners pondere mentisque. Uno formaeque. Rudis pinus. Terrenae campoque ab motura levius chaos: astra volucres. Obstabatque fronde peragebant spectent umentia premuntur animalibus? Modo aera solum flamina pinus vindice. Ventos aer! Habitandae terrarum quinta zonae. Circumdare os supplex. Sive caelumque vindice.</p>\r\n\r\n<p style="text-align: justify;">Deerat siccis exemit astra cinxit quem. Opifex librata nebulas sunt convexi otia pace fidem figuras. Aer illic tellure vos sorbentur grandia retinebat altae exemit frigida!</p>\r\n', '', '', '', '', '', '', '', '', '', '', '', ''),
(37, 1, 'Our services', '<p style="text-align: justify;">Regna prima homo sibi surgere gravitate toto piscibus. Primaque astra sole non fossae? Eodem auroram! Rectumque emicuit supplex coeperunt. Derecti securae effervescere triones spisso deorum cetera. Aquae pronaque di effervescere onus. Peregrinum fuerant pondus rerum dixere membra. Videre erat posset: rudis recens limitibus. Cornua fuerat colebat uno humanas legebantur unus verba iuga.</p>\r\n\r\n<p style="text-align: justify;">Nubes ensis altae. Arce ambitae erat aetas sublime invasit ponderibus quisque. Magni iners pondere mentisque. Uno formaeque. Rudis pinus. Terrenae campoque ab motura levius chaos: astra volucres. Obstabatque fronde peragebant spectent umentia premuntur animalibus? Modo aera solum flamina pinus vindice. Ventos aer! Habitandae terrarum quinta zonae. Circumdare os supplex. Sive caelumque vindice.</p>\r\n\r\n<p style="text-align: justify;">Deerat siccis exemit astra cinxit quem. Opifex librata nebulas sunt convexi otia pace fidem figuras. Aer illic tellure vos sorbentur grandia retinebat altae exemit frigida!</p>\r\n', '', 'Our services', '', '', '', '', '', '', '', '', '', ''),
(36, 1, 'Our Projects', '<p style="text-align: justify;">Caeli supplex occiduo sua in poena campos? Caeca fidem his hominum porrexerat igni. Circumfluus locavit cepit pendebat terram. Origine surgere. Campoque abscidit liquidum aeris acervo zephyro volucres oppida liquidum? Feras spisso occiduo nuper fert. Aquae nullaque longo di tanto astra solum subsidere imagine.</p>\r\n\r\n<p style="text-align: justify;">Magni sectamque passim tegi. Recepta aere ne fluminaque circumfluus. Liquidum omni occiduo fuerant unus occiduo. Regio vix mundo aquae fulminibus numero pinus opifex. Subdita animal. Fuit scythiam erat homo securae aethera fert. Pondere igni. Rudis summaque densior aeris homini pondus oppida sinistra secuit.</p>\r\n', '', 'Our Projects', '', '', '', '', '', '', '', '', '', ''),
(50, 1, 'Account Confirmed', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(51, 1, 'Invalid Confirm Link', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(52, 1, 'Invalid Reset Link', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(53, 1, 'Password Mailed', '', '', '', '', '', '', '', '', '', '', '', '', ''),
(54, 1, 'Sample Text', '<p>Sample Text</p>\r\n', '', '', '', '', '', '', '', '', '', '', '', ''),
(16, 1, 'Ce culoare are iarba?', '<p>verdeeeeeeeeeee</p>\r\n', '', 'Ce culoare are iarba?', '', '', '', '', '', '', '', '', '', ''),
(17, 1, 'Galeria vietii ma!', '', '', 'Galeria vietii ma!', '', '', '', '', '', '', '', '', '', ''),
(19, 1, 'Nume prima pagina', '', '', 'Nume prima pagina', '', '', '', '', 'Numele altei pagini', '', 'Numele altei pagini', '', '', ''),
(20, 1, 'Portofoliu meu e cel mai beton', '<p>Vreau 5 mii de dolari pe secunda ca sa-ti explic cum sta treaba bai newbie</p>\r\n', '', 'Portofoliu meu e cel mai beton', '', '', '', '', '', '', '', '', '', ''),
(21, 1, 'Eu servici tu servici ei/ele servici', '<p>#YOLO mother fuckers, no worky worky no money no love no yolo</p>\r\n', '', 'Servicii', '', '', '', '', '', '', '', '', '', ''),
(22, 1, 'What the fuck mada facka', '<p>fiind baiet&nbsp;<span style="font-family: ''Alegreya Sans'', sans-serif;">crasme cutreieram</span><br />\r\n<span style="font-family: ''Alegreya Sans'', sans-serif;">la scoala o pula ma duceam</span><br />\r\n<span style="font-family: ''Alegreya Sans'', sans-serif;">numai ma drogam si beam</span><br />\r\n<span style="font-family: ''Alegreya Sans'', sans-serif;">deci o pula eu faceam!</span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>acu stau si ma gandesc<br />\r\n<span style="font-family: ''Alegreya Sans'', sans-serif;">ce cacat sa mai manglesc</span><br />\r\n<span style="font-family: ''Alegreya Sans'', sans-serif;">inspiratia e o durere</span><br />\r\n<span style="font-family: ''Alegreya Sans'', sans-serif;">mai bine ma duc la o bere!&nbsp;</span></p>\r\n\r\n<p><span style="font-family: ''Alegreya Sans'', sans-serif;"><img alt="" src="http://i.imgur.com/olNoEis.jpg" style="width: 660px; height: 495px;" /></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', '', 'What the fuck mother fucker', '', '', '', '', '', '', '', '', '', ''),
(23, 1, 'Noi de dupa blocurile gri', '<p>Reprezent din gheto, te facem pacheto, daca nu esti atento. Giiiia!</p>\r\n', '', 'Noi de dupa blocurile gri', '', '', '', '', '', '', '', '', '', ''),
(25, 1, 'Creatia lu'' NADIM', '<p>I run IT development projects on all continents and the moon!</p>\r\n', '<p>I want it windows 8 style with a WAW&nbsp;effect!</p>\r\n', 'Creatia lu'' NADIM', '', '', '', '', '', '', '', '', '', '');

DROP TABLE IF EXISTS `site_core_vars`;
CREATE TABLE IF NOT EXISTS `site_core_vars` (
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `default_value` longtext NOT NULL,
  `autoload` int(1) NOT NULL,
  `cond_1` int(11) NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `site_core_vars` (`name`, `value`, `default_value`, `autoload`, `cond_1`) VALUES
('set_swiftp_smtp_port', '', '', 0, 0),
('set_swiftp_smtp_auth', '', '', 0, 0),
('set_swiftp_smtp_auth_username', '', '', 0, 0),
('set_swiftp_smtp_auth_password', '', '', 0, 0),
('set_swiftp_smtp_enc', 'none', '', 0, 0),
('set_swiftp_sendmail', '', '', 0, 0),
('set_send_block', '', '', 0, 0),
('set_links_type', '1', '1', 1, 0),
('set_multilanguage', '1', '', 1, 0),
('set_language', 'en', '', 1, 0),
('set_switft_transport', 'php', '', 0, 0),
('set_swiftp_smtp_server', '', '', 0, 0),
('request_uri', '/admin/index.php?mod=redirects&sub=robots&action=edit&module_id=&returnurl=%252Fadmin%252Findex.php%253Fmod%253Dredirects%2526sub%253Drobots', '', 0, 0),
('lang_id', '1', '', 0, 0),
('set_google_wa', '', '', 0, 0),
('set_google_analytics_tracker', '', '', 0, 0),
('set_facebook_app', '1463833293853443', '', 1, 0),
('set_facebook_secret', '7fb699020be69b73449696b5d6e4907f', '', 1, 0),
('set_facebook_admins', '', '', 1, 0),
('set_facebook', '0', '', 1, 0),
('set_robots', 'User-agent: *', '', 1, 0),
('returnurl', '%252Fadmin%252Findex.php%253Fmod%253Dredirects%2526sub%253Drobots', '', 0, 0),
('set_global_license_valid', '1', '', 1, 0),
('set_global_domain', '', '', 1, 0),
('forms_core_images_process', '', '', 0, 0),
('set_global_license', '1555-23563-2642-2354', '', 0, 0),
('comment', '', '', 0, 0),
('set_google_wa_code', '', '', 0, 0),
('set_google_analytics_status', '0', '', 0, 0),
('set_google_analytics_id', '', '', 0, 0),
('set_google_analytics_code_type', '1', '', 0, 0),
('set_google_analytics_script', '', '', 0, 0),
('subtitle', '', '', 0, 0);

DROP TABLE IF EXISTS `site_core_widgets`;
CREATE TABLE IF NOT EXISTS `site_core_widgets` (
  `widget_id` int(11) NOT NULL AUTO_INCREMENT,
  `widget_type` int(11) NOT NULL,
  `widget_type_name` varchar(255) NOT NULL,
  `widget_module` int(11) NOT NULL,
  `widget_module_type` int(1) NOT NULL,
  `widget_settings` longtext NOT NULL,
  `widget_status` int(1) NOT NULL,
  `widget_system` int(1) NOT NULL,
  `widget_cache` int(11) NOT NULL,
  `widget_show_title` int(1) NOT NULL,
  `widget_perm` int(1) NOT NULL,
  `widget_perm_groups` text NOT NULL,
  `widget_perm_memberships` text NOT NULL,
  PRIMARY KEY (`widget_id`),
  KEY `widget_module` (`widget_module`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=105 ;

INSERT INTO `site_core_widgets` (`widget_id`, `widget_type`, `widget_type_name`, `widget_module`, `widget_module_type`, `widget_settings`, `widget_status`, `widget_system`, `widget_cache`, `widget_show_title`, `widget_perm`, `widget_perm_groups`, `widget_perm_memberships`) VALUES
(-1, 0, 'System - Module Content', 0, 0, '', 1, 1, 0, 1, 0, '', ''),
(91, 6, 'Search Box', 5, 1, '', 1, 0, 0, 1, 0, '', ''),
(92, 3, 'Latest Comments', 5, 1, '', 1, 0, 0, 1, 0, '', ''),
(93, 2, 'Facebook Like Box', 123, 2, 'YTo3OntzOjExOiJzZXRfZmJfbGluayI7czowOiIiO3M6MTM6InNldF9mYl9zY2hlbWUiO3M6NToibGlnaHQiO3M6MTM6InNldF9mYl9oZWlnaHQiO3M6MDoiIjtzOjEyOiJzZXRfZmJfZmFjZXMiO3M6MToiMCI7czoxMjoic2V0X2ZiX3Bvc3RzIjtzOjE6IjAiO3M6MTM6InNldF9mYl9oZWFkZXIiO3M6MToiMCI7czoxMzoic2V0X2ZiX2JvcmRlciI7czoxOiIwIjt9', 1, 0, 0, 1, 0, '', ''),
(89, 7, 'Archive Box', 5, 1, '', 1, 0, 0, 1, 0, '', ''),
(90, 9, 'Authors', 5, 1, '', 1, 0, 0, 1, 0, '', ''),
(103, 10, 'Author Detail', 3, 1, '', 1, 0, 0, 1, 0, '', ''),
(104, 2, 'Topics', 3, 1, '', 1, 0, 0, 1, 0, '', ''),
(94, 3, 'Links', 123, 2, '', 1, 0, 0, 1, 0, '', ''),
(95, 3, 'Links', 123, 2, '', 1, 0, 0, 1, 0, '', ''),
(96, 3, 'Links', 123, 2, '', 1, 0, 0, 1, 0, '', ''),
(97, 1, 'Labels', 14, 1, 'czo3OiIKCQkJCgkJIjs=', 1, 0, 0, 0, 0, '', ''),
(98, 2, 'Topics', 14, 1, 'YTozOntzOjg6InNldF90eXBlIjtzOjE6IjEiO3M6OToic2V0X2l0ZW1zIjtzOjE6IjMiO3M6OToic2V0X2NoYXJzIjtzOjM6IjIwMCI7fQ==', 1, 0, 0, 0, 0, '', ''),
(99, 3, 'Latest Comments', 14, 1, 'YToyOntzOjk6InNldF9pdGVtcyI7czoxOiIzIjtzOjk6InNldF9jaGFycyI7czozOiIyMDAiO30=', 1, 0, 0, 0, 0, '', ''),
(100, 6, 'Search', 14, 1, 'czo3OiIKCQkJCgkJIjs=', 1, 0, 0, 0, 0, '', ''),
(101, 7, 'Archive', 14, 1, 'czo3OiIKCQkJCgkJIjs=', 1, 0, 0, 0, 0, '', ''),
(102, 9, 'Authors', 14, 1, 'YToxOntzOjk6InNldF9jaGFycyI7czozOiIyMDAiO30=', 1, 0, 0, 0, 0, '', ''),
(76, 3, 'Links', 123, 2, '', 1, 0, 0, 1, 0, '', ''),
(75, 7, 'Archive Box', 5, 1, '', 1, 0, 0, 1, 0, '', ''),
(72, 9, 'Authors', 5, 1, 'YToxOntzOjk6InNldF9jaGFycyI7czozOiIyMDAiO30=', 1, 0, 0, 0, 0, '', ''),
(73, 6, 'Search Box', 5, 1, '', 1, 0, 0, 1, 0, '', ''),
(71, 7, 'Archive', 5, 1, 'czo3OiIKCQkJCgkJIjs=', 1, 0, 0, 0, 0, '', ''),
(70, 6, 'Search', 5, 1, 'czo3OiIKCQkJCgkJIjs=', 1, 0, 0, 0, 0, '', ''),
(69, 3, 'Latest Comments', 5, 1, 'YToyOntzOjk6InNldF9pdGVtcyI7czoxOiIzIjtzOjk6InNldF9jaGFycyI7czozOiIyMDAiO30=', 1, 0, 0, 0, 0, '', ''),
(68, 2, 'Topics', 5, 1, 'YTozOntzOjg6InNldF90eXBlIjtzOjE6IjEiO3M6OToic2V0X2l0ZW1zIjtzOjE6IjIiO3M6OToic2V0X2NoYXJzIjtzOjM6IjIwMCI7fQ==', 1, 0, 0, 0, 0, '', ''),
(66, 9, 'Authors', 3, 1, 'YToxOntzOjk6InNldF9jaGFycyI7czozOiIyMDAiO30=', 1, 0, 0, 0, 0, '', ''),
(67, 1, 'Labels', 5, 1, 'czo3OiIKCQkJCgkJIjs=', 1, 0, 0, 0, 0, '', ''),
(64, 6, 'Search', 3, 1, 'czo3OiIKCQkJCgkJIjs=', 1, 0, 0, 0, 0, '', ''),
(65, 7, 'Archive', 3, 1, 'czo3OiIKCQkJCgkJIjs=', 1, 0, 0, 0, 0, '', ''),
(63, 3, 'Latest Comments', 3, 1, 'YToyOntzOjk6InNldF9pdGVtcyI7czoxOiIzIjtzOjk6InNldF9jaGFycyI7czozOiIyMDAiO30=', 1, 0, 0, 0, 0, '', ''),
(62, 2, 'Topics', 3, 1, 'YTozOntzOjg6InNldF90eXBlIjtzOjE6IjEiO3M6OToic2V0X2l0ZW1zIjtzOjE6IjMiO3M6OToic2V0X2NoYXJzIjtzOjM6IjIwMCI7fQ==', 1, 0, 0, 0, 0, '', ''),
(61, 1, 'Labels', 3, 1, 'czo3OiIKCQkJCgkJIjs=', 1, 0, 0, 0, 1, '', '');

DROP TABLE IF EXISTS `site_core_widgets_acordeon`;
CREATE TABLE IF NOT EXISTS `site_core_widgets_acordeon` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `widget_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_link` varchar(255) NOT NULL,
  `item_link_target` varchar(10) NOT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `site_core_widgets_acordeon_lang`;
CREATE TABLE IF NOT EXISTS `site_core_widgets_acordeon_lang` (
  `item_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_body` text NOT NULL,
  `item_link_button` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_core_widgets_lang`;
CREATE TABLE IF NOT EXISTS `site_core_widgets_lang` (
  `widget_id` int(11) NOT NULL,
  `lang_id` int(2) NOT NULL,
  `widget_name` varchar(255) NOT NULL,
  `widget_set_lang` longtext NOT NULL,
  `widget_cache_data` longtext NOT NULL,
  `widget_cache_update` int(11) NOT NULL,
  KEY `widget_id` (`widget_id`),
  KEY `lang_id` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `site_core_widgets_lang` (`widget_id`, `lang_id`, `widget_name`, `widget_set_lang`, `widget_cache_data`, `widget_cache_update`) VALUES
(93, 1, 'Like Us', 'YToxOntzOjc6ImxhbmdfaWQiO3M6MToiMSI7fQ==', '', 0),
(89, 1, 'Test archive widget', 'YToxOntzOjc6ImxhbmdfaWQiO3M6MToiMSI7fQ==', '', 0),
(99, 1, 'Newest Comments', '', '', 0),
(98, 8, 'Latest Topics', '', '', 0),
(98, 4, 'Latest Topics', '', '', 0),
(-1, 1, 'System - Module Content', '', '', 0),
(98, 1, 'Latest Topics', '', '', 0),
(97, 8, 'Labels', '', '', 0),
(97, 4, 'Labels', '', '', 0),
(97, 1, 'Labels', '', '', 0),
(96, 1, 'ODDS & SCORES', 'YToxOntzOjc6ImxhbmdfaWQiO3M6MToiMSI7fQ==', '', 0),
(95, 1, 'POWER RANKINGS', 'YToxOntzOjc6ImxhbmdfaWQiO3M6MToiMSI7fQ==', '', 0),
(94, 1, 'EXPERT PICKS', 'YToxOntzOjc6ImxhbmdfaWQiO3M6MToiMSI7fQ==', '', 0),
(102, 8, 'Our Authors', '', '', 0),
(102, 4, 'Our Authors', '', '', 0),
(102, 1, 'Our Authors', '', '', 0),
(101, 8, 'Archive', '', '', 0),
(101, 4, 'Archive', '', '', 0),
(101, 1, 'Archive', '', '', 0),
(100, 8, 'Search', '', '', 0),
(100, 4, 'Search', '', '', 0),
(100, 1, 'Search', '', '', 0),
(99, 8, 'Newest Comments', '', '', 0),
(99, 4, 'Newest Comments', '', '', 0),
(76, 1, 'links widget', 'YToxOntzOjc6ImxhbmdfaWQiO3M6MToiMSI7fQ==', '', 0),
(75, 1, 'archive widget', 'YToxOntzOjc6ImxhbmdfaWQiO3M6MToiMSI7fQ==', '', 0),
(73, 1, 'Search the Blog', 'YToxOntzOjc6ImxhbmdfaWQiO3M6MToiMSI7fQ==', '\r\n					<div class="widget search">\r\n						<form action="http://flow_empty.templates.office.stempora.com/blog-2/search/" method="get">\r\n						<div class="input-group">\r\n								<input type="text" class="" name="q" placeholder="Keyword">\r\n								<span class="input-group-addon"><span class="icomoon icon-search"></span></span>\r\n						</div>\r\n						</form>\r\n					</div>\r\n', 1404310519),
(72, 8, 'Our Authors', '', '', 0),
(72, 4, 'Our Authors', '', '', 0),
(72, 1, 'Our Authors', '', '', 0),
(71, 8, 'Archive', '', '', 0),
(71, 4, 'Archive', '', '', 0),
(71, 1, 'Archive', '', '', 0),
(70, 8, 'Search', '', '', 0),
(70, 4, 'Search', '', '', 0),
(70, 1, 'Search', '', '', 0),
(69, 8, 'Newest Comments', '', '', 0),
(69, 4, 'Newest Comments', '', '', 0),
(69, 1, 'Newest Comments', '', '', 0),
(68, 8, 'Latest Topics', '', '', 0),
(68, 4, 'Latest Topics', '', '', 0),
(68, 1, 'Latest Topics', 'YToxOntzOjc6ImxhbmdfaWQiO3M6MToiMSI7fQ==', '', 0),
(67, 8, 'Labels', '', '', 0),
(67, 4, 'Labels', '', '', 0),
(67, 1, 'Labels', '', '', 0),
(66, 8, 'Our Authors', '', '', 0),
(66, 4, 'Our Authors', '', '', 0),
(66, 1, 'Our Authors', '', '', 0),
(65, 8, 'Archive', '', '', 0),
(65, 4, 'Archive', '', '', 0),
(65, 1, 'Archive', '', '', 0),
(64, 8, 'Search', '', '', 0),
(64, 4, 'Search', '', '', 0),
(64, 1, 'Search', '', '', 0),
(63, 8, 'Newest Comments', '', '', 0),
(63, 4, 'Newest Comments', '', '', 0),
(63, 1, 'Newest Comments', '', '', 0),
(62, 8, 'Latest Topics', '', '', 0),
(62, 4, 'Latest Topics', '', '', 0),
(62, 1, 'Latest Topics', '', '', 0),
(61, 8, 'Labels', '', '', 0),
(61, 4, 'Labels', '', '', 0),
(61, 1, 'Labels', 'YToxOntzOjc6ImxhbmdfaWQiO3M6MToiMSI7fQ==', '', 0);

DROP TABLE IF EXISTS `site_core_widgets_links`;
CREATE TABLE IF NOT EXISTS `site_core_widgets_links` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `widget_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_type` int(2) NOT NULL,
  `item_module` int(11) NOT NULL,
  `item_link` varchar(255) NOT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `site_core_widgets_links_lang`;
CREATE TABLE IF NOT EXISTS `site_core_widgets_links_lang` (
  `item_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_plugin_users`;
CREATE TABLE IF NOT EXISTS `site_plugin_users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_fbid` bigint(20) NOT NULL,
  `user_date` int(11) NOT NULL,
  `user_key` varchar(32) NOT NULL,
  `user_reserved` int(1) NOT NULL,
  `user_key_code` varchar(32) NOT NULL,
  `user_key_date` varchar(32) NOT NULL,
  `user_password` varchar(32) NOT NULL,
  `user_password_date` int(11) NOT NULL,
  `user_login` varchar(50) NOT NULL,
  `user_email` varchar(255) NOT NULL,
  `user_status` int(1) NOT NULL,
  `user_first_name` varchar(100) NOT NULL,
  `user_last_name` varchar(100) NOT NULL,
  `user_groups` text NOT NULL,
  `user_membership` int(11) NOT NULL,
  `user_membership_start` int(11) NOT NULL,
  `user_membership_expire` int(11) NOT NULL,
  `user_membership_log` int(11) NOT NULL,
  `user_register_ip` varchar(50) NOT NULL,
  `user_last_login` int(11) NOT NULL,
  `user_last_login_ip` varchar(50) NOT NULL,
  `user_company` varchar(100) NOT NULL,
  `user_phone` varchar(20) NOT NULL,
  `user_image` int(1) NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

DROP TABLE IF EXISTS `site_users`;
CREATE TABLE IF NOT EXISTS `site_users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_key` varchar(32) DEFAULT NULL,
  `user_key_date` int(11) NOT NULL,
  `user_first_name` varchar(200) DEFAULT NULL,
  `user_last_name` varchar(200) DEFAULT NULL,
  `user_login` varchar(200) NOT NULL,
  `user_password` varchar(200) DEFAULT NULL,
  `user_email` varchar(200) DEFAULT NULL,
  `user_level` int(1) NOT NULL DEFAULT '1',
  `user_protect_delete` int(1) NOT NULL DEFAULT '0',
  `user_protect_edit` int(1) NOT NULL DEFAULT '0',
  `user_log_last_login` int(11) NOT NULL DEFAULT '0',
  `user_log_last_ip` varchar(200) DEFAULT NULL,
  `user_log_create` int(11) NOT NULL DEFAULT '0',
  `user_log_tries` int(2) NOT NULL DEFAULT '0',
  `user_log_image_text` varchar(50) DEFAULT NULL,
  `user_log_status` int(1) NOT NULL DEFAULT '0',
  `user_contact_phone3` varchar(20) DEFAULT NULL,
  `user_contact_zip` varchar(20) DEFAULT NULL,
  `user_perm` text NOT NULL,
  `user_perm2` text NOT NULL,
  PRIMARY KEY (`user_id`),
  FULLTEXT KEY `user_login` (`user_login`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=19 ;

INSERT INTO `site_users` (`user_id`, `user_key`, `user_key_date`, `user_first_name`, `user_last_name`, `user_login`, `user_password`, `user_email`, `user_level`, `user_protect_delete`, `user_protect_edit`, `user_log_last_login`, `user_log_last_ip`, `user_log_create`, `user_log_tries`, `user_log_image_text`, `user_log_status`, `user_contact_phone3`, `user_contact_zip`, `user_perm`, `user_perm2`) VALUES
(17, '4DCC8B4C2284E5A0A8C8775DCE099065', 1391035655, 'Emanuel', 'Giurgea', 'demo', 'fe01ce2a7fbac8fafaed7c982a04e229', 'demo@stempora.com', 0, 0, 0, 1409072646, '64.150.251.91', 0, 0, '', 0, '', '', '', ''),
(18, NULL, 0, 'Test', '', 'test', '098f6bcd4621d373cade4e832627b4f6', 'test@stempora.com', 0, 0, 0, 1387150307, '172.20.100.3', 1384893395, 0, NULL, 0, NULL, NULL, '', '');

DROP TABLE IF EXISTS `site_users_log`;
CREATE TABLE IF NOT EXISTS `site_users_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `log_date` int(11) NOT NULL,
  `log_user` int(11) NOT NULL,
  `log_url` text NOT NULL,
  `log_ip` varchar(50) NOT NULL,
  `log_vars_post` longtext NOT NULL,
  `log_vars_get` longtext NOT NULL,
  `log_vars_files` longtext NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_date` (`log_date`),
  KEY `log_user` (`log_user`),
  KEY `log_date_2` (`log_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `site_core_skins_icons` (
  `icon_class` varchar(20) NOT NULL,
  `icon_name` varchar(50) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `site_core_skins_icons` (`icon_class`, `icon_name`) VALUES
('icomoon', 'Icomoon'),
('fa', 'Font Awesome');
