function PrettyPhotoInit() {

	//delete for reintialisation
	$("#gallery-working").remove();

	//create the holder to store hidden galleries
	var holder = $("<div />").attr("id" , "gallery-working").css("display" , "none");

	//append it to body
	$("body").append(holder);

	//use same trigger as pretty photo for easy replacement
	$("a[rel^=prettyPhoto]").each(function(){
		//ignore cloned elements from owl carousel if was initialised BEFORE gallery
		if ($(this).parents(".cloned").length > 0 ) {
		} else {
			//check if link has thumbnail attached ( if link inside image | usefull forhover effects with multiple icons inside photo )
			var attr = $(this).attr("data-tn");
			if (typeof attr !== typeof undefined)	{
				var img = $("<img />").attr("src" , $(this).attr("data-tn"));
			} else {
				//check if is image link
				if ($(this).find("img")){
					var img = $(this).find("img");
						//else check if youtube / video / vimeo
				} else {
					if ($(this).hasClass("has-video")) {
						var img = $("<img />").attr("src" , "assets/lightgallery/video.png");
					}
				}
			}
		}

		//append the image to gallery only if any resouce was detected
		if (typeof img != "undefined")	{

			var rel = $(this).attr("rel");
			rel = rel.replace("[" , "-");
			rel = rel.replace("]" , "-");

			var gal = $("#gallery-working").find("." + rel);
			var link = $("<a />").attr("href" , $(this).attr("href"));

			link.html("<img src='" + img.attr("src")+ "' />");

			//redirect click to the image from gallery
			$(this).click(function(e) {
				e.preventDefault();
				link.trigger("click");
			});

			if (gal.length > 0)	{
				gal.append(link);
			} else {
				var tmpgal = $("<div />");
				tmpgal.attr("class" , rel);
				tmpgal.append(link);
				holder.append(tmpgal);
			}

			if (holder.find(".rel")){
				holder.find("." + rel)
			}

		}
	});


	//initialize the gallery for each hidden one
	$("#gallery-working > div").each(function(){ 
		$(this).lightGallery({
			download:		false,
			fullScreen:		false,
			hash :			false,
			autoplay :		false,			
			autoplayControls: false,
			currentPagerPosition : "middle"
		});
	});	

}

$(document).ready(function() {
	PrettyPhotoInit();
});