<?php
	error_reporting(0);

	$conf = array(
		"autoload"		=> true,
		"distinct"		=> !file_exists("../../upload/conf/css_concatenate"),
		"compress"		=> file_exists("../../upload/conf/css_minify"),
	);



	// do not modify bellow this line.

	$prio = array(
		"font"			=> 0,
		"layout"		=> 1,
		"global"		=> 2,
		"plugin"		=> 3,
		"module"		=> 4,
		"widget"		=> 5,
		"custom"		=> 6,
	);



	require_once "../../admin/lib/debug.php";
	require_once "../../admin/lib/include/file.php";
	require_once "../../admin/lib/include/dir.php";

	if ($conf["compress"]) 
		require_once "../../admin/3rdparty/minify/css.php";

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function LoadFiles() {
		global $prio , $conf;

		$files = CDir::GetFiles("." , "css");

		if (is_array($files)) {
			foreach ($files as $key => $val) {
				$files[$key] = str_replace("./" , "" , str_replace(".css" , "" , $val));
			}

			sort($files);
	
			foreach ($files as $key => $val) {

				foreach ($prio as $k => $v) {
					if (substr($val , 0 , strlen($k)) == $k ) {
						$load[$v][] = $val;
					}					
				}
			}
			
		}

		ksort($load);
		$files = array();

		if (is_array($load)) {

			//preloade external fonts first
			if (file_exists("fonts.external.css")) {
				$files[] = "fonts.external.css";
			}			


			//process cache
			foreach ($load as $key => $val) {
				if (is_array($val)) {
					foreach ($val as $k => $v) {
						if ($v != "fonts.external") {
							$files[] = $v . ".css";
						}					
					}					
				}				
			}			


			foreach ($files as $key => $val) {
				if (($tmp =filectime($val)) > $lasttime) {
					$lasttime = $tmp;
				}				

				
			}
			
			
			$cache = "../../upload/_cache/{$lasttime}-" . (int)file_exists("../../upload/conf/css_concatenate") . "-" . (int)file_exists("../../upload/conf/css_minify"). "-" . md5(json_encode($files)) . ".css";

			if (!file_exists("../../upload/conf/css_cache") && file_exists($cache)) {
				return CFile::Get($cache);
			}

			foreach ($files as $key => $val) {

				if ($conf["distinct"]) {
					$content .= "@import url('{$val}'); \n";
				} else {
					$content .=  "\n" . compress(CFile::Get($val));	
				}		
			}

			if ($cache) {
				CFile::Save($cache , $content);
			}
			
		}

		return $content;		
	}
	
	function compress($buffer) {
		global $conf;

		if ($conf["compress"] == "true") {
			$buffer = CssMin::minify($buffer);
		}
		

	  return $buffer;
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessStyleCss() {
		global $conf;

		if (!file_exists("style.css")) {
			return LoadFiles();
		}
		

		$css = file("style.css");


		foreach ($css as $key => $val) {
			$val = trim($val);

			if ($val && stristr($val , "@import")) {
				$val = str_replace('@import url("' , "" , $val);
				$val = str_replace('");' , "" , $val);

				$files[] = $val;
			}			
		}


		foreach ($files as $key => $val) {

			if ($conf["distinct"]) {
				$content .= "@import url('{$val}'); \n";
			} else {
				$content .=  "\n" . compress(CFile::Get($val));	
			}		
		}

		return $content;
	}


	if ($conf["autoload"]) {
		$content = LoadFiles();
	} else {
		$content = ProcessStyleCss();
	}

		
	header("Content-type: text/css");
	header("Cache-Control: max-age=2692000, public");

    header("Content-Length: ".strlen($content)); 
	echo $content;
	die();
	

?>