<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CTestimonials extends CPlugin{
	
	var $tplvars; 

	function CTestimonials() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "testimonials") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"items"					=> "items.htm",
			"widget"				=> "widget.htm",
			"widget.large"			=> "widget.large.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {
		global $base;

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:testimonials_items']} as c,
				{$this->tables['plugin:testimonials_items_lang']} as l
			WHERE 				
				c.item_id=l.item_id AND 
				l.lang_id={$this->tpl_module[lang_id]} AND 
				c.module_id={$this->tpl_module[mod_id]}
			ORDER BY c.item_order ASC
			"
		);

		$text = $this->GetTexts();

		$this->module->plugins["seo"]->PageMeta(
			$text
		);


		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"	=>  $text["text_title"],
				"subtitle"	=>  $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$items[$key]["image"] = $val["item_image"] ? $this->private->templates["items"]->blockReplace("Image" , $val) : "";				

				$items[$key]["item_body"] = nl2br($val["item_body"]);

				if ($val["item_company"]) {
					$items[$key]["company"] = $this->private->templates["items"]->blockReplace($val["item_link"] ? "CompanyLink" : "CompanyNoLink" , $val);
				} else {
					$items[$key]["company"] = "";
				}
				
			}
			
		}
		
		if ($this->plugins["comments"]) {
			$text["comments"] = $this->module->plugins["comments"]->Comments(
				$this->tpl_module["link"],
				$this->tpl_module["settings"]["set_comments"]
			);
		} else {
			$text["comments"] = "";
		}


		$content = $this->private->templates["items"]->blockREplace(
			"Main" , 
			array(
				"content"	=> $base->html->Table(
					$this->private->templates["items"] , 
					"" , 
					$items
				)
			),
			$text,
			$this->tpl_module,
			$this->tpl_module["settings"]
		);
			

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$content
		);

	}
	


	function Widget($widget) {

		$this->__init();

		switch ($widget["widget_type"]) {
			case "1":
				return $this->widgetTestimonials($widget);
			break;

			case "2":
				return $this->widgetTestimonials($widget);
			break;

		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetTestimonials($widget) {

		$this->__init();

		$cnt = max(1, $widget["settings"]["set_items"]);

		switch ($widget["settings"]["set_sort"]) {
			default:
				$sort = " rand() ";
			break;

			case "2":
				$sort = " t.item_id DESC ";
			break;
		}
		

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM {$this->tables['plugin:testimonials_items']} as t , {$this->tables['plugin:testimonials_items_lang']} as l 
			WHERE t.module_id = {$widget[mod_id]} AND l.lang_id={$widget[lang_id]} AND t.item_id=l.item_id 
			ORDER BY {$sort}
			LIMIT $cnt
			"
		);

		if (is_array($items)) {

			global $base;

			switch ($widget["widget_type"]) {
				case "1":
					$template = &$this->private->templates["widget.large"];
				break;

				case "2":
					$template = &$this->private->templates["widget"];
				break;
			}
			

			foreach ($items as $key => $val) {
				$items[$key]["image"] = $val["item_image"] ? $template->blockReplace("Image" , $val) : "";				

				if ($val["item_company"]) {
					$items[$key]["company"] = $template->blockReplace($val["item_link"] ? "CompanyLink" : "CompanyNoLink" , $val);
				} else {
					$items[$key]["company"] = "";
				}

			}
			
			return $template->blockReplace(
				"Main" , 
				array(
					"title"	=> $widget["widget_name"],
					"testimonials"	=> $base->html->table(
						$template , 
						"" , 
						$items
					)
				),
				array(
					"slider" => $widget["settings"]["set_slider"] ? $template->blockReplace("Carousel") : "",
				)

			);
		}
		
	}
	

	function GetAllLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);
	}

}

?>