<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CTeam extends CPlugin{
	
	var $tplvars; 

	function CTeam() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "team") {


			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"list"					=> "list.htm",
			"widget"				=> "widget.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {

		global $base;
		

		$text = $this->getTexts();

		$this->plugins["seo"]->PageMeta($text);

			
		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module
		);

		$template = &$this->private->templates["list"];


		if ($this->plugins["comments"]) {
			$text["comments"] = $this->module->plugins["comments"]->Comments(
				$this->tpl_module["link"],
				$this->tpl_module["settings"]["set_comments"]
			);
		} else {
			$text["comments"] = "";
		}

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$this->getItems()
					)

				),
				$text,
				$this->tpl_module["settings"],
				$this->tpl_module
			)
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function getItems() {

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:team_items']} as i , 
				{$this->tables['plugin:team_items_lang']} as l 
			WHERE
				i.item_id = l.item_id and 
				i.module_id = {$this->tpl_module[mod_id]} AND 
				l.lang_id = {$this->tpl_module[lang_id]}

			ORDER BY 
				i.item_order ASC
			"
		);


		return $this->ProcessItems(
			$items , 
			$this->tpl_module["settings"] , 
			$this->private->templates["list"]
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessItems($items , $settings  , &$template) {

		$fields = array(
			"item_facebook"	=> "facebook",
			"item_twitter"	=> "twitter",
			"item_email"	=> "email",
			"item_gplus"	=> "gplus",
			"item_linkedin"	=> "linkedin",
			"item_skype"	=> "skype",
			"item_phone"	=> "phone",
			"item_cell"		=> "cell",
		);

		if (is_array($items)) {
			$cnt = 0;
			foreach ($items as $key => $val) {

				//process social profiles
				foreach ($fields as $k => $v) {
					if ($val[$k] && $template->blockExists($v)) {
						$items[$key][$v] = $template->BlockReplace($v , $val);
					} else {
						$items[$key][$v] =  "";
					}					
				}
				

				$cnt ++;
				$items[$key]["extra"] = "";

				$items[$key]["set_items_size"] = $settings["set_items_size"];

				$items[$key]["image"] = $val["item_image"] ? "upload/team/{$val[item_id]}.jpg" : "upload/default-images/team-person.png";
				$items[$key]["bg_image"] = $val["item_bg"] ? "upload/team/bg_{$val[item_id]}.jpg" : "upload/default-images/team-bg.jpg";

				switch ($settings["set_items_size"]) {
					case "12":
						if ($cnt == 1) {
							$cnt = 0;
							$items[$key]["extra"] = $template->blockReplace("Extra");
						}						
					break;

					case "6":
						if ($cnt == 2) {
							$cnt = 0;
							$items[$key]["extra"] = $template->blockReplace("Extra");
						}						
					break;

					case "4":
						if ($cnt == 3) {
							$cnt = 0;
							$items[$key]["extra"] = $template->blockReplace("Extra");
						}						
					break;

					case "3":
						if ($cnt == 4) {
							$cnt = 0;
							$items[$key]["extra"] = $template->blockReplace("Extra");
						}						
					break;
				}
				
			}
			
		}

		return $items;
		
	}
	

	

	function Widget($widget) {

		$this->__init();

		switch ($widget["widget_type"]) {
			case "1":
				return $this->widgetTeam($widget);
			break;
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetTeam($widget) {

		$this->__init();
		$template = &$this->private->templates["widget"];


		if ($widget["settings"]["set_show"] == "1") {
			$order = "rand()";
		} else {
			$order = "item_order ASC";
		}

		if (($widget["settings"]["set_show"] == "2") && $widget["settings"]["set_manual"]) {

			$cond = " AND i.item_id IN ({$widget['settings']['set_manual']} )";
		}
		

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:team_items']} as i , 
				{$this->tables['plugin:team_items_lang']} as l 
			WHERE
				i.item_id = l.item_id and 
				i.module_id = {$widget[mod_id]} AND 
				l.lang_id = {$widget[lang_id]} {$cond}
			ORDER BY 
				{$order}
			LIMIT {$widget[settings][set_items]}
			"
		);	


		$items = $this->ProcessItems(
			$items , 
			array(
				"set_items_size" => $widget["settings"]["set_size"]
			) , 
			$template
		);

		if (is_array($items)) {

			global $base;

			return $template->blockReplace(
				"Main" , 
				array(
					"items"	=> $base->html->table(
						$template , 
						"" , 
						$items
					)
				),
				$widget,
				$widget["settings"],
				$widget["mod_settings"]
			);
		}
		
	}


	function GetAllLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);
	}

}

?>