<?php
/*
	Stempora web framework
	copyright (c) 2002-2013 Stempora
		web:  www.oxylus.ro
		mail: support@oxylus.ro		

	$Id: name.php,v 0.0.1 dd/mm/yyyy hh:mm:ss oxylus Exp $
	description
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSocialMedia extends CPlugin{
	
	var $tplvars; 
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sharethis_services = array(
		"chiq" => "chiq",
		"messenger" => "Messenger",
		"kaboodle" => "Kaboodle",
		"foodlve" => "FoodLve",
		"friendfeed" => "FriendFeed",
		"fwisp" => "fwisp",
		"fresqui" => "Fresqui",
		"jumptags" => "Jumptags",
		"google_bmarks" => "Bookmarks",
		"google" => "Google",
		"google_translate" => "Google Translate",
		"google_reader" => "Google Reader",
		"instapaper" => "Instapaper",
		"hatena" => "Hatena",
		"mail_ru" => "mail.ru",
		"virb" => "Virb",
		"linkagogo" => "linkaGoGo",
		"livejournal" => "LiveJournal",
		"pocket" => "Pocket",
		"print" => "Print",
		"reddit" => "Reddit",
		"sina" => "Sina",
		"startaid" => "Startaid",
		"sonico" => "Sonico",
		"startlap" => "Startlap",
		"odnoklassniki" => "Odnoklassniki",
		"stumpedia" => "Stumpedia",
		"tumblr" => "Tumblr",
		"typepad" => "TypePad",
		"voxopolis" => "VOXopolis",
		"viadeo" => "Viadeo",
		"vkontakte" => "Vkontakte",
		"whatsapp" => "WhatsApp",
		"weheartit" => "We Heart It",
		"wordpress" => "WordPress",
		"xerpi" => "Xerpi",
		"nujij" => "NUjij",
		"netvouz" => "Netvouz",
		"n4g" => "N4G",
		"moshare" => "moShare",
		"flipboard" => "Flipboard",
		"meneame" => "Meneame",
		"fashiolista" => "Fashiolista",
		"dzone" => "DZone",
		"diigo" => "Diigo",
		"digg" => "Digg",
		"delicious" => "Delicious",
		"corkboard" => "Corkboard",
		"citeulike" => "CiteULike",
		"sharethis" => "ShareThis",
		"care2" => "Care2",
		"buddymarks" => "BuddyMarks",
		"blogger" => "Blogger",
		"blip" => "Blip",
		"blogmarks" => "Blogmarks",
		"blinklist" => "Blinklist",
		"baidu" => "Baidu",
		"arto" => "Arto",
		"att" => "AT&T",
		"amazon_wishlist" => "Amazon Wishlist",
		"allvoices" => "Allvoices",
		"fblike" => "Facebook Like",
		"fbsend" => "Facebook Send",
		"fbrec" => "Facebook Recommend",
		"facebook" => "Facebook",
		"twitter" => "Tweet",
		"linkedin" => "LinkedIn",
		"pinterest" => "Pinterest",
		"email" => "Email",
		"googleplus" => "Google +",
		"adfty" => "Adfty",
		"buffer" => "Buffer",
		"dealsplus" => "Dealspl.us",
		"evernote" => "Evernote",
		"edmodo" => "Edmodo",
		"fark" => "Fark",
		"folkd" => "folkd.com",
		"mister_wong" => "Mr Wong",
		"myspace" => "MySpace",
		"netlog" => "Netlog",
		"newsvine" => "Newsvine",
		"oknotizie" => "Oknotizie",
		"yammer" => "Yammer",
		"xing" => "Xing",
		"stumbleupon" => "StumbleUpon",
		"segnalo" => "Segnalo",
		"raise_your_voice" => "Raise Your Voice",
		"funp" => "Funp",

	);
	

	function CSocialMedia() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS , $_LANG;

		parent::DoEvents();		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"sharethis.head"						=> "sharethis.head.htm",
			"sharethis.bar.side"					=> "sharethis.bar.side.htm",
			"sharethis.buttons"						=> "sharethis.buttons.htm",

			"profiles"								=> "profiles.htm",
			"widget.profiles"						=> "widget.profiles.htm",
			"widget.share"							=> "widget.share.htm",

			"fblike"								=> "widget.fblike.htm",
			"twitter"								=> "widget.twitter.htm",

			"menu"									=> "menu.htm",
			"share"									=> "share.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("socialmedia");

		$this->items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:socialmedia_services']} as p,
				{$this->tables['plugin:socialmedia_services_lang']} as l
			WHERE
				p.service_id = l.service_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				service_status = 1 
			ORDER BY
				service_order
			"
		);


	} 




	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Share($link , $title = "" , $image = "" , $description = "") {
		global $base;

		$this->__init();

		$this->cnt ++;

		switch ($this->tpl_module["settings"]["set_service"]) {
			default:
				return $this->private->templates["share"]->blockReplace(
					"Main",
					array(
						"id"			=> $this->cnt,
						"title"			=> $title,
						"link"			=> $link,

						"set_theme"		=> $this->tpl_module["settings"]["set_theme"],
						"set_size"		=> $this->tpl_module["settings"]["set_size"],
						"set_label"		=> $this->tpl_module["settings"]["set_label"] ? "true" : "false",
						"set_count"		=> $this->tpl_module["settings"]["set_count"],
						"set_services"	=> str_replace("," , '","' , $this->tpl_module["settings"]["set_services"]),

					)
				);

			break;

			case "sharethis":
				if (
					$this->vars->data["set_sharethis_publisher"] && 
					stristr($this->vars->data["set_sharethis_display"] , "but_")) {
					return $this->ShareThisButtons();
				}
			break;

			case "addthis":
				if ($this->vars->data["set_addthis_display"]) {
					return $this->AddThisButtons();
				}
			break;
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ShowProfiles() {
		$this->__init();

		global $base;

		if (!is_array($this->items)) {
			return "";
		}
		

		foreach ($this->items as $key => $val) {
			if ($val["service_profile"]) {
				$profiles[] = $val;
			}			
		}
		

		if (!is_array($profiles)) {
			return "";
		}

		return $base->html->Table(
			$this->private->templates["profiles"],
			"" , 
			$profiles
		);
		
	}
	


	function onGlobalHooksExecute($module) {

		global $_TSM;

		//get all profiles

		$this->ShareThis();
		$this->AddThis();

	
		$_TSM["MODULE:SOCIAL_PROFILES"] = $this->ShowProfiles();

		$_TSM["PUB:SOCIAL_MENU"] = $this->Menu();
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Menu() {
		global $base;

		$this->__init();

		if (!$this->tpl_module["settings"]["set_menu"]) {
			return "";
		}
		

		if (is_array($this->items)) {

			foreach ($this->items as $key => $val) {
				if ($val["service_profile"]) {
					$items[] = $val;
				}
				
			}
			

			return is_array($items) ? $base->html->Table(
				$this->private->templates["menu"],
				"",
				$items				 
			) : "";
		}
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AddThis() {
		if ($this->vars->data["set_addthis_display"]) {
			$this->plugins["seo"]->AppendToBody($this->vars->data["set_addthis_body"]);			
		}
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ShareThis() {

		if (
			$this->vars->data["set_sharethis_publisher"] && 
			($this->vars->data["set_sharethis_in"] == "all") && 
			($this->vars->data["set_sharethis_display"] == "bar_2")) {

			$this->__init();

			$services = explode("," , $this->vars->data["set_sharethis_services"]);

			$this->plugins["seo"]->AppendToHead(
				$this->private->templates["sharethis.head"]->blockReplace(
					"Head",
					array(
						"publisher"	=> $this->vars->data["set_sharethis_publisher"],
					)
				)
			);
			$this->plugins["seo"]->AppedToBody(
				$this->private->templates["sharethis.bar.side"]->blockReplace(
					"Foot",
					array(
						"publisher"	=> $this->vars->data["set_sharethis_publisher"],
						"services"	=> implode('","' , $services),
						"position"	=> $this->vars->data["set_sharethis_position"],
					)
				)
			);
			
		}
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ShareThisButtons() {
		global $base;

		$this->__init();

		$services = explode("," , $this->vars->data["set_sharethis_services"]);

		switch ($this->vars->data["set_sharethis_display"]) {
			case "but_1":	$pref = $this->vars->data["set_sharethis_size"] == "16" ? "" : "_large";	break;
			case "but_2":	$pref = "_hcount";	break;
			case "but_3":	$pref = "_vcount";	break;
		}
		
		if (is_array($services)) {
			foreach ($services as $key => $val) {
				$service_data[] = array(
					"code"	=> $val ,
					"title"	=> $this->sharethis_services[$val],
					"pref"	=> $pref,
				);
			}			
		}
		

		$this->plugins["seo"]->AppedToHead(
			$this->private->templates["sharethis.head"]->blockReplace(
				"Head",
				array(
					"publisher"	=> $this->vars->data["set_sharethis_publisher"],
				)
			)
		);

		switch ($this->vars->data["set_sharethis_display"]) {
			case "bar_2":
				$this->plugins["seo"]->AppedToBody(
					$this->private->templates["sharethis.bar.side"]->blockReplace(
						"Foot",
						array(
							"publisher"	=> $this->vars->data["set_sharethis_publisher"],
							"services"	=> implode('","' , $services),
							"position"	=> $this->vars->data["set_sharethis_position"],
						)
					)
				);
			break;

			case "but_1":
			case "but_2":
			case "but_3":
				return $base->html->table(
					$this->private->templates["sharethis.buttons"],
					"" , 
					$service_data,
					array(
					)					
				);
			break;

		}
		
	}

		
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AddThisButtons() {
		switch ($this->vars->data["set_addthis_display"]) {
			case "but_2":
				return $this->vars->data["set_addthis_sitebar_buttons"];
			break;

			case "but_3":
				return $this->vars->data["set_addthis_sitebar_original"];
			break;
		}		
	}

	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Widget($widget) {

		if (!is_array($widget)) {
			return "";
		}
		

		$this->__init();

		switch ($widget["widget_type"]) {
			case "1":
				return $this->WidgetProfiles($widget);
			break;

			case "2":
				return $this->WidgetShare($widget);
			break;

			case "3":
				return $this->WidgetFacebook($widget);
			break;

			case "4":
				return $this->WidgetTwitter($widget);
			break;

		}

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function WidgetProfiles($widget) {
		global $base;

		$this->__init();

		$template = &$this->private->templates["widget.profiles"];


		if (!is_array($this->items)) {
			return "";
		}
		
		foreach ($this->items as $key => $val) {
			if ($val["service_profile"]) {
				$profiles[] = $val;
			}			
		}
		

		if (!is_array($profiles)) {
			return "";
		}

		return $template->blockREplace(
			"Main" , 
			array(
				"profiles"	=> $base->html->Table(
					$template,
					"" , 
					$profiles
				),
			),
			$widget,
			$widget["settings"]
		);

	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function WidgetShare($widget) {
		global $base;

		$this->__init();

		$template = &$this->private->templates["widget.share"];

		return $template->blockREplace(
			"Main" , 
			array(
				"set_label"	=> $widget["settings"]["set_label"] ? "true" : "false",
				"set_count"	=> $widget["settings"]["set_count"],
				"set_services"	=> str_replace("," , '","' , $widget["settings"]["set_services"]),
			),
			$widget,
			$widget["settings"]
		);

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetFacebook($widget) {
		$this->__init();

		return $this->private->templates["fblike"]->blockReplace(
			"Main",
			array(
				"link"				=> $widget["settings"]["set_fb_link"],
				"set_fb_posts"		=> $widget["settings"]["set_fb_posts"] == "1" ? "true" : "false",
				"set_fb_faces"		=> $widget["settings"]["set_fb_faces"] == "1" ? "true" : "false",
				"set_fb_hide_cover"		=> $widget["settings"]["set_fb_hide_cover"] == "1" ? "true" : "false",
				"set_fb_small_header"		=> $widget["settings"]["set_fb_small_header"] == "1" ? "true" : "false", 
				"set_fb_height"		=> $widget["settings"]["set_fb_height"], 

				"title"				=> $widget["widget_name"],
			)
		);
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetTwitter($widget) {

		global $base;

		External::Load("twitter");

		$tweet = new TweetPHP(array(
		  'consumer_key'              => $widget["settings"]["set_consumer_key"],
		  'consumer_secret'           => $widget["settings"]["set_consumer_secret"],
		  'access_token'              => $widget["settings"]["set_access_token"],
		  'access_token_secret'       => $widget["settings"]["set_access_secret"],
		  'twitter_screen_name'       => $widget["settings"]["set_screen_name"],
		  'cache_dir'				  => $_SERVER["DOCUMENT_ROOT"] . '/upload/tmp/cache/', // Where on the server to save cached tweets

		));
		

		$tweets = $tweet->get_tweet_array();

		if (!is_array($tweets) || !is_array($tweets[0])) {
			return "";
		}

		$template = &$this->private->templates["twitter"];

		

		foreach ($tweets as $key => $val) {

			$val["text"] = autolink($val["text"]);
			$val["text"] = preg_replace("/#([A-Za-z0-9\/\.]*)/", "<a target=\"_new\" href=\"http://twitter.com/search?q=$1\">#$1</a>", $val["text"]);

			$items[] = array(
				"user"	=> $val["user"]["screen_name"],
				"name"	=> $val["user"]["name"],
				"text"	=> $val["text"],
				"date"	=> date("F j, Y, g:i a", strtotime($val["created_at"])),
				"avatar"	=> str_replace("_normal" , "_bigger" , $val["user"]["profile_image_url_https"]),
			);
		}

		return $template->blockReplace(
			"Widget" , 
			array(
				"data"	=> $base->html->table(
					$template , 
					"",	
					$items
				),
			),
			$widget ,
			$widget["settings"]
		);
		

	}


}

?>