<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CServices extends CPlugin{
	
	var $tplvars; 

	function CServices() {
		//$this->CPlugin($db, $tables , $templates);

		$this->name = "services";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == $this->name) {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;

				case "details":
					return $this->Details();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"landing"				=> "landing.htm",

			"details"				=> "details.htm",
			"items"					=> "items.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {

		global $base;
		

		$text = $this->GetTexts();

		$this->module->plugins["seo"]->PageMeta(
			$text
		);

			
		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"	=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module
		);

		if ($this->plugins["comments"]) {
			$text["comments"] = $this->module->plugins["comments"]->Comments(
				$this->tpl_module["link"],
				$this->tpl_module["settings"]["set_comments"]
			);
		}
	


		$cats = $this->db->QFetchRowArray(
			"SELECT * FROM {$this->tables['plugin:services_items']} as i , {$this->tables['plugin:services_items_lang']} as l 
			WHERE i.cat_id = l.cat_id and l.lang_id = {$this->tpl_module[lang_id]} AND i.module_id={$this->tpl_module[mod_id]}
			ORDER BY cat_order ASC
			"
		);

		$template = &$this->private->templates["items"];

		if (is_array($cats)) {
			$cnt = 1;
			$delay = 1;

			switch ($this->tpl_module["settings"]["set_size"]) {
				case "12": 	$size = 1;	break;
				case "6": 	$size = 2;	break;
				case "4": 	$size = 3;	break;
				case "3": 	$size = 4;	break;
			}
			
			foreach ($cats as $key => $val) {
				$cnt ++;

				$cats[$key]["icon"] = $template->blockExists("Icon") && $val["cat_icon"] ? $template->blockReplace("Icon" , $val) : "";
				$cats[$key]["color"] = $val["cat_color"] ? $template->blockReplace("Color" , $val) : "";

				if ($cnt > $size) {
					$cnt = 1;
					$cats[$key]["extra"] = $template->blockReplace("Extra" , $val);
				} else {
					$cats[$key]["extra"] = "";
				}

				$cats[$key]["link"] = $this->tpl_module["link"] . $val["cat_url"] . "/";

				$cats[$key]["more"] = $val["cat_details_status"] ? $template->blockreplace("More" , $cats[$key]) : "";

				$delay += 0.3;

				$cats[$key]["delay"] = $delay;

				$cats[$key]["subtitle"] = $val["cat_subtitle"] ? $template->blockReplace("Subtitle" , $val) : "";

				if ($val["cat_options"]) {
					$tmp = explode("\n" , trim($val["cat_options"]));

					foreach ($tmp as $k => $v) {
						$tmp[$k] = array("title" => $v);;
					}

					$cats[$key]["options"] = $base->html->Table(
						$template , 
						"Options" , 
						$tmp
					);
					
				} else {
					$cats[$key]["options"] = "";
				}
				
				
			}			

			$text["items"] = $base->html->table(
				$template, 
				"" , 
				$cats
			);
		} else {
			$text["items"] = "";
		}
		
		if ($this->plugins["comments"]) {
			$text["comments"] = $this->module->plugins["comments"]->Comments(
				$this->tpl_module["link"],
				$this->tpl_module["settings"]["set_comments"]
			);
		} else {
			$text["comments"] = "";
		}

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockReplace(
				"Main" , 
				$text,
				$this->tpl_module["settings"],
				$this->tpl_module
			)
		);

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Details() {

		//first table must be the author as the seo fiels will be overwritted by the blog.
		$cat = $this->db->QFetchArray(
			"SELECT * FROM 
				{$this->tables['plugin:services_items']} as a , 
				{$this->tables['plugin:services_items_lang']} as al 
				
			WHERE
				a.cat_id = al.cat_id AND 
				al.lang_id = {$this->tpl_module[lang_id]} AND 
				a.module_id = {$this->tpl_module[mod_id]} AND
				cat_url LIKE '%s'",
				array(
					$_GET["cat"]
				)
		);


		if (!is_array($cat)) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}

		$this->module->plugins["seo"]->PageMeta(
			$cat
		);

		$text = $this->GetTexts();

		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"	=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"],
				$this->tpl_module["link"] . $cat["cat_url"] . "/"	=> $cat["cat_title"]
			)
		);

		
		if ($this->plugins["comments"]) {
			$cat["comments"] = $this->module->plugins["comments"]->Comments(
				$this->tpl_module["link"] . $cat["cat_url"] . "/",
				$this->tpl_module["settings"]["set_comments"]
			);
		} else {
			$cat["comments"] = "";
		}

	

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_details"],
				$this->tpl_module["mod_protected"]
			),
			$this->private->templates["details"]->blockREplacE(
				"Main" , 
				$cat,
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetAllLinks($module , &$links) {

		$links[] = array(
			"url" => $module["link"],
		);


		$items = $this->db->QFetchRowArray(
			"SELECT cat_url FROM 
				{$this->tables['plugin:services_items']} as i , 
				{$this->tables['plugin:services_items_lang']} as l 
			WHERE 
				i.cat_id = l.cat_id and 
				l.lang_id = {$module[lang_id]} AND 
				i.module_id={$module[mod_id]}
			"
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {

				if ($val["cat_details_status"]) {
					$links[] = array(
						"url"	=> $module["link"] . "{$val[cat_url]}/"			
					);
				}
				
			}			
		}
		
	}
}

?>