
DROP TABLE IF EXISTS `site_plugin_redirects`;
CREATE TABLE IF NOT EXISTS `site_plugin_redirects` (
  `redirect_id` int(11) NOT NULL AUTO_INCREMENT,
  `redirect_type` int(2) NOT NULL,
  `redirect_source` text NOT NULL,
  `redirect_code` varchar(20) NOT NULL,
  `redirect_destination` text NOT NULL,
  `redirect_clicks` int(11) NOT NULL,
  `redirect_date` int(11) NOT NULL,
  PRIMARY KEY (`redirect_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=453 ;

DROP TABLE IF EXISTS `site_plugin_redirects_stats`;
CREATE TABLE IF NOT EXISTS `site_plugin_redirects_stats` (
  `stat_id` int(11) NOT NULL AUTO_INCREMENT,
  `stat_redirect` int(11) NOT NULL,
  `stat_date` int(11) NOT NULL,
  `stat_from` text NOT NULL,
  `stat_ip` varchar(30) NOT NULL,
  `stat_hostname` varchar(255) NOT NULL,
  PRIMARY KEY (`stat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=723 ;


DROP TABLE IF EXISTS `site_plugin_redirects_pages`;
CREATE TABLE IF NOT EXISTS `site_plugin_redirects_pages` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_code` varchar(255) NOT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

INSERT INTO `site_plugin_redirects_pages` (`item_id`, `item_code`) VALUES
(3, '404'),
(4, '403');


DROP TABLE IF EXISTS `site_plugin_redirects_pages_lang`;
CREATE TABLE IF NOT EXISTS `site_plugin_redirects_pages_lang` (
  `item_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_details` longtext NOT NULL,
  `seo_title` text NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  KEY `item_id` (`item_id`),
  KEY `lang_id` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




INSERT INTO `site_plugin_redirects_pages_lang` (`item_id`, `lang_id`, `item_title`, `item_details`, `seo_title`, `seo_desc`, `seo_meta`, `seo_conv_head`, `seo_conv_body`) VALUES
(3, 1, 'Page not found', '<p>[errortitle]ERROR 404[/errortitle]</p>\r\n\r\n<p>It looks like the page doesn&#39;t exist or some other error occured.<br />\r\n<strong>Got to our <a href="{PUB:HOME_LINK}">home page</a> or go back to <a href="javascript:goBack();">previous page</a></strong></p>', 'Page not found', '', '', '', ''),
(4, 1, 'Page forbidden', '<p>[errortitle]ERROR 403[/errortitle]</p>\r\n\r\n<p>It looks like the page doesn&#39;t exist or some other error occured.<br />\r\n<strong>Got to our <a href="{PUB:HOME_LINK}">home page</a> or go back to <a href="javascript:goBack();">previous page</a></strong></p>\r\n', 'Page forbidden', '', '', '', '');

ALTER TABLE   `site_plugin_redirects_pages` ADD  `item_status` INT(1) DEFAULT '1' NOT NULL;
ALTER TABLE   `site_plugin_redirects_pages_lang` ADD  `item_subtitle` TEXT NOT NULL;