<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CRedirects extends CPlugin{	
	
	var $tplvars; 

	function CRedirects() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "redirects") {


			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {				
				case "detect":
					return $this->Detect();
				break;

				case "robots":
					return $this->Robots();
				break;

				case "errorpage":
					return $this->ErrorPage($_GET["code"] , true) ;
				break;
			}
		}

	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"page"	=> "page.htm"

		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("redirects");

	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Detect($url = null) {

		$this->__init();

		if ($url == null) {
		
			$url = $_SERVER["REDIRECT_URL"];
		}

		if (substr($url , 0 , 1 ) != "/") {
			$url = "/" . $url;
		}


		//check if there is any hadler for this url

		$rule = $this->db->QFetchArray(
			"SELECT * FROM {$this->tables['plugin:redirects']} WHERE redirect_source LIKE '%s'",
			array(
				$url
			)
		);


		if (is_Array($rule)) {

			//update the usese
			$this->db->QueryUpdate(
				$this->tables["plugin:redirects"],
				array(
					"redirect_clicks"	=> $rule["redirect_clicks"] + 1
				),
				"redirect_id = {$rule[redirect_id]}"
			);


			$this->RecordStat($rule["redirect_id"]);


			switch ($rule["redirect_code"]) {
				case "301":
				case "302":
					header ( "Location: {$rule[redirect_destination]} ", true, $rule["redirect_code"] );
					exit();
				break;

				default:
					//error codes will be treated at the end or mod_rewrite script
					//return $this->ErrorPage($rule["redirect_code"] , false , false);
				break;
			}
			
		} else {

			/*
			//save a new rule as 404 in the databas

			$id = $this->db->QueryInsert(
				$this->tables["plugin:redirects"],
				array(
					"redirect_source"	=> $url , 
					"redirect_code"		=> 404,
					"redirect_date"		=> time(),	//first record
					"redirect_type"		=> "2"	,	//automatic
					"redirect_clicks"	=> "1",
				)
			);

			$this->RecordStat($id);

			return $this->ErrorPage(404);
*/
		}
		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function RecordStat($rule_id) {
		$this->db->QueryInsert(
			$this->tables["plugin:redirects_stats"] , 
			array(
				"stat_redirect"	=> $rule_id , 
				"stat_date"		=> time(),
				"stat_from"		=> $_SERVER["HTTP_REFERER"],
				"stat_ip"		=> $_SERVER["REMOTE_ADDR"],
			)
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ErrorPage($code , $full = false , $record = true) {
		global $_PAGE , $_LANG_ID  , $_CONF ,$_LANG;


		if (!$_PAGE) {
			$_PAGE = $this->path . "pages/";
		}

		//debug($this->plugins["modules"]->modules,1);


		$_GET["module_id"] = "redirects";
		$_GET["mod"] = "redirects";
		$_GET["sub"] = "errorpage";
		
		$this->__init();
		$this->plugins["globalhooks"]->SetModule($this->tpl_module);

		if ($record = true) {

			$url = $_SERVER["REQUEST_URI"];

			//if its the main site dont record it 
			if (($url == "/") || ($url == "") || ($url == "/" . $_LANG . "/")) {
			} else {

				$rule = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:redirects']} WHERE redirect_source LIKE '%s'" , array($url));


				if (is_Array($rule)) {
					//update the usese
					$this->db->QueryUpdate(
						$this->tables["plugin:redirects"],
						array(
							"redirect_clicks"	=> $rule["redirect_clicks"] + 1
						),
						"redirect_id = {$rule[redirect_id]}"
					);

				} else {
					//save a new rule as 404 in the databas

					$id = $this->db->QueryInsert(
						$this->tables["plugin:redirects"],
						array(
							"redirect_source"	=> $url , 
							"redirect_code"		=> 404,
							"redirect_date"		=> time(),	//first record
							"redirect_type"		=> "2"	,	//automatic
							"redirect_clicks"	=> "1",
						)
					);
				}
			}

			$this->RecordStat($id);

		}		
		
		if (!$_LANG_ID) {
			$site->modules["languages"]->DefaultLang();
		}
		

		$page = $this->db->QFetchArray("
			SELECT * FROM 
				{$this->tables['plugin:redirects_pages']} as p, 
				{$this->tables['plugin:redirects_pages_lang']} as l 
			WHERE 
				item_code='{$code}' AND 
				p.item_id = l.item_id AND 
				l.lang_id={$_LANG_ID}
		");

		if (!is_array($page)) {
			$code = "404";
			$page = $this->db->QFetchArray("
				SELECT * FROM 
					{$this->tables['plugin:redirects_pages']} as p, 
					{$this->tables['plugin:redirects_pages_lang']} as l 
				WHERE 
					item_code='404' AND 
					p.item_id = l.item_id AND 
					l.lang_id={$_LANG_ID}
			");
		}


		$this->module->plugins["breadcrumb"]->Add(
			array(
				"show"		=> $page["item_status"],
				"title"		=> $page["item_title"],
				"subtitle"	=> $page["item_subtitle"]
			),
			array(
				$_CONF["url"]	=> $page["item_title"]
			)
		);


		$this->module->plugins["seo"]->PageMeta($page);

		if ($code = "404") {
			header("HTTP/1.1 404 Not Found");
		}


	
		if ($full) {

			return $this->module->plugins["layouts"]->Render(

				$this->tpl_module["settings"]["set_layout"],

				$this->private->templates["page"]->blockReplace(
					"Main" ,
					$page
				),
				$this->tpl_module["settings"]["set_widgets"]
			);

		} else {		

			return $this->private->templates["page"]->blockREplace(
				"Main" , 
				$page
			);

		}
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Robots() {
		global $_CONF;

		$mime = new CMime();
		$mime->Set("text");


		if (isset($_SERVER["HTTPS"]) && ($_SERVER["HTTPS"] == "on")) {
			echo $this->vars->data["set_robots_https"] . "\n" . "SITEMAP: " . $_CONF["url"] . "sitemap.xml";
		} else {		
			echo $this->vars->data["set_robots"] . "\n" . "SITEMAP: " . $_CONF["url"] . "sitemap.xml";
		}

		die();
	}
	
	
}

?>