
DROP TABLE IF EXISTS `site_plugin_portfolio_cats`;
CREATE TABLE IF NOT EXISTS `site_plugin_portfolio_cats` (
  `cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `cat_order` int(11) NOT NULL,
  `cat_status` int(11) NOT NULL,
  `cat_items` int(11) NOT NULL,
  `cat_date` int(11) NOT NULL,
  `cat_image` int(11) NOT NULL,
  PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

DROP TABLE IF EXISTS `site_plugin_portfolio_cats_lang`;
CREATE TABLE IF NOT EXISTS `site_plugin_portfolio_cats_lang` (
  `cat_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `cat_title` varchar(255) NOT NULL,
  `cat_url` varchar(255) NOT NULL,
  `cat_description` text NOT NULL,
  `seo_title` text NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` int(11) NOT NULL,
  `seo_conv_body` int(11) NOT NULL,
  KEY `cat_id` (`cat_id`,`module_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_plugin_portfolio_images`;
CREATE TABLE IF NOT EXISTS `site_plugin_portfolio_images` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_parent` int(11) NOT NULL,
  `item_status` int(1) NOT NULL,
  `item_order` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_type` int(1) NOT NULL,
  `item_image` int(1) NOT NULL,
  `item_video` varchar(100) NOT NULL,
  `item_audio` int(1) NOT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

DROP TABLE IF EXISTS `site_plugin_portfolio_images_lang`;
CREATE TABLE IF NOT EXISTS `site_plugin_portfolio_images_lang` (
  `item_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  KEY `item_id` (`item_id`,`module_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_plugin_portfolio_items`;
CREATE TABLE IF NOT EXISTS `site_plugin_portfolio_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_status` int(1) NOT NULL,
  `item_cat` int(11) NOT NULL,
  `item_date` int(11) NOT NULL,
  `item_online` varchar(255) NOT NULL,
  `item_image` int(1) NOT NULL,
  `item_image_list` INT( 1 ) NOT NULL,
  `item_type` int(1) NOT NULL,
  `item_youtube` varchar(20) NOT NULL,
  `item_vimeo` varchar(20) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `module_id` (`module_id`,`item_cat`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=102 ;

DROP TABLE IF EXISTS `site_plugin_portfolio_items_lang`;
CREATE TABLE IF NOT EXISTS `site_plugin_portfolio_items_lang` (
  `item_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_url` varchar(255) NOT NULL,
  `item_specs` text NOT NULL,
  `item_description` text NOT NULL,
  `item_brief` text NOT NULL,
  `item_details` int(1) NOT NULL,
  `item_image_alt` varchar(255) NOT NULL,
  `item_image_list_alt` varchar(255) NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  KEY `item_id` (`item_id`,`lang_id`,`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
