
DROP TABLE IF EXISTS `site_plugin_news_images`;
CREATE TABLE IF NOT EXISTS `site_plugin_news_images` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_parent` int(11) NOT NULL,
  `item_status` int(1) NOT NULL,
  `item_order` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_type` int(1) NOT NULL,
  `item_image` int(1) NOT NULL,
  `item_video` varchar(100) NOT NULL,
  `item_author` varchar(100) NOT NULL,
  `item_audio` int(1) NOT NULL,
  `item_audio_file` varchar(255) NOT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

DROP TABLE IF EXISTS `site_plugin_news_images_lang`;
CREATE TABLE IF NOT EXISTS `site_plugin_news_images_lang` (
  `item_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_image_alt` varchar(255) NOT NULL,
  KEY `item_id` (`item_id`,`module_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_plugin_news_items`;
CREATE TABLE IF NOT EXISTS `site_plugin_news_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_image` int(1) NOT NULL,
  `item_date` int(11) NOT NULL,
  `item_status` int(1) NOT NULL,
  `item_comments` int(1) NOT NULL,
  `item_comments_new` int(1) NOT NULL,
  `item_stats_comments` int(11) NOT NULL,
  `item_author` varchar(255) NOT NULL,
  `item_source` text NOT NULL,
  `item_source_btn` VARCHAR(255) NOT NULL,
  `item_tn` int(11) NOT NULL,
  `item_image_details` int(1) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `item_id` (`item_id`,`module_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

DROP TABLE IF EXISTS `site_plugin_news_items_lang`;
CREATE TABLE IF NOT EXISTS `site_plugin_news_items_lang` (
  `item_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_url` varchar(255) NOT NULL,
  `item_brief` text NOT NULL,
  `item_body` longtext NOT NULL,
  `seo_title` text NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  KEY `item_id` (`item_id`,`module_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
