DROP TABLE IF EXISTS `site_plugin_jobs_fields`;
CREATE TABLE IF NOT EXISTS `site_plugin_jobs_fields` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_field` varchar(255) NOT NULL,
  `item_type` varchar(30) NOT NULL,
  `item_required` int(1) NOT NULL,
  `item_size` varchar(5) NOT NULL,
  `item_system` INT( 1 ) NOT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `site_plugin_jobs_fields_lang`;
CREATE TABLE IF NOT EXISTS `site_plugin_jobs_fields_lang` (
  `item_id` int(11) NOT NULL,
  `lang_id` int(3) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_error_msg` varchar(255) NOT NULL,
  `item_options` text NOT NULL,
  KEY `lang_id` (`lang_id`),
  KEY `item_id` (`item_id`),
  KEY `lang_id_2` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_plugin_jobs_items`;
CREATE TABLE IF NOT EXISTS `site_plugin_jobs_items` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_fax` varchar(255) NOT NULL,
  `item_phone` varchar(255) NOT NULL,
  `item_email` varchar(255) NOT NULL,
  `item_email_job` int(1) NOT NULL,
  `item_date` int(11) NOT NULL,
  `item_status` int(2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `item_id` (`item_id`,`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `site_plugin_jobs_items_lang`;
CREATE TABLE IF NOT EXISTS `site_plugin_jobs_items_lang` (
  `item_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_url` varchar(255) NOT NULL,
  `item_location` varchar(255) NOT NULL,
  `item_brief` text NOT NULL,
  `item_details` text NOT NULL,
  `item_contact` varchar(255) NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  KEY `item_id` (`item_id`,`module_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_plugin_jobs_resumes`;
CREATE TABLE IF NOT EXISTS `site_plugin_jobs_resumes` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_code` varchar(32) DEFAULT NULL,
  `item_job` int(11) NOT NULL,
  `item_file` int(1) DEFAULT NULL,
  `item_file_file` varchar(255) DEFAULT NULL,
  `module_id` int(11) DEFAULT NULL,
  `item_new` int(1) DEFAULT NULL,
  `item_date` int(11) DEFAULT NULL,
  `item_email` varchar(255) DEFAULT NULL,
  `item_name` varchar(255) DEFAULT NULL,
  `item_message` text,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

