<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CGallery extends CPlugin{
	
	var $tplvars; 

	function CGallery() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		parent::DoEvents();

		if ($_GET["mod"] == "gallery") {
			$sub = $_GET["sub"];
			$action = $_GET["action"];

			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			switch ($sub) {


				case "landing":
					$_GET["sub"] = $sub = "images";
				case "images":
				case "cats":
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$this->PrepareFields($data->forms["forms"]);


					switch ($sub) {
						case "images":
							$data->functions = array( 
									"onstore" => array(&$this , "StoreItem"),
							);					
						break;

						case "cats":
							$data->functions = array( 
									"ondelete" => array(&$this , "DeleteCat"),
							);					
						break;
					}
					
					return $data->DoEvents();
				break;


				case "texts":
					return $this->__adminTexts();
				break;


				case "mass.upload":
					return $this->MassUploadForm();
				break;

				case "mass.upload.act":
					return $this->MassUploadAction();
					break;

			}
		}
	}

	function adminGetWidgets($module) {

		$widgets = array(
			array(
				"type"				=> "1",
				"name"				=> "Latest Images",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
			),


			array(
				"type"				=> "2",
				"name"				=> "Latest Images From Album",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
			),

/*
			array(
				"type"				=> "3",
				"name"				=> "Featured Album",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
			),
			array(
				"type"				=> "4",
				"name"				=> "Albums",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
			),
*/

		);

		return $widgets;

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function MassUploadForm() {
		global $_CONF;


		return CPlUpload::NewInstance()
			->Render(
				array(
					"action"		=> "json.php?mod=gallery&sub=mass.upload.act&module_id={$_GET[module_id]}&cat_id={$_GET[cat_id]}",
					"skin"			=> "Orange",
				)
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function MassUploadAction() {

		$temp = CPlUpload::NewInstance()
			->SetFunction(
				"onComplete",
				array(&$this , "StoreImage")
			)
			->Run();
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreItem($record) {
		if ($record["item_id"]) {

			$this->db->QueryUpdate(
				$this->tables["plugin:gallery_cats"],
				array(
					"cat_images"	=> $this->db->RowCount(
						"{$this->tables['plugin:gallery_images']} as i , {$this->tables['plugin:gallery_images_lang']} as l  "	,
						"WHERE i.item_cat={$record[item_cat]} AND l.item_id=i.item_id AND l.lang_id={$record[lang_id]}"
					)
				),
				"cat_id = {$record[item_cat]}"
			);
		}
		
	}

		
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreImage($path , $name) {
		global $base;

		$id = $this->db->QueryInsert(
			$this->tables["plugin:gallery_images"],
			array(
				"module_id"		=> $_GET["module_id"],
				"item_cat"		=> $_GET["cat_id"],
				"item_date"		=> time(),
				"item_type"		=> "1",
				"item_image"	=> "1",
				"item_show"		=> "1",
			)
		);

		$this->db->QueryUpdate(
			$this->tables["plugin:gallery_images"],
			array(
				"item_order"	=> $id
			),
			"item_id={$id}"
		);


		$info = pathinfo($path);

		$name = $info["basename"];

		if ($info["extension"]) {		
			$name = str_replace("." . $info["extension"] , "" , $info["basename"]);
		}


		//get all the languages, its up to the user to translate them
		$langs = $this->plugins["languages"]->GetLanguages();

		if (is_array($langs)) {
			foreach ($langs as $key => $lang) {
				$this->db->QueryInsert(
					$this->tables['plugin:gallery_images_lang'],
					array(
						"module_id"		=> $_GET["module_id"],
						"item_id"			=> $id,
						"lang_id"			=> $lang["lang_id"],
						"item_title"		=> $name,
						"item_url"			=> CFile::Name2Url($name),
					)
				);
			}			
		}

		//copy the image to the final folder

		Image::newInstance()
			->Read($path)
			->ResizeFit( 
				ImageConst::MAX_WIDTH , 
				ImageConst::MAX_HEIGHT 
			)
			->Save(
				"../upload/gallery/photos/{$id}.jpg", 
				90 ,
				0777
			)
			->ScaleCrop(720 , 480)
			->Save(
				"../upload/gallery/photos/tn_{$id}.jpg" , 
				90,
				0777
			)
			->ResizeByWidth(720)
			->Save(
				"../upload/gallery/photos/tn2_{$id}.jpg" , 
				90,
				0777
			)
			->Destroy();

		CFile::Remove($path);

		//update the category coutn

		$this->db->QueryUpdate(
			$this->tables["plugin:gallery_cats"],
			array(
				"cat_images"	=> $this->db->RowCount($this->tables['plugin:gallery_images'] , " WHERE item_cat={$_GET[cat_id]} ")
			),
			"cat_id={$_GET[cat_id]}"
		);

	}



	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function _onCreate($module_data) {

		//create default widgets

		$widgets = new CConfig($this->path . "install/widgets.xml");
		$widgets = $widgets->vars["widgets"];


		if (is_array($widgets)) {
			foreach ($widgets as $key => $val) {
				$val["module"] = $module_data["mod_id"];

				$wid = $this->plugins["widgets"]->AddWidget($val);

				$lay_widgets[$key] = $wid;
			}			
		}
		

		$lay_widgets["mod_name"] = $module_data["mod_name"];


		$layouts = array(
			"layout" => "0",
		);

		foreach ($layouts as $key => $val) {

			$layout_data = new CConfig(
				CTemplateStatic::Replace(
					CFile::GetContents($this->path . "install/"  . $key . ".xml"),
					$lay_widgets
				),
				"string"
			);

			$lid = $this->plugins["layouts"]->SaveLayout(
				$this->plugins["layouts"]->LoadFromString(
					$layout_data->vars["layout"]
				)
			);

			$layouts[$key] = $lid;
		}


		//update the layout id
		$this->plugins["modules"]->UpdateModuleSettings(
			$module_data["mod_id"] , 
			array(
				"set_layout"			=> $layouts["layout"],
				"set_layout_album"	=> $layouts["layout"],
				"set_layout_photo"		=> $layouts["layout"],
			)		
		);


		//execute any other standard operations
		parent::onCreate($module_data);		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {

		$tables  = array(
			"plugin:gallery_cats" , 
			"plugin:gallery_cats_lang",
			"plugin:gallery_images",
			"plugin:gallery_images_lang",
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}
	

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DeleteCat($record) {

		//delete images languages
		$this->db->Query("
			DELETE FROM {$this->tables['plugin:gallery_images_lang']}
			WHERE 
				item_id in ( 
					SELECT item_id FROM {$this->tables['plugin:gallery_images']} 
					WHERE 
						item_cat = {$record[cat_id]}
				);
		"
		);

		//delete images
		$this->db->Query("
			DELETE FROM {$this->tables['plugin:gallery_images']}
			WHERE item_cat = {$record[cat_id]}
		");

	}
	
}

?>