<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CFileList extends CPlugin{
	
	var $tplvars; 

	function CFileList() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "filelist") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;

				case "download":
					return $this->Download();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"items"					=> "items.htm",
			"widget"				=> "widget.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {
		global $base;

		$text = $this->GetTexts();

		$this->module->plugins["seo"]->PageMeta(
			$text
		);

		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"	=> $text["text_title"] ? $text["text_title"] : $this->tpl_module["mod_name"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module
		);
		

		if ($this->plugins["comments"]) {
			$text["comments"] = $this->module->plugins["comments"]->Comments(
				$this->tpl_module["link"],
				$this->tpl_module["settings"]["set_comments"]
			);
		} else {
			$text["comments"] = "";
		}

		$items = $this->GetItems(array(
			"items"		=> $this->tpl_module["settings"]["set_ipp_items"] , 
			"page"		=> $_GET["page"]
		));


		$template = &$this->private->templates["items"];

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$items["records"]
					),

					"paging"	=> $this->module->plugins["paging"]->Paging(
						$items["pages"] , 
						$items["page"] , 
						array(
							"first"	=> $this->tpl_module["link"] ,
							"all"	=> $this->tpl_module["link"] . "p{PAGE}",
						),
						$items["items"]
					),

				),
				$text,
				$this->tpl_module["settings"]		
			)
		);


			

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$content
		);

	}


	function GetItems($params = array()) {
	
		$count	= max(1,$params["items"]);
		$page	= $params["page"];

		$order		= "item_order";
		$order_mode = "ASC";



		$cond = " c.item_id=l.item_id AND l.lang_id={$this->tpl_module[lang_id]} AND c.module_id={$this->tpl_module[mod_id]} ";

		$item_count = $this->db->RowCount(
			"	{$this->tables['plugin:filelist_items']} as c,
				{$this->tables['plugin:filelist_items_lang']} as l

			",
			"	WHERE {$cond}"
		);


		if (!$page && $item_count) {
			$page = 1;
		} else 
			$page = max(1,(int)$page);

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:filelist_items']} as c,
				{$this->tables['plugin:filelist_items_lang']} as l
			WHERE 				
				{$cond}
			ORDER BY  {$order} {$order_mode} 
			LIMIT " . ( max(0,($page - 1 ) * $count )) . " , " . $count 
		);


		if (is_array($items)) {
			$cnt = 0;
			foreach ($items as $key => $val) {
				$cnt ++;								
				$items[$key]["cnt"] = ($page - 1) * $count + $cnt;
				$items[$key]["date"] = date($this->tpl_module["settings"]["set_date"] ? $this->tpl_module["settings"]["set_date"]  : "j F Y" , $val["item_date"]);			
				$items[$key]["link"] = $this->tpl_module["link"] . "dl/" . $val["item_code"];
				$items[$key]["size"] = CFile::FormatedSize("upload/filelist/{$val[item_id]}.file");
			}			
		}


		return array(
			"records"	=> $items, 
			"count"		=> $item_count , 
			"pages"		=> $item_count ? ceil($item_count / $count) : 1,
			"page"		=> $page,

			"ipp"		=> $count
		);

	}


	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Download() {
		global $_CONF;

		//dont allow directlinking from other websites
		if (!stristr($_SERVER["HTTP_REFERER"] , $_CONF["url"])) {
			urlredirect($this->tpl_module["link"]);
		}
		

		$file = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:filelist_items']} WHERE module_id={$this->tpl_module[mod_id]} AND item_code LIKE '%s'" , array($_GET["file"]));

		if (!is_array($file)) {
			return $this->module->plugins["redirects"]->ErrorPage("404");
		}


		//update the downloads
		$this->db->QueryUpdate(
			$this->tables['plugin:filelist_items'],
			array(
				"item_downloads" => $file["item_downloads"] + 1
			),
			"item_id={$file[item_id]}"
		);

		$mime = new CMime();
		$mime->Set("unknown");
		$mime->Filename($file["item_file_file"]);

		CFile::ReadChunked("upload/filelist/" . $file["item_id"] . ".file");
		die();

	}
	


	function Widget($widget) {

		$this->__init();

		switch ($widget["widget_type"]) {
			case "1":
				return $this->widgetFile($widget);
			break;
		}
	}



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetFile($widget) {

		$this->__init();

		$file = $this->db->QFetchArray(
			"SELECT * FROM {$this->tables['plugin:filelist_items']} as t , {$this->tables['plugin:filelist_items_lang']} as l 
			WHERE t.module_id = {$widget[mod_id]} AND l.lang_id={$widget[lang_id]} AND t.item_id=l.item_id AND t.item_id={$widget['settings']['set_file']}
			"
		);

		if (!is_array($file)) {
			return "";
		}

		$this->__init();

		//$file["widget"] = $widget["widget_name"];

		$file["link"] = $widget["link"] . "dl/" . $file["item_code"];

		if ($widget["settings"]["set_text"]) {
			$file["item_brief"] = $widget["settings"]["set_text"];
		}
		

		
		return CTemplateStatic::Replace(
			$this->private->templates["widget"]->blockReplace(
				"Main" , 
				$file
			),
			$widget ,
			$widget["mod_settings"]
		);
	}


	function GetAllLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);
	}

}

?>