<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CFaq extends CPlugin{
	
	var $tplvars; 

	function CFaq() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "faq") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"main"					=> "main.htm",
			"main.large"			=> "main.large.htm",
			"widget"				=> "widget.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {

		global $base;
		

		$text = $this->getTexts();

		$this->plugins["seo"]->PageMeta(
			array(
				"seo_title"	=> $text["seo_title"],
				"seo_desc"	=> $text["seo_desc"],
			)
		);

			
		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module
		);


		if ($this->plugins["comments"]) {
			$text["comments"] = $this->module->plugins["comments"]->Comments(
				$this->tpl_module["link"],
				$this->tpl_module["settings"]["set_comments"]
			);
		} else {
			$text["comments"] = "";
		}
	
		switch ($this->tpl_module["settings"]["set_style"]) {
			case "1":
				$template = &$this->private->templates["main.large"];
			break;

			default:
				$template = &$this->private->templates["main"];
			break;
		}
		



		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:faq_items']} as r,
				{$this->tables['plugin:faq_items_lang']} as p

			WHERE 
				r.item_id = p.item_id AND 
				p.lang_id = {$this->tpl_module[lang_id]} AND
				r.module_id= {$this->tpl_module[mod_id]} 

			ORDER BY 
				r.item_order ASC
			"
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {

				$items[$key]["icon"] = $template->blockReplace($val["item_icon"] ? "Icon" : "NoIcon", $val );
			}			
		}
		

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"Body" , 
						$items
					),

					"items_titles"	=> $base->html->Table(
						$template, 
						"" , 
						$items
					),

				),
				$text ,
				$this->tpl_module

			)
		);

	}


	function Widget($widget) {

		$this->__init();

		switch ($widget["widget_type"]) {
			case "1":
				return $this->widgetFaq($widget);
			break;
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetFaq($widget) {
		global $base;

		if (!$widget["settings"]["set_items"]) {
			return "";
		}

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:faq_items']} as r,
				{$this->tables['plugin:faq_items_lang']} as p

			WHERE 
				r.item_id = p.item_id AND 
				p.lang_id = {$widget[lang_id]} AND 
				r.module_id= {$widget[mod_id]} AND 

				r.item_id in ( {$widget['settings']['set_items']} )

			ORDER BY 
				r.item_order ASC
			"
		);

		$template = &$this->private->templates["widget"];

		if (is_array($items)) {
			foreach ($items as $key => $val) {

				$items[$key]["icon"] = $template->blockReplace($val["item_icon"] ? "Icon" : "NoIcon", $val );
			}			
		}


		return $template->blockREplacE(
			"Main" , 
			array(

				"items"	=> $base->html->Table(
					$template, 
					"" , 
					$items
				),
			),
			$widget
		);
	}

	

	function GetAllLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);
	}

}

?>