<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CDepartments extends CPlugin{
	
	var $tplvars; 

	function CDepartments() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "departments") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					if ($this->tpl_module["settings"]["set_style"] == "1") {
						return $this->Category();
					} else {
						return $this->Landing();
					}
				break;

				case "category":
					return $this->Category();
				break;

			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"category"				=> "category.htm",
			"categories"			=> "categories.htm",
			"images"				=> "images.htm",

			"landing"				=> "landing.htm",

		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Category() {
		global $base;

		$text = $this->GetTexts();


		if ($_GET["cat_id"]) {
			$cat = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:departments_cats']} as c,
					{$this->tables['plugin:departments_cats_lang']} as l
				WHERE
					c.module_id={$this->tpl_module[mod_id]} AND 
					c.cat_id = l.cat_id AND 
					c.cat_status = 1 AND 
					l.lang_id = {$this->tpl_module[lang_id]} AND 
					l.cat_url LIKE '%s'
				",
				array(
					$_GET["cat_id"]
				)
			);
		} else {
			$cat = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:departments_cats']} as c,
					{$this->tables['plugin:departments_cats_lang']} as l
				WHERE
					c.module_id={$this->tpl_module[mod_id]} AND 
					c.cat_id = l.cat_id AND 
					c.cat_status = 1 AND 
					l.lang_id = {$this->tpl_module[lang_id]} 
				ORDER BY 
					c.cat_order ASC 
				LIMIT 1
				"
			);
		}

		
		if (!is_array($cat) && ($_GET["sub"] == "category")) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}
				
		$this->module->plugins["seo"]->PageMeta(
			$cat
		);

		$template = &$this->private->templates["category"];
	
		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=>	$text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"],
				$this->tpl_module["link"] . $cat["cat_url"] . "/"	=> $cat["cat_title"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module
		);
	
		
		if ($this->plugins["comments"]) {
			$cat["comments"] = $this->module->plugins["comments"]->Comments(
				$this->tpl_module["link"] . $cat["cat_url"] . "/",
				$this->tpl_module["settings"]["set_comments"]
			);
		} else {
			$cat["comments"] = "";
		}



		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_album"],
				$this->tpl_module["mod_protected"]
			),

			is_array($cat) ? $template->blockREplacE(
				"Main" , 
				$cat , 
				array(

					"image"		=> $cat["cat_image"] ? $template->blockReplace("Image"  , $cat ) : "",


					"items"		=> $this->CatsMenu($cat),
					"images"	=> $this->CatImages($cat),

					"text_header"	=> $text["text_header"],

				),
				$this->tpl_module,
				$this->tpl_module["settings"]
			) : ""
		);


	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function CatsMenu($default) {
		global $base ;

		$cats = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:departments_cats']} as c,
				{$this->tables['plugin:departments_cats_lang']} as l
			WHERE
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_id = l.cat_id AND 
				c.cat_status = 1 AND 
				l.lang_id = {$this->tpl_module[lang_id]} 

			ORDER BY
				c.cat_order ASC
			"
		);


		if (is_array($cats)) {

			$home = true;
			foreach ($cats as $key => $val) {

				if ($home && $this->tpl_module["settings"]["set_style"]) {
					$cats[$key]["link"] = $this->tpl_module["link"];
				} else {				
					$cats[$key]["link"] = $this->tpl_module["link"] . $val["cat_url"] . "/";
				}

				$cats[$key]["active"] = $val["cat_url"] == $default["cat_url"] ? $this->private->templates["categories"]->blockReplace("active") : "";
				$cats[$key]["icon"] = $this->private->templates["categories"]->blockREplace($val["cat_icon"] ? "Icon" : "NoIcon" , $val);

				$home = false;
			}			
		}
		
		return $base->html->table(
			$this->private->templates["categories"],
			"" , 
			$cats
		);

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function CatImages($cat) {
		global $base;

		if (!is_array($cat)) {
			return "";
		}
		

		$images = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:departments_images']} as c,
				{$this->tables['plugin:departments_images_lang']} as l
			WHERE
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.item_id = l.item_id AND 
				c.item_cat = {$cat[cat_id]} AND 
				l.lang_id = {$this->tpl_module[lang_id]} 

			ORDER BY 
				item_order ASC
			"

		);


		if (is_Array($images)) {
			foreach ($images as $key => $val) {

				switch ($val["item_type"]) {
					//image
					case "1":
						$images[$key]["source"] = "upload/departments/photos/{$val[item_id]}.jpg";
					break;

					//youtube
					case "2":
						$images[$key]["source"] = "https://www.youtube.com/watch?v=" . $val["item_video"];
					break;

					//vimeo
					case "3":
						$images[$key]["source"] = "http://www.vimeo.com/" . $val["item_video"];
					break;

				}


			}
			
		}
		


		return $base->html->Table(
			$this->private->templates["images"] , 
			"", 
			$images

		);

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {
		global $base;

		$text = $this->GetTexts();				
		$this->module->plugins["seo"]->PageMeta(
			$text
		);

		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=>	$text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],

			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module
		);


		$template = &$this->private->templates["landing"];

		$cats = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:departments_cats']} as c,
				{$this->tables['plugin:departments_cats_lang']} as l
			WHERE
				c.module_id={$this->tpl_module[mod_id]} AND 
				c.cat_id = l.cat_id AND 
				c.cat_status = 1 AND 
				l.lang_id = {$this->tpl_module[lang_id]} 

			ORDER BY
				c.cat_order ASC
			"
		);


		if (is_array($cats)) {
			foreach ($cats as $key => $val) {
				$cats[$key]["link"] = $this->tpl_module["link"] . $val["cat_url"] . "/";
				$cats[$key]["icon"] = $template->blockREplace($val["cat_icon"] ? "Icon" : "NoIcon" , $val);
				$cats[$key]["image"] = $template->blockREplace($val["cat_tn"] ? "Image" : "NoImage" , $val);
			}			
		}
		

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_details"],
				$this->tpl_module["mod_protected"]
			),

			$template->blockREplacE(
				"Main" , 
				array(
					"items"		=> $base->html->table(
						$template,
						"" , 
						$cats
					)
				), 
				$text,				
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);


	}
	
	

	function GetAllLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);


		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:departments_cats']} as c,
				{$this->tables['plugin:departments_cats_lang']} as l
			WHERE
				c.module_id={$module[mod_id]} AND 
				c.cat_id = l.cat_id AND 
				c.cat_status = 1 AND 
				l.lang_id = {$module[lang_id]} 
			"
		);


		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$links[] = array(
					"url" => $module["link"] . $val["cat_url"] . "/",
				);
			}
			
		}

	}

}

?>