<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CContact extends CPlugin{
	
	var $tplvars; 

	function CContact() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "contact") {
			$sub = $_GET["sub"];
			$action = $_GET["action"];

			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);


			global $_CONTACT_MODULE;
			$_CONTACT_MODULE = $this->tpl_module;

			switch ($sub) {

				case "texts":
					return $this->__adminTexts();
				break;
	

				case "items":
				case "landing":
					$sub = "messages";
				case "messages":

					//force lower fields code
					if ($_POST["item_field"]) 
						$_POST["item_field"] = strtolower($_POST["item_field"]);

					if ($_GET["item_id"]) {
						$this->db->QueryUpdate(
							$this->tables["plugin:contact_messages"],
							array(
								"item_new" => 0,
							),
							"item_id='{$_GET[item_id]}'"
						);
					}
					

					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$this->PrepareFields($data->forms["forms"]);

					$data->functions = array( 
							"onstore_prepare"		=> array(&$this , "SendMail"),
					);					

					return $data->DoEvents();
				break;

				case "links":
				case "images":
				case "departments":
				case "fields":
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$this->PrepareFields($data->forms["forms"]);
					return $data->DoEvents();
				break;

				case "messages-delete":
					return $this->MessagesDelete();
				break;

			}
		}
	}

	function SendMail() {

		$message = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:contact_messages']} WHERE item_id={$_POST[item_id]}");

		$this->module->plugins["mail"]->SendMail(
			array(
				"email_to"			=> $message["item_email"],
				"email_to_name"		=> $message["item_name"],
				"email_from"		=> $_POST["set_reply"],
				"email_from_name"	=> $_POST["set_reply_name"],
				"email_subject"		=> $_POST["reply_subject"],
				"email_body"		=> $_POST["reply_body"],
			)
		);

		$this->db->QueryUpdate(
			$this->tables['plugin:contact_messages'],
			array(
				"item_replied"	=> "1",
				"item_replied_date"	=> time(),
			),
			"item_id={$message[item_id]}"
		);

		if ($_POST["reply_copy"]) {
			$this->module->plugins["mail"]->SendMail(
				array(
					"email_from"			=> $message["item_email"],
					"email_from_name"		=> $message["item_name"],
					"email_to"				=> $_POST["set_reply"],
					"email_to_name"			=> $_POST["set_reply_name"],

					"email_subject"		=> $_POST["reply_subject"],
					"email_body"		=> $_POST["reply_body"],
				)
			);
		}
		


		urlredirect("index.php?mod=contact&sub=landing&module_id={$_GET[module_id]}");

	}



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function MessagesDelete() {

		if (is_array($_POST["item_id"])) {
			$this->db->Query(
				"DELETE FROM {$this->tables['plugin:contact_messages']} WHERE item_id IN (" . implode("," , $_POST["item_id"]). ")"
			);
		}
		
		die("1");
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DashboardWidgets($mod_id) {
		global $base , $_CONF;

		$module = $this->module->plugins["modules"]->getModuleInfo($mod_id);		

		if (is_array($module)) {		
			$_GET["module_name"] = $module["mod_name"] ;
			$_GET["module_id"] = $mod_id;
			$_CONF["forms"]["adminpath"] = _MODPATH . "contact/forms/";

			$latest = new CSQLAdmin("dashboard/latest", $this->__parent_templates,$this->db,$this->tables,$extra);
			$content = $latest->DoEvents();

			if (!(stristr($content , "No available records.") && !$_GET["showempty"])) {

				return array(
					array(
						"width"	=> "6",
						"type"	=> "widget",
						"pos"	=> "1",
						"body"	=> $content
					),
				);
			}
		}			

	}



	function adminGetWidgets($module) {

		//$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);



		$widgets = array(
			array(
				"type"				=> "1",
				"name"				=> "Quick Contact Form",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
			),
/*
			array(
				"type"				=> "2",
				"name"				=> "Departments Addresses",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
			),
*/
		);

		return $widgets;

	}



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {
		global $_LANG_ID;

		$fields = array(

			array(
				"module_id"		=> $module_data["mod_id"],
				"lang_id"		=> $_LANG_ID,
				"item_field"	=> "first_name",
				"item_type"		=> "usertext",
				"item_required"	=> "1",
				"item_size"		=> "full",
				"item_title"	=> "First Name",
				"item_error_msg"=> "Please enter your first name!",
			),

			array(
				"module_id"		=> $module_data["mod_id"],
				"lang_id"		=> $_LANG_ID,
				"item_field"	=> "last_name",
				"item_type"		=> "usertext",
				"item_required"	=> "1",
				"item_size"		=> "full",
				"item_title"	=> "Last Name",
				"item_error_msg"=> "Please enter your last name!",
			),

			array(
				"module_id"		=> $module_data["mod_id"],
				"lang_id"		=> $_LANG_ID,
				"item_field"	=> "email",
				"item_type"		=> "useremail",
				"item_required"	=> "1",
				"item_size"		=> "full",
				"item_system"	=> "1",
				"item_title"	=> "Email",
				"item_error_msg"=> "Please enter your email!",
			),

			array(
				"module_id"		=> $module_data["mod_id"],
				"lang_id"		=> $_LANG_ID,
				"item_field"	=> "departments",
				"item_type"		=> "departments",
				"item_required"	=> "",
				"item_size"		=> "full",
				"item_title"	=> "Department",
			),

			array(
				"module_id"		=> $module_data["mod_id"],
				"lang_id"		=> $_LANG_ID,
				"item_field"	=> "message",
				"item_type"		=> "usermessage",
				"item_required"	=> "1",
				"item_size"		=> "full",
				"item_title"	=> "Message",
				"item_error_msg"=> "Please enter your message!",

			),
		);


		//generate default form structure
		foreach ($fields as $key => $val) {

			$val["item_id"] = $this->db->QueryInsert(
				$this->tables["plugin:contact_fields"] , 
				$val
			);

			$this->db->QueryUpdate(
				$this->tables["plugin:contact_fields"] , 
				array(
					"item_order"	=> $val["item_id"]
				),
				"item_id ={$val[item_id]}"
			);

			$this->db->QueryInsert(
				$this->tables["plugin:contact_fields_lang"] ,
				$val
			);
		}
		
	}

	function onDelete($module_data) {

		$tables  = array(
			"plugin:contact_messages" , 
			"plugin:contact_fields",
			"plugin:contact_fields_lang",
			"plugin:contact_departments",
			"plugin:contact_departments_lang",
			"plugin:contact_links",
			"plugin:contact_images",
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}

	
}


?>