<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CClients extends CPlugin{
	
	var $tplvars; 

	function CClients() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "clients") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Landing();
				break;
				
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"landing"				=> "landing.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {
		global $base;


		$text = $this->GetTexts();

		$this->module->plugins["seo"]->PageMeta(
			$text
		);


		$clients = $this->GetClients(array(
			"items" => $this->tpl_module["settings"]["set_ipp"] , 
			"page" => $_GET["page"]
		));

		$clients["records"] = $this->ProcessClients($clients["records"]);



		$template = &$this->private->templates["landing"];
	
		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
				"show"		=> $text["text_status"],

			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module

		);
		
		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$clients["records"]
					),

					"paging"	=> $this->module->plugins["paging"]->Paging(
						$clients["pages"] , 
						$clients["page"] , 
						array(
							"first"	=> $this->tpl_module["link"],
							"all"	=> $this->tpl_module["link"] . "p{PAGE}",
						),
						$clients["items"]
					),

					"text_title"	=> $text["text_title"],
					"text_header"	=> $text["text_header"],


					"comments"		=> $this->plugins["comments"] ? $this->module->plugins["comments"]->Comments(
											$this->tpl_module["link"],
											$this->tpl_module["settings"]["set_comments"]
					) : ""

				),
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);


	}

	/**
	* description

	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetClients($params = array()) {
	
		$count	= $params["items"];
		$page	= $params["page"];

		$order		= "item_order";
		$order_mode = "ASC";

		$cond = "c.item_id=l.item_id AND l.lang_id={$this->tpl_module[lang_id]} AND c.module_id={$this->tpl_module[mod_id]} ";

				
		$item_count = $this->db->RowCount(
			"	{$this->tables['plugin:clients_items']} as c,
				{$this->tables['plugin:clients_items_lang']} as l
			",
			"	WHERE {$cond}"
		);

		if (!$page && $item_count) {
			$page = 1;
		} else 
			$page = max(1,(int)$page);

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:clients_items']} as c,
				{$this->tables['plugin:clients_items_lang']} as l
			WHERE 				
				{$cond}
			ORDER BY  {$order} {$order_mode} 
			LIMIT " . ( max(0,($page - 1 ) * $count )) . " , " . $count 
		);

		return array(
			"records"	=> $items, 
			"count"		=> $item_count , 
			"pages"		=> $item_count ? ceil($item_count / $count) : 1,
			"page"		=> $page,

			"ipp"		=> $count
		);

	}
	


	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessClients($items) {

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$items[$key]["link"] = $val["item_url"] ? $this->private->templates["landing"]->blockReplace("Link", $val) : "";
				$items[$key]["item_description"] = nl2br($val["item_description"]);
			}
			
		}
		

		return $items;
	}

	function GetAllLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);
	}

}

?>