DROP TABLE IF EXISTS `site_plugin_blog_authors`;
CREATE TABLE IF NOT EXISTS `site_plugin_blog_authors` (
  `author_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `author_details` int(1) NOT NULL,
  `author_name` varchar(255) NOT NULL,
  `author_url` varchar(255) NOT NULL,
  `author_image` int(1) NOT NULL,
  `author_user` int(11) NOT NULL,
  `author_topics` int(11) NOT NULL,
  PRIMARY KEY (`author_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `site_plugin_blog_authors_lang`;
CREATE TABLE IF NOT EXISTS `site_plugin_blog_authors_lang` (
  `author_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `author_brief` text NOT NULL,
  `author_bio` longtext NOT NULL,
  `author_image_alt` varchar(255) NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  KEY `author_id` (`author_id`,`lang_id`,`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_plugin_blog_images`;
CREATE TABLE IF NOT EXISTS `site_plugin_blog_images` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_parent` int(11) NOT NULL,
  `item_status` int(1) NOT NULL,
  `item_order` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `item_type` int(1) NOT NULL,
  `item_image` int(1) NOT NULL,
  `item_video` varchar(100) NOT NULL,
  `item_audio` int(1) NOT NULL,
  `item_audio_file` varchar(255) NOT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `site_plugin_blog_images_lang` ;
CREATE TABLE IF NOT EXISTS `site_plugin_blog_images_lang` (
  `item_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_image_alt` varchar(255) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  KEY `item_id` (`item_id`,`module_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_blog_labels`;
CREATE TABLE IF NOT EXISTS `site_plugin_blog_labels` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `label_order` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `label_status` int(1) NOT NULL,
  `label_all` int(1) NOT NULL,
  `label_protect` int(1) NOT NULL,
  `label_perm` text NOT NULL,
  `label_perm_member` text NOT NULL,
  PRIMARY KEY (`label_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `site_plugin_blog_labels_lang`;
CREATE TABLE IF NOT EXISTS `site_plugin_blog_labels_lang` (
  `label_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `label_title` varchar(255) NOT NULL,
  `label_page_title` varchar(255) NOT NULL,
  `label_desc` TEXT NOT NULL,
  `label_url` varchar(255) NOT NULL,
  `label_items` int(11) NOT NULL,
  `label_perms` text NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  KEY `label_id` (`label_id`,`module_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_plugin_blog_topics`;
CREATE TABLE IF NOT EXISTS `site_plugin_blog_topics` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_author` int(11) NOT NULL,
  `item_author_box` int(1) NOT NULL,
  `item_status` int(1) NOT NULL,
  `item_date` int(11) NOT NULL,
  `item_date_year` int(4) NOT NULL,
  `item_date_month` int(2) NOT NULL,
  `item_date_day` int(2) NOT NULL,
  `item_labels` text NOT NULL,
  `item_stats_comments` int(11) NOT NULL,
  `item_stats_views` int(11) NOT NULL,
  `item_comments` int(11) NOT NULL,
  `item_comments_new` int(1) NOT NULL,
  `item_image` int(11) NOT NULL,
  `item_protect` int(1) NOT NULL,
  `item_tn` int(11) NOT NULL,
  `item_image_type` INT( 2 ) NOT NULL ,
  `item_image_list` INT( 1 ) NOT NULL ,
  `item_image_details` INT( 1 ) NOT NULL ,
  `item_youtube` VARCHAR( 50 ) NOT NULL ,
  `item_vimeo` VARCHAR( 50 ) NOT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `site_plugin_blog_topics_lang`;
CREATE TABLE IF NOT EXISTS `site_plugin_blog_topics_lang` (
  `item_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_url` varchar(255) NOT NULL,
  `item_brief` text NOT NULL,
  `item_body` longtext NOT NULL,
  `item_tags` varchar(255) NOT NULL,
  `seo_title` text NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  KEY `item_id` (`item_id`),
  KEY `module_id` (`module_id`),
  KEY `lang_id` (`lang_id`),
  KEY `item_url` (`item_url`),
  FULLTEXT KEY `item_title` (`item_title`),
  FULLTEXT KEY `item_body` (`item_body`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;