<?php
/*
	Stempora web framework
	copyright (c) 2002-2014 Stempora
		web:  www.stempora.com
		mail: support@stempora.com

	$Id: blog/site.php,v 1.0 3/16/2014  11:00:00 stempora Exp $
	description
*/

// dependencies

/**
* description
*
* @library	
* @author Emanuel Giurgea ( emanuel@stempora.com )
* @since 
*/
class CBlog extends CPlugin{
	
	var $tplvars; 

	function CBlog() {
		$this->name = "blog";

	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();


		if ($_GET["mod"] == $this->name) {
			$sub = $_GET["sub"];
			$action = $_GET["action"];

			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			switch ($sub) {

				case "texts":
					return $this->__adminTexts();
				break;

				case "landing":
					$_GET["sub"] = $sub = "topics";
				case "items":
				case "topics":
				case "topics.images":
				case "labels":
				case "authors":
				case "pending":

					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$this->PrepareFields($data->forms["forms"]);
					$data->functions = array( 
							"onstore" => array(&$this , "StoreRecord"),
							"ondelete" => array(&$this , "DeleteRecord"),
					);					

					return $data->DoEvents();
				break;

				case "test":
					$this->OnCreate(array());
				break;
			}
		}
	}


	function adminGetWidgets($module) {

		$widgets = array(
			array(
				"type"				=> "1",
				"name"				=> "Categories",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
			),

			array(
				"type"				=> "2",
				"name"				=> "Topics",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
				
			),

			array(
				"type"				=> "3",
				"name"				=> "Latest Comments",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
				
			),

			array(
				"type"				=> "6",
				"name"				=> "Search Box",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",			
			),

			array(
				"type"				=> "7",
				"name"				=> "Archive Box",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
				
			),

			array(
				"type"				=> "9",
				"name"				=> "Authors",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",				
			),


			array(
				"type"				=> "10",
				"name"				=> "Author Detail",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",				
			),

		);

		return $widgets;
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreRecord($record) {

		switch ($_GET["sub"]) {
			case "topics":
			case "pending":
				$this->db->QueryUpdate(
					$this->tables["plugin:blog_authors"],
					array(
						"author_topics"	=> $this->db->RowCount($this->tables['plugin:blog_topics'] , " WHERE item_author={$record[item_author]} ")
					),
					"author_id={$record[item_author]}"
				);


				if (count($tmp = explode("," , $record["item_labels"]))) {
					foreach ($tmp as $key => $val) {
						$this->db->QueryUpdate(
							$this->tables["plugin:blog_labels"],
							array(
								"label_topics"	=> $this->db->RowCount($this->tables['plugin:blog_topics'] , " WHERE find_in_set({$val} , item_labels)")
							),
							"label_id={$val}"
						);
					}					
				}

			break;
			case "topics.images":

				if ($record["item_id"]) {

					$last = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:blog_images']} WHERE item_parent={$record[item_parent]} AND item_type=1 AND item_image=1 ORDER BY item_order ASC LIMIT 1");

					$this->db->QueryUpdate(
						$this->tables["plugin:blog_topics"],
						array(
							"item_tn"	=> $last["item_id"]
						),
						"item_id={$record[item_parent]}"
					);
				}
			break;
		}
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DeleteRecord($record) {

		switch ($_GET["sub"]) {
			case "topics.images":

				$last = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:blog_images']} WHERE item_parent={$record[item_parent]} AND item_id!={$record[item_id]} AND item_type=1 AND item_image=1 ORDER BY item_order ASC LIMIT 1");

				$this->db->QueryUpdate(
					$this->tables["plugin:blog_topics"],
					array(
						"item_tn"	=> $last["item_id"]
					),
					"item_id={$record[item_parent]}"
				);

			break;

			case "topics":
				$this->db->QueryUpdate(
					$this->tables["plugin:blog_authors"],
					array(
						"author_topics"	=> $this->db->RowCount($this->tables['plugin:blog_topics'] , " WHERE item_author={$record[item_author]} ")
					),
					"author_id={$record[item_author]}"
				);
			break;

			case "authors":
				$this->db->QueryUpdate(
					$this->tables["plugin:blog_topics"],
					array(
						"item_status" => "0",
					),
					"item_author={$record[author_id]}"

				);
			break;
		}
		

	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {

		//create default widgets

		$widgets = new CConfig($this->path . "install/widgets.xml");
		$widgets = $widgets->vars["widgets"];


		if (is_array($widgets)) {
			foreach ($widgets as $key => $val) {
				$val["module"] = $module_data["mod_id"];

				$wid = $this->plugins["widgets"]->AddWidget($val);

				$lay_widgets[$key] = $wid;
			}			
		}
		

		$lay_widgets["mod_name"] = $module_data["mod_name"];


		$layouts = array(
			"layout" => "0",
		);

		foreach ($layouts as $key => $val) {

			$layout_data = new CConfig(
				CTemplateStatic::Replace(
					CFile::GetContents($this->path . "install/"  . $key . ".xml"),
					$lay_widgets
				),
				"string"
			);

			$lid = $this->plugins["layouts"]->SaveLayout(
				$this->plugins["layouts"]->LoadFromString(
					$layout_data->vars["layout"]
				)
			);

			$layouts[$key] = $lid;
		}


		//update the layout id
		$this->plugins["modules"]->UpdateModuleSettings(
			$module_data["mod_id"] , 
			array(
				"set_layout"			=> $layouts["layout"],
				"set_layout_archive"	=> $layouts["layout"],
				"set_layout_search"		=> $layouts["layout"],
				"set_layout_author"		=> $layouts["layout"],
				"set_layout_topic"		=> $layouts["layout"],
			)		
		);


		//create default author

		//create default labels
		$id = $this->db->QueryInsert(
			$this->tables["plugin:blog_labels"],
			array(
				"module_id"			=> $module_data["mod_id"],
				"label_status"		=> "1",
				"label_all"			=> "0",
			)
		);

		$this->db->QueryUpdate(
			$this->tables["plugin:blog_labels"],
			array(
				"label_order"	=> $id
			),
			"label_id={$id}"
		);

		$this->db->QueryInsert(
			$this->tables["plugin:blog_labels_lang"],
			array(
				"label_id"			=> $id,
				"module_id"			=> $module_data["mod_id"],
				"lang_id"			=> $_GET["lang_id"],
				"label_title"		=> "Default Category",
				"label_url"			=> CFile::Name2Url("Default Category"),
				"label_page_title"	=> "Default Category",
			)
		);

		//create default author
		$aid = $this->db->QueryInsert(
			$this->tables["plugin:blog_authors"],
			array(
				"module_id"			=> $module_data["mod_id"],
				"author_name"		=> "Default Author",
				"label_url"			=> CFile::Name2Url("Default Author"),			
			)
		);

		$this->db->QueryInsert(
			$this->tables["plugin:blog_authors_lang"],
			array(
				"author_id"			=> $aid,
				"module_id"			=> $module_data["mod_id"],
				"lang_id"			=> $_GET["lang_id"],
			)
		);

		//execute any other standard operations
		parent::onCreate($module_data);		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {

		$tables  = array(
			"plugin:blog_labels" , 
			"plugin:blog_labels_lang",
			"plugin:blog_topics",
			"plugin:blog_topics_lang",
			"plugin:blog_authors",
			"plugin:blog_authors_lang",
			"plugin:blog_images",
			"plugin:blog_images_lang"
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}
	
	
}

?>