<?php
/*
	Stempora web framework
	copyright (c) 2002-2013 Stempora
		web:  www.stempora.com
		mail: support@stempora.com

*/


class CSQLAdmin extends CLibrary {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $form;

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $functions;
		

	function CSQLAdmin($section , $templates , $db , $tables , $extra = "") {
		global $_CONF;

		if (!$_GET["page"])
			$_GET["page"] = 1;		


		parent::CLibrary("SQLAdmin");
		
		//checking if the templates are orblects or path to a template file
		if (!is_array($templates))					
			//if path the load the tempmate form that file
			$this->templates = array("generic_form" => new CTemplate($templates));
		else
			$this->templates = $templates;
		
		$this->db = $db;
		$this->tables = $tables;
		//extra variables to be passed to cform
		$this->extra = $extra;

		if (is_array($section)) {
			$this->forms = $section;			
		} else {
		
			//loading the forms , changed the varialbes locations, but still keeping the compatibility
			$path = ($_CONF["forms"]["adminpath"] ? $_CONF["forms"]["adminpath"] : $_CONF["formspath"] );
			
			//debuging part 
//			echo "<br>FILE:SQLADMIN:MAIN:{$path}{$section}.xml";
			if (defined("PB_DEBUG") && (PB_DEBUG == "1"))
				echo "<br>FILE:SQLADMIN:MAIN:{$path}{$section}.xml";

			$conf = new CConfig( $path . $section . ".xml");

			$this->forms_path = dirname($path . $section . ".xml");

			$this->forms = $conf->vars["form"];

			//loading the edit/add forms
			if (is_array($this->forms["forms"])) {
				
				foreach ($this->forms["forms"] as $key => $val) {	

					$form = "";

					if (is_array($val)) {
						$form = CForm::Process($path . $val["file"]);	
						$this->forms["forms"][$key] = $form;						
						$this->forms["forms"][$key]["type"] = $val["type"];
					}
					

					if (strstr($val,"SHOW::")) {						
						$tmp = explode("::" , $val);						
						$form = is_array($this->forms["forms"][$tmp[1]]) ? $this->forms["forms"][$tmp[1]] : CForm::Process($path . $this->forms["forms"][$tmp[1]]);
						CForm::__private__showonly($form);
					} else 					
						if (file_exists($path . $val) && trim($val)){
							$form = CForm::Process($path . $val);
						}

					if (is_array($form)) {
						$this->forms["forms"][$key] = array_merge(
									$form , 
									array(
										"table" => &$this->forms["table"],
										"table_lang" => &$this->forms["table_lang"],
										"table_uid" => &$this->forms["table_uid"],
										"urilinks" => &$this->forms["urilinks"],
										"uridata" => &$this->forms["uridata"] 
									)
								);

						if (in_array($key , array("store" , "add" , "edit" , "details" , "search")) && !isset($this->forms["forms"][$key]["type"])) {
							$this->forms["forms"][$key]["type"] = "FORM";
						} else {
							if (in_array($key , array("list" , "search")) && !isset($this->forms["forms"][$key]["type"])) {
								$this->forms["forms"][$key]["type"] = "LIST";
							}							
						}						
					}
				}
				
				//prepare buttons
				foreach ($this->forms["forms"] as $key => $val) {	
					if ((($key == "edit")||($key == "add")) && isset($this->forms["forms"][$key]["buttons"]["button_edit"]))
						unset($this->forms["forms"][$key]["buttons"]["button_edit"]);
			
					if (($key == "details") && isset($this->forms["forms"][$key]["buttons"]["button_save"]))
						unset($this->forms["forms"][$key]["buttons"]["button_save"]);

					if (!($_GET["returnurl"] || $_POST["returnurl"]) && isset($this->forms["forms"][$key]["buttons"]["button_back"]))
						if (is_array($this->forms["forms"][$key]["buttons"]["button_back"])) {
							unset($this->forms["forms"][$key]["buttons"]["button_back"]);
						}

				}					

				if (is_array($this->forms["forms"]["search"])) {
					//prepare the list to be shown under a cform box
					$search = &$this->forms["forms"]["search"];

					if (is_array($search["search"]["simple"]) && is_array($search["search"]["advanced"])) 
						$search["search"] = $search["search"][$_GET["advanced"] ? "advanced" : "simple"];					

					if (is_array($search["search"])) {
						$search_type = &$search["search"];

						$search["fields"] = array_merge((array)$search["fields"] , (array)$search_type["fields"] );
						//append a field to show all the fields when a submit button is pressed

						//prepare the list form

						//check if the fields in the list will apear dinamicaly
						if (is_array($search_type["fields"]["fields"])) {

							if (is_array($_GET["fields"])) {
								$fields_list = $_GET["fields"];
							} else {							
								$fields_list = explode("," , strlen($_GET["fields"]) ? $_GET["fields"] : $search_type["fields"]["fields"]["default"]);
							}

							//if no getfields then set the default fields
							if (!is_array($_GET["fields"]))
								$_GET["fields"] = $fields_list;

							//process the $_GET["fields"]
							if (is_array($_GET["fields"])) {
								foreach ($_GET["fields"] as $__key => $__val) {
//									if ($__key != $__val) {
										$_GET["fields"][$__val] = $__val;
										unset($_GET["fields"][$__key]);
//									}
								}

//								debug($_GET["fields"]);
								
							}
							

							
							//remove the fields which arent defined, ONLY IF $_GET[fields] is set
							if (is_array($search_type["header"]) && is_array($_GET["fields"]) ) {
								foreach ($search_type["header"] as $key => $val) {
									if (!array_exists($key , $fields_list )) {
										unset($search_type["header"][$key]);
									}							
								}						
							}

						} else {
							// add all the existing gields
							if (is_array($search_type["header"]) && count($search_type["header"]))
								$this->forms["forms"]["list"]["fields"] = array_merge($search_type["header"],$this->forms["forms"]["list"]["fields"]);
						}

					}
				}
			}
		}

		$this->form = new CForm($this->templates["generic_form"], $db , $tables);

}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function FormList($items = "" , $return_ajax = false , $page = 1 , $array = false) {
		global $base , $_SESS;

		$found_search = true;


			
		//prepare the listing way
		if (is_array($this->forms["forms"]["search"])) {
			if ($this->forms["forms"]["search"]["search"]["required"] == "true")
				$found_search = false;			
		} else
			$found_search = true;				

		//checking if hte values weren't inputed ion the main object

		if (is_array($this->items)) {			
			$items = $this->items;
			$items_count = count($items);
		} else {

			if (is_array($items)) {

				if ($items["items"] && isset($items["count"])) {

					$sortable_fields = $items["table_fields"];
					$tmp_items = $items["items"];
					$items_count = $items["count"];
					$items = $tmp_items;

					//debug($items,1);
				} else {
					$items_count = count($items);
				}
			}
		}

		//crap, preexecute a function, which is suposed in some times to preload the items too

		//check if exists a search screen
		if (is_array($this->forms["forms"]["search"])) {
			//prepare the list to be shown under a cform box
			$search = &$this->forms["forms"]["search"];

			if (($_GET["hidesearch"] != "true")) {
				//$this->forms["forms"]["list"]["border"] = "";
				$this->forms["forms"]["list"]["subtitle"] = $this->forms["forms"]["list"]["title"];

			}

			//process the buttons
			if ($_GET["advanced"]) {
				unset($search["buttons"]["butt_advanced"]);
				unset($search["buttons"]["button_advanced"]);
			} else {
				if (isset($search)) {
					if (is_array($search["buttons"]["butt_simple"]))
						unset($search["buttons"]["butt_simple"]);

					if (is_array($search["buttons"]["button_simple"]))
						unset($search["buttons"]["button_simple"]);
				}			
			}

			if (is_array($search["search"])) {
				$search_type = &$search["search"];

				//put the remain fields in the front of the other in the listing xml
				if (is_array($search_type["header"])) {
					$this->forms["forms"]["list"]["fields"] = array_merge($search_type["header"],$this->forms["forms"]["list"]["fields"]);
				}								


				//check if exists  return url then show the return button
				if (!$_GET["returnurl"] && is_array($search["buttons"]["button_back"]))
					unset($search["buttons"]["button_back"]);
				
				//prepare the list form

				//check if the fields in the list will apear dinamicaly
				if (is_array($search_type["sql_fields"])) {

					//prepare the search query
					if (is_array($search_type["sql_fields"])) {

						

						//process the variables from the input source
						CForm::ProcessVariables($search, $_GET);

						foreach ($search_type["sql_fields"] as $key => $val) {
							//add to query only variables which are found in $_GET, others get ignored

							if (is_Array($val)) {

								switch (strtolower($val["type"])) {
									case "keyword":
										if (trim($_GET[$key])) {
											$_fields = explode(","  , $val["fields"]);
											$_query = "";

											switch ($val["search"]) {
												default:
												case "full":
													foreach ($_fields as $_k => $_v) {
														$_query[] = " `$_v` LIKE '%{$_GET[$key]}%'"; 
													}

													$query[] = " ( " . implode(" OR " , $_query ) . " ) ";

												break;

												case "split":
													$_data = explode(" " , $_GET[$key]);
													
													if (count($_data)) {
														foreach ($_data as $__k => $__v) {

															foreach ($_fields as $_k => $_v) {
																$_query[$_v][] = " `$_v` LIKE '%{$__v}%'"; 
															}
														}
													}

													if (is_array($_query) && count($_query)) {
														foreach ($_query as $_k => $_v) {

															$query[] = " ( " . implode(" OR " , $_v ) . " ) ";
														}
													}
												break;
											}
										}
										//$query[] = " ( " . implode(" OR " , $_query ) . " ) ";

										//debug($query ,1);
									break;
								}								

							} else {						
								switch (strtolower($val)) {
									case "=":
										if (isset($_GET[$key]) &&  strlen($_GET[$key]))
											$query[] = " `$key`='{$_GET[$key]}'";
									break;

									case "int":
										$query[] = " `$key`=" . ((int)$_GET[$key]) . "";
									break;
		
									case "%":
										if (isset($_GET[$key]) && strlen($_GET[$key]))
											$query[] = " `$key` LIKE '%{$_GET[$key]}%'";
									break;

									case "?%":
										if (isset($_GET[$key]) && strlen($_GET[$key]))
											$query[] = " `$key` LIKE '{$_GET[$key]}%'";
									break;

									case "%?":
										if (isset($_GET[$key]) && strlen($_GET[$key]))
											$query[] = " `$key` LIKE '%{$_GET[$key]}'";
									break;

									case "range":
										$start = "";
										$end = "";

										if ($_GET[$key . "_start"]) 
											$start = $_GET[$key . "_start"];

										if ($_GET[$key . "_end"])
											$end = $_GET[$key . "_end"];

										if ($start && $end)
											$query[] = " ((`$key` <= '$end') AND (`$key` >= '$start')) ";
										else
											if ($start)
												$query[] = " `$key` >= '$start' ";
											else if ($end)
													$query[] = " `$key` <= '$end' ";									
									break;

									case "in_set":
										if ($_GET["$key"]) {
											$query[] = " FIND_IN_SET('" . $_GET[$key] . "' , `{$key}`) ";
										}																		
									break;

									case "in":
										if (strlen($_GET[$key])) {
											$__tmp = implode("','" , explode("," , $_GET[$key]));								
											$query[] = " `{$key}` IN ( '{$__tmp}' ) ";
										}									
									break;

									//prepare the fields allowed for sorting
									$__fields[] = $key;

								}						
							}
						}						

						//add the final condition to list
						if (is_array($query)) {
							
							
							if (count($query) > 1) {
								$this->forms["forms"]["list"]["sql"]["vars"]["condition"]["import"] = implode(" " . (array_exists($_GET["relation"] , array("and" , "or")) ? $_GET["relation"] : "and") . " " , $query);
							} else
								$this->forms["forms"]["list"]["sql"]["vars"]["condition"]["import"] = $query[0];
							
							if (!$this->forms["forms"]["list"]["sql"]["vars"]["req_condition"]["import"]) 
								$this->forms["forms"]["list"]["sql"]["vars"]["condition"]["import"] = " WHERE " . $this->forms["forms"]["list"]["sql"]["vars"]["condition"]["import"];
							else
								$this->forms["forms"]["list"]["sql"]["vars"]["condition"]["import"] = $this->forms["forms"]["list"]["sql"]["vars"]["req_condition"]["import"] . " AND " . $this->forms["forms"]["list"]["sql"]["vars"]["condition"]["import"];


							$found_search = true;
							
						} else {							
							if ($this->forms["forms"]["list"]["sql"]["vars"]["req_condition"]) 
								$this->forms["forms"]["list"]["sql"]["vars"]["condition"] = $this->forms["forms"]["list"]["sql"]["vars"]["req_condition"]; 
						}
						
					}

					//add the order field to the sql field
					if ($_GET["order"] && array_key_exists($_GET["order"] , $search_type["sql_fields"]))
						$this->forms["forms"]["list"]["sql"]["vars"]["order"]["import"] = $_GET["order"];
					
					//add the ordering mode to the sql vars
					if ($_GET["order_mode"] && array_exists($_GET["order_mode"] , array("ASC" , "DESC" )))
						$this->forms["forms"]["list"]["sql"]["vars"]["order_mode"]["import"] = $_GET["order_mode"];					

					//prepare the items number
					if ((int)$_GET["items"])
						$this->forms["forms"]["list"]["items"] = $this->forms["forms"]["list"]["sql"]["vars"]["items"]["import"] = (int)$_GET["items"];
					else
						$this->forms["forms"]["list"]["sql"]["vars"]["items"]["import"] = $this->forms["forms"]["list"]["items"];					
				
				}
				
			} else {
				//required condition
				$this->forms["forms"]["list"]["sql"]["vars"]["condition"] = $this->forms["forms"]["list"]["sql"]["vars"]["req_condition"]; 
			}
		}



		if ($found_search || ($_GET["search"])) {



			$_GET["page"] = $_GET["page"] ? $_GET["page"] : 1;
			//auto index the element
			$start = $this->forms["forms"]["list"]["items"] * ($_GET["page"] - 1 );

			if (is_array($items) && count($items)) {

				if ($items["list"] && is_array($items["list"])) {

					foreach ($items["list"] as $key => $val) {
						$items["list"][$key]["_count"] = ++$start;
					}			

				} else {


					if (!array_key_exists("list" , $items) && !array_key_exists("items" , $items)) {
						foreach ($items as $key => $val) {
							$items[$key]["_count"] = ++$start;
						}			
					} else {

						unset($items["list"]);
					}
										
				}

			}		


			$this->form->functions["process_record"] = $this->functions["list_process"];
			$this->form->functions["pre_process_record"] = $this->functions["list_preprocess"];



		
			if (is_array($this->functions["list"]))
				call_user_func_array($this->functions["list"], array($items , $items_count));



			//check if is a normal request or an ajax request
			//if ($return_ajax) {

				//return $this->form->AjaxList($this->forms["forms"]["list"] , $items , $items_count , $this->extra["list"] , $page);
			/*} else */{			
				//$data = new CForm($this->templates["generic_form"], &$this->db , &$this->tables);

				if ($array == false) {

					//prepare the items

					if (count($items)) {
							$arr_data = array(
								"items"			=> $items,
								"table_fields"	=> $sortable_fields,
								"count"			=> $items_count
							);
					} else {
							$arr_data = null;
					}
										


					$return = $this->form->SimpleList(
							$this->forms["forms"]["list"] , 
							$arr_data, 
							$items_count , 
							is_array($this->extra) ? $this->extra["list"] : ""
					);


				} else {				
					return $this->form->SimpleList($this->forms["forms"]["list"] , $items , $items_count , $this->extra["list"] , null , true);
				}
			}

		}

		//at this stage remove the unused sections
		unset($search["search"]);

//		debug($this->templates["generic_form"],1);

		if (is_array($search) && ($_GET["hidesearch"] != "true")) {			
			$search_form = new CForm($this->templates["generic_form"], $this->db , $this->tables);
			return $search_form->Show($search , array("values"=>$_GET) , array("after" => $return));
		} else
			return $return;
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetFunction( $form , $event , $function) {
		$this->functions[$form][$event] = $function;
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ListProcess($pre = "" , $after = "" ) {

		$this->functions["list"]["pre"] = $pre;
		$this->functions["list"]["after"] = $after;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function RidCond($uid , $vars) {
		$tmp = explode("," , $uid);

		foreach ($tmp as $k => $v) {

			if ((int)$vars[$v]) {
				$cond[] = "`{$v}` = " . $vars[$v] ." ";
			} else {							
				$cond[] = "`{$v}` = '" . $vars[$v] ."' ";
			}
		}

		$cond = implode(" AND " , $cond);

		return $cond;

	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function StoreRecord($redirect = true) {
		global $base, $_CONF , $_LANG_ID;


		//validating the input data
		if ($_SERVER["REQUEST_METHOD"] == "POST") {

			$uid_cond = $this->RidCond($this->forms["table_uid"] , $_POST);									


			//doing a autodetect for storing type , edit or add
			//if $_GET["type"]	is set is simple, else detecting after the id form
			if (!isset($_GET["type"])) {

				$tmp = explode("," , $this->forms["table_uid"]);

				$edit = true;

				foreach ($tmp as $key => $val) {
					if (!$_POST[$val]) {
						$edit = false;
					}					
				}

				$_GET["type"] = $edit ?"edit" : "add";
				
			}	

			//if validation succeeds then i move the files from /tmp to their directory, else i will proceed to add
			//precheck for uploaded files, like temporary images, etc.
			$form = $this->forms["forms"][$_GET["type"]];



			if (is_array($form["fields"])) {
				
				$form_fields = array();
				foreach ($form["fields"] as $key => $val) {

					if ($key == "box") {
						foreach ($form["fields"]["box"] as $k => $v) {							

							if (is_array($v["fields"])) {
								$form_fields = array_merge(
									$v["fields"],
									$form_fields
								);
							}
							
						}				
					} else {					
						$form_fields[$key] = $val;
					}

				}				

			} 
			
			if (is_array($form_fields)) {

				$_POST = CForm::ProcessVariables(
					array(
						"fields"	=> $form_fields
					), 
					$_POST
				);



				foreach ($form_fields as $key => $val) {
					//update the name value
					if (!$val["name"])
						$val["name"] = $key;
				
					switch ($val["type"]) {


						case "checkbox":
							if ($this->_set_store_nochecks != true) {
								if (!isset($_POST[$key])) {
									$_POST[$key] = "0";
								}
							}							
						break;

						case "upload":
							$file = true;
						case "image":
							unset($_POST[$key]);

							CForm::__private_uploads_pre($val , $_fields);
							
						break;
					}							
				}						

			}



			//if not default language then unvalidate the form
			if ($_REQUEST["lang_id"]) {
				$lang = CXMLFormLanguage::GetLanguage($_REQUEST["lang_id"]);

				if (!$lang["default"]) {
					$_GET["FORMvalidate"] = "false";
				}
				
			}
			

			//force for no validation sometimes
			if ($_GET["FORMvalidate"] == "false") {
				$fields = "";
			} else {
				$fields = $this->form->Validate(
					array(
						"fields"	=> $form_fields,
						"table_uid"	=> $form["table_uid"] , 
						"table"		=> $form["table"],
						"table_lang"	=> $form["table_lang"],
					), 
					$_POST
				);
			}

				
			if (!is_array($fields)) {
				//adding to database

				if ($this->functions["onstore_prepare"])
					call_user_func($this->functions["onstore_prepare"] , $_POST , $this->forms);


				//check if its an isert
				if (is_array($this->db->QFetchArray("SELECT * FROM " . $this->tables[$this->forms["table"]] . " WHERE {$uid_cond}"))) {

					$this->db->QueryUpdate($this->tables[$this->forms["table"]] , $_POST , $uid_cond );

					//update the language file too
					

					$id = $_POST[$this->forms["table_uid"]];
					$was_added = false;
				} else { 

					$id = $this->db->QueryInsert($this->tables[$this->forms["table"]] , $_POST);

					$_POST[$this->forms["table_uid"]] = $id;
					$was_added = true;

					//regenerate the condition
					$uid_cond = $this->RidCond($this->forms["table_uid"] , $_POST);									
					
					//if i have an ordering function then auto generate the id
					if (is_array($this->forms["forms"]["list"]["order"])) {

						$ofield = $this->forms["forms"]["list"]["order"]["field"];

						$this->db->Query(
							"UPDATE {$this->tables[$this->forms['table']]} SET {$ofield}={$id} WHERE {$this->forms[table_uid]}={$id}"
						);

						//remove the order field

						unset($_POST[$ofield]);

					}
					
				}	
				
				//update the language data
				if ($this->forms["table_lang"]) {
					$old_lang = $this->db->QFetchArray(
						"SELECT * FROM " . $this->tables[$this->forms["table_lang"]] . " WHERE " . 
						"{$uid_cond} AND " . 
						"lang_id={$_POST[lang_id]} "
					);						

					if (is_Array($old_lang)) {
						$this->db->QueryUpdate(
							$this->tables[$this->forms["table_lang"]] , 
							$_POST,
							"{$uid_cond} AND lang_id={$_POST[lang_id]} "
						);
					} else {
						$this->db->QueryInsert(
							$this->tables[$this->forms["table_lang"]] , 
							$_POST
						);

					}
					
				}


				//data stored, taking care of uploade files/images, etc				
				if (is_array($form_fields)) {
					foreach ($form_fields as $key => $val) {

						//update the name value
						if (!$val["name"])
							$form_fields[$key]["name"] = $val["name"] = $key;

						switch ($val["type"]) {
							case "upload":
							case "image":


								//checking if is really e file, else if no tmp is set then it can be the folder where are stored the values
								if (CForm::__private_uploads_after($val)) {
									$_POST[$key] = 1;

									$this->db->QueryUpdate(
										$this->tables[$this->forms["table"]] , 
										$_POST , 
										$uid_cond 
									);

									if ($this->forms["table_lang"]) {
										$this->db->QueryUpdate(
											$this->tables[$this->forms["table_lang"]] , 
											$_POST , 											
											"{$uid_cond} AND lang_id={$_POST[lang_id]} "
										);
									}
								}

							break;

							default:
								if (is_array($val["file"]))
									SaveFileContents(
										$_CONF["path"] . $_CONF["upload"] . $val["file"]["path"] . $val["file"]["default"] . $_POST[$val["file"]["field"]] . $val["file"]["ext"] , 
										//just changed
										/*stripslashes*/($_POST[$key])
									);
							break;

						}
					}


					//clean files
					foreach ($form_fields as $key => $val) {
						switch ($val["type"]) {
							case "upload":
							case "image":
								CForm::__private_uploads_clean($val);
							break;
						}
					}

				}

				if (!$_GET["type"]) {
					$_GET["type"] = $_POST[$this->forms["table_uid"]] ? "edit" : "add";
				}

				if ($this->functions["onstore"])
					call_user_func($this->functions["onstore"] , $_POST , $this->forms);


				//$this->templates["generic_form"]->blocks["Temp"]->input = $this->forms["forms"][$_GET["type"]]["redirect"];
				//replacing the values
				//die($this->templates["generic_form"]->blocks["Temp"]->Replace($_POST));

				//do this before anything
				if ($_POST["_after_save"]) {
					$_POST["after_save"] = $_POST["_after_save"];
				}				
				
				if ($_POST["after_save"]) {
					$vars = $this->form->GlobalVars($this->forms["forms"]["add"] , array_merge($_GET , $_POST)); 
					//the user wants to add another record after he adds the current one, so lets help him do it easy

					UrlRedirect(
						CTemplateStatic::Replace(
							$vars["self.uri.add"] . "&after_save={$_POST[after_save]}&returnurl=" . $_POST["returnurl"],
							$_GET , 
							$_POST
						)
					);
				}


				if ($_POST["redir_lang_id"]) {

					$x = parse_url($_POST["request_uri"]);
					parse_str($x["query"] , $data);

					$data["lang_id"] = $_POST["redir_lang_id"];

					header("Location:" . basename($_SERVER["SCRIPT_NAME"]) . "?" . http_build_query($data));
					exit;
				}
								

				if ($_GET["returnURL"]) {
					header("Location:" . urldecode($_GET["returnURL"]));
					exit;
				}

				if ($_POST["returnurl"]) {

					switch ($_GET["storeredirect"]) {

						case "STOREDETAILS":
							header("Location:" . basename($_SERVER["SCRIPT_NAME"]) . "?mod={$_GET[mod]}&sub={$_GET[sub]}&action={$this->forms[uridata][details]}&{$this->forms[table_uid]}={$_POST[$this->forms[table_uid]]}&returnurl={$_POST[returnurl]}");
							exit;
						break;

						case "ADDDETAILS":

							//if is a new adition the redirect to details
							if ($was_added) {
								header("Location:" . basename($_SERVER["SCRIPT_NAME"]) . "?mod={$_GET[mod]}&sub={$_GET[sub]}&module_id={$_GET[module_id]}&action={$this->forms[uridata][details]}&{$this->forms[table_uid]}={$_POST[$this->forms[table_uid]]}&returnurl={$_POST[returnurl]}");
								exit;
							} 
							//else co in next case
							
						default:
							$count = 1;
							while ($count < 10 ) {
								$_POST["returnurl"] = urldecode($_POST["returnurl"]);
								if ((substr($_POST["returnurl"],0,1) == "/") || stristr($_POST["returnurl"] , "?"))
									break;

								$count ++;
							}

							$this->templates["generic_form"]->blocks["Temp"]->input = $_POST["returnurl"];					
							header("Location:" . CTemplateStatic::Replace($_POST["returnurl"] , array_merge($_GET,$_POST)) );
							exit;
						break;

					}
				
				}
				
				if ($redirect == true) {
					header("Location: " . CTemplateStatic::Replace($this->forms["forms"]["add"]["redirect"] , array_merge($_GET,$_POST)));
					exit;
				} else {
					return true;
				}
			}
								
		} else {
			die("You cant access this link directly!");
			//redirecting to list page
			header("Location:" . str_replace("&action=store" , "" , $_SERVER["REQUEST_URI"]));
			exit;
		}				

		
		if (is_array($_fields["values"]))
			// read the default record, and merge the fields
			$fields["values"] = array_merge($fields["values"], $_fields["values"]);			

		if ($_POST[$this->forms["table_uid"]]) {			
			$data = $this->db->QFetchArray("SELECT * FROM " . $this->tables[$this->forms["table"]] . " WHERE `" . $this->forms["table_uid"] . "`='" . $_POST[$this->forms["table_uid"]] . "'" );
			
			$fields["values"] = array_merge((array)$data , (array)$fields["values"]);
	//		debug($fields);
		}			

		
		return $this->form->Show($this->forms["forms"][$_GET["type"]] , $fields , $this->extra[$_GET["type"]]);				
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function RestoreURI($section) {
		if (is_array($_GET)) {
			foreach ($_GET as $key => $val) {
				$out[$key] = $key . "=" . $val;
			}
						
			$out[$this->forms["uridata"]["action"]] = $this->forms["uridata"]["action"] . "=" . $this->forms["uridata"][$section];
			unset($out[$this->forms["table_uid"]]);

			return CryptLink($_SERVER["SCRIPT_NAME"] . "?" . implode("&" , $out));

			//return $_
		}		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DoEvents($section = ""  , $extra = "" , $values = "") {
		global $base , $_CONF;

		if (is_array($extra)) {
			$this->extra = array_merge($this->extra , $extra);
		}

		switch ($_GET[$this->forms["uridata"]["action"]]) {

			case $this->forms["uridata"]["delete"]:

				if (($_GET["rconfirm"] == "true")&&($_GET["confirmed"] != "true")) {
					return $this->templates["generic_form"]->blocks["DeleteItem"]->Replace(array(
									"title" => $_GET["title"] ? urldecode($_GET["title"]) : "Delete Item",
									"description" => $_GET["description"] ? urldecode($_GET["description"]) : "Are you sure you want to delete this record?",
									"return" => urldecode($_GET["returnURL"]),
									"cancel_location" => urldecode($_GET["returnURL"]),
									"delete_location" => $_SERVER["REQUEST_URI"] . "&confirmed=true"
								));
				}

				if ($_SERVER["REQUEST_METHOD"] == "POST") {

					if (is_array($_POST[$this->forms["table_uid"]])) {
						foreach ($_POST[$this->forms["table_uid"]] as $key => $val) {
							$this->db->Query("DELETE FROM " . $this->tables[$this->forms["table"]] . " WHERE `" . $this->forms["table_uid"] . "`='" . $val . "'" );

							if ($this->forms["table_lang"]) {
								$this->db->Query("DELETE FROM " . $this->tables[$this->forms["table_lang"]] . " WHERE `" . $this->forms["table_uid"] . "`='" . $val . "'" );
							}
						}
					}


					if ($_GET["returnURL"]) {
						header("Location: " . CryptLink(urldecode($_GET["returnurl"])));
						exit;
					} else {
						header("Location:" . $_SERVER["HTTP_REFERER"]/*$this->RestoreURI("list")*/);
						exit;
					}

				} else {
				
					//searching for element
					$data = $this->db->QFetchArray("SELECT * FROM " . $this->tables[$this->forms["table"]] . " WHERE `" . $this->forms["table_uid"] . "`='" . $_GET[$this->forms["table_uid"]] . "'" );

					//check for multilanguage table existence
					if ($this->forms["table_lang"]) {
						$data2 = $this->db->QFetchArray(
							"SELECT * FROM 	" . $this->tables[$this->forms["table_lang"]] . " ".
							"WHERE {$this->forms['table_uid']} ='" . $_GET[$this->forms["table_uid"]] . "' AND	lang_id={$_GET[lang_id]}" 
						);

						if (is_array($data2)) {
							$data = array_merge(
								$data , 
								$data2
							);
						}
						
					} 

					//checking if this is a valid data
					if (is_array($data)) {

						if ($this->functions["ondelete"])
							call_user_func($this->functions["ondelete"] , $data , $this->forms);


						$this->db->Query("DELETE FROM " . $this->tables[$this->forms["table"]] . " WHERE `" . $this->forms["table_uid"] . "`='" . $_GET[$this->forms["table_uid"]] . "'" );

						if ($this->forms["table_lang"]) {
							$this->db->Query("DELETE FROM " . $this->tables[$this->forms["table_lang"]] . " WHERE `" . $this->forms["table_uid"] . "`='" . $_GET[$this->forms["table_uid"]] . "'" );
						}

					}


				
					if ($_GET["returnURL"]) {
						header("Location: " . CryptLink(urldecode($_GET["returnURL"])));
						exit;
					} else {
						header("Location:" . $_SERVER["HTTP_REFERER"]/*$this->RestoreURI("list")*/);
						exit;
					}
				}
				
			break;

			case $this->forms["uridata"]["store"]:
				return $this->StoreRecord();
			break;

			case $this->forms["uridata"]["add"]:

				if (is_array($values)) {
					$fields["values"] = $values["add"];
				}
				
				return $this->form->Show($this->forms["forms"]["add"] , $fields , $this->extra["add"]);
			break;

			case $this->forms["uridata"]["edit"]:
				//searching for element

				$this->ProcessExtra("edit");

				if (is_array($values) && is_array($values["edit"])) {
					$data = $values["edit"];
				} else {
	

					
					//if no tables then no database query
					if ($this->forms["table"]) {

						$cond = $this->RidCond($this->forms["table_uid"] , $_GET);									

						$data = $this->db->QFetchArray("SELECT * FROM " . $this->tables[$this->forms["table"]] . " WHERE {$cond}" );

						//check for multilanguage table existence
						if ($this->forms["table_lang"]) {
							$data2 = $this->db->QFetchArray(
								"SELECT * FROM 	" . $this->tables[$this->forms["table_lang"]] . " ".
								"WHERE {$cond} AND	lang_id={$_GET[lang_id]}" 
							);

							if (is_array($data2)) {
								$data = array_merge(
									$data , 
									$data2
								);
							}
							
						} 
					}
					

				}

				if ($this->functions["onedit"])
					call_user_func($this->functions["onedit"] , $data, $this->forms);

				//checking if this is a valid data
				if (is_array($data)) {
					$fields["values"] = $data;
					return $this->form->Show($this->forms["forms"]["edit"] , $fields , $this->extra["edit"]);
				} 

				header("Location:" . $this->RestoreURI("list"));
				exit;
				
			break;

			case $this->forms["uridata"]["details"]:

				$this->ProcessExtra("details");

				//if no tables then no database query
				if ($this->forms["table"]) {


					$cond = $this->RidCond($this->forms["table_uid"] , $_GET);									

					//searching for element
					$data = $this->db->QFetchArray("SELECT * FROM " . $this->tables[$this->forms["table"]] . " WHERE {$cond}" );

					//check for multilanguage table existence
					if ($this->forms["table_lang"]) {
						$data2 = $this->db->QFetchArray(
							"SELECT * FROM 	" . $this->tables[$this->forms["table_lang"]] . " ".
							"WHERE {$cond} AND	lang_id={$_GET[lang_id]}" 
						);

						if (is_array($data2)) {
							$data = array_merge(
								$data , 
								$data2
							);
						}
						
					} 
				}


				if ($this->functions["ondetails"])
					$data = call_user_func($this->functions["ondetails"] , $data , $this->forms);

				//checking if this is a valid data
				if (is_array($data)) {
					$fields["values"] = $data;
					return $this->form->Show($this->forms["forms"]["details"] , $fields, $this->extra["details"]);
				} 


				header("Location:" . $this->RestoreURI("list"));
				exit;
				
			break;

			case "ajax.download-file":

				if ($this->forms["table"]) {


					$cond = $this->RidCond($this->forms["table_uid"] , $_GET);									

					//searching for element
					$data = $this->db->QFetchArray("SELECT * FROM " . $this->tables[$this->forms["table"]] . " WHERE {$cond}" );

					//check for multilanguage table existence
					if ($this->forms["table_lang"]) {
						$data2 = $this->db->QFetchArray(
							"SELECT * FROM 	" . $this->tables[$this->forms["table_lang"]] . " ".
							"WHERE {$cond} AND	lang_id={$_GET[lang_id]}" 
						);

						if (is_array($data2)) {
							$data = array_merge(
								$data , 
								$data2
							);
						}
						
					} 
				}

				//read the field

				$field = CForm::GetField($this->forms["forms"]["add"] , $_GET["field"]);

				$path = ($GLOBALS["_ADMIN"] ? "../upload/" : "upload/") . 
						$field["path"] . 
						$field["file"]["default"] . 
						$data[$field["file"]["field"]] . 
						$field["file"]["ext"];

				if (file_exists($path)) {
					$mime = new CMime();
					$mime->Set("unknown");
					$mime->Filename($data[$_GET["field"] . "_file"]);

					CFile::ReadChunked($path);
					die();
				} else {
					throw new Exception("File '{$path}' doesnt exists!");
						
				}
				

			break;

			case "ajax.reorder-records":

				if ($this->forms["forms"]["list"]["order"]) {
					//this can be time consuming
					//set_time_limit(0);

					//shit
					if ($_POST["table_order"] && is_array($this->forms["forms"]["list"]["order"])) {

						//debug($_GET,1);

						$order = $this->forms["forms"]["list"]["order"];

						//read the items
						$items = $this->db->QFetchRowArray("SELECT {$this->forms[table_uid]} as id, {$order[field]} as oid FROM " . $this->tables[$this->forms["table"]] . " WHERE {$this->forms[table_uid]} in (" . implode("," , $_POST["table_order"]) . ") ORDER BY {$order[field]} {$order[mode]}" );

						if (is_array($items) && (count($items) == count($_POST["table_order"]))) {

							//invert the key with vars from new order
							foreach ($_POST["table_order"] as $key => $val) {
								$new_order[$val] = $key;
							}
							

							foreach ($items as $key => $val) {
								$items[$key]["noid"] = $items[$new_order[$val["id"]]]["oid"];
							}
							
							foreach ($items as $key => $val) {
								$this->db->QueryUpdate(
									$this->tables[$this->forms["table"]],
									array(
										$order["field"]	=> $val["noid"]
									),
									"{$this->forms[table_uid]} = {$val[id]}"
								);
							}
							
							die("1");
						}
					}

					die("0");
				}

				die("0");
							
			break;

			case $this->forms["uridata"]["search"]:
			case $this->forms["uridata"]["list"]:
			default:		

				if ($this->functions["load_records"]) {
					$values["list"] = call_user_func($this->functions["load_records"] , $data , $this->forms);

					if ($values["values"]["norecords"]) {
						$this->forms["list"]["norecords"] = $values["values"]["norecords"];
					}
					
				}

				if ($_GET["ajax"] == "true") {
					echo $this->FormList($values["list"] , true , $_GET["page"]);
					die();
				} else {				
					if (is_Array($values) && is_array($values["list"])) {
						return $this->FormList($values["list"]);
					} else {
						return $this->FormList($values);
					}
					
				}
			break;

		}	
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessExtra($type) {

		if (!is_array($form = $this->forms["forms"][$type])) {
			return "";
		}

	
		if (!is_array($after = $this->forms["after"][$type])) {
			return "";
		}
		

		switch ($after["type"]) {
			case "sqladmin":	

				if (!$after["restricted"] || ($after["restricted"] && !CForm::__isRestricted($after["restricted"]))) {

					if (is_array($after["xml"])) {

						foreach ($after["xml"] as $key => $val) {
							$data = new CSQLAdmin($val , $this->templates,$this->db,$this->tables);
							$this->extra[$type]["after"] .= $data->DoEvents();
						}					
					} else {
						$data = new CSQLAdmin($after["xml"] , $this->templates,$this->db,$this->tables);
						$this->extra[$type]["after"] = $data->DoEvents();				
					}
					

				}
				

			break;
		}
	}
	
}

/*

History

v0.0.4
	Unreleased
		Fixed the saving the value in a file, added stripslashes

v0.0.3
	Wensday 24 March 2004
		Moved SimpleList from sqladmin in forms class
		Added image element to SimpleList
		Added date element to SimpleList	
		Instead of $form array the data can be a path to an xml file
		The template is passed to sql admin, no longer loading from generic_form

v0.0.2
	Tuesday 16 March 2004
		Fixed, add/edit SQL query.

	Sunday 14 March 2004
		Added search support for list section.
		Added header titles to list section.
		Fixed the buttons apearance in list. ( they dont apear broken anymore )
		Added upload/resize/efects image form to forms library, FUCK loosing the image if the forms isnt complety
		validated from first time.
		Added html editor to forms library.		
		Fixed the image loosing when the form wasnt validated.
		Added the download from web image.

v0.0.1
	Wensday 3 March 2004 
		First version with basic options, edit, list, add.

*/
?>