<?php



//change this to match your own location. you can change this directly from admin panel 
date_default_timezone_set('Europe/Bucharest');

define("HTML_MINIFY" , false);
define("STP_DISABLE_CATEGORIES" , "0");
define("STP_ENABLE_ONEPAGE" , "0");
define("STP_DISABLE_MODULE_LAYOUTS" , "0");
define("STP_DISABLE_MODULE_WIDGETS" , "0");
define("STP_DISABLE_MODULE_LANGUAGES" , "0");
define("STP_DISABLE_MODULE_PARALLAX" , "0");
define("STP_DISABLE_MODULE_LAYOUT_BG" , "0");
define("STP_BOOTSTRAP" , "1");

//enable to see stats at the bottomof the page ( php executin tiome / querie / used memmory )
define("STP_SHOW_STATS" , "0");

//by activating the following will let anyone enter the cms and see it without loggin in
define("STP_ENABLE_DEMO" , "0");




if ($_ADMIN) {
	define("_3RDPARTY","./3rdparty/");	
	define("_LIBPATH","./lib/");	
	define("_TPLPATH" , "./assets/");
	define("_XMLCACHE" , "../upload/cache/xml/");
	define("_UPLOADPATH" , "../upload/");
} else {
	define("_3RDPARTY","./admin/3rdparty/");	
	define("_UPLOADPATH" , "./upload/");

	if (!defined("_LIBPATH")) 
		define("_LIBPATH","./admin/lib/");
	if (!defined("_MODPATH")) 
		define("_MODPATH","./admin/modules/");			
}

$start = memory_get_usage();
$time = microtime(true);



//temporary fix for magic quotes
if (function_exists("get_magic_quotes_gpc") && get_magic_quotes_gpc()) {
    $process = array(&$_GET, &$_POST, &$_COOKIE, &$_REQUEST);
    while (list($key, $val) = each($process)) {
        foreach ($val as $k => $v) {
            unset($process[$key][$k]);
            if (is_array($v)) {
                $process[$key][stripslashes($k)] = $v;
                $process[] = &$process[$key][stripslashes($k)];
            } else {
                $process[$key][stripslashes($k)] = stripslashes($v);
            }
        }
    }
    unset($process);
}


if (!defined("CLI")) {
	require_once _LIBPATH . "error/error.php";	
	ini_set("display_errors","1");
}

require_once _LIBPATH . "site.php";

$site = new CSite(($_ADMIN ? "" : "admin/") . "site.xml",$_ADMIN , true);


if ($_ADMIN) {
	$base_root = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') ? 'https' : 'http';
	$base_url = $base_root .= '://'. preg_replace('/[^a-z0-9-:._]/i', '', $_SERVER['HTTP_HOST']);
	if ($dir = trim(dirname($_SERVER['SCRIPT_NAME']), '\,/')) {
		$base_path = "/$dir";
		$base_url .= $base_path;
	}

	if ($_ADMIN) {
		$base_url = dirname($base_url);
	}

	$_SESSION['KCFINDER'] = array(
		//activate browser only if logged in 
		'disabled' => is_array($_SESSION["store"]["minibase"]["raw"]) ? false : true,
		'uploadURL' => $base_url,
		'uploadDir' => dirname(__DIR__ . "/") . "/"
	);
}


$site->Run();



$time2 = microtime(true);


function convert($size) {
     $unit=array('b','kb','mb','gb','tb','pb');
     return @round($size/pow(1024,($i=floor(log($size,1024)))),2).' '.$unit[$i];
}


if (STP_SHOW_STATS) {
	echo "<center><pre>PHP Execution Time: " . (($time2 - $time))  . " seconds</pre>";
	echo "<pre>Num Queries: " . $site->db->NumQueries() . "</pre>";
	echo "<pre>Queries Execution Time: " . $site->db->queries_runtime . "</pre>";
	echo "<center><pre>" . convert(memory_get_usage() - $start  ) . "</pre></center>";
}

/*

die();
*/
?>