<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSitemaps extends CPlugin{	
	
	var $tplvars; 

	function CSitemaps() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == $this->name) {

			//$this->__init();
			//$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Sitemap();
				break;

				case "sitemap":
					return $this->GoogleMap();
				break;
				
			}
		}		

	}

	function GoogleMap() {
		set_time_limit(0);
		//get all the modules
		$links = $this->read_links();

		global $_CONF;

		if (is_array($links)) {
			foreach ($links as $key => $val) {
				if ($val["lastmod"]) {
					$links[$key]["lastmod"]  = "<lastmod>" . date("Y-m-d" , $val["lastmod"]) . "</lastmod>";
				} else {
					$links[$key]["lastmod"]  = "";
				}

				if ($val["priority"]) {
					$links[$key]["priority"]  = "<priority>" . $val["priority"] . "</priority>";
				} else {
					$links[$key]["priority"]  = "";
				}
				
			}
		}

		global $base;

		//$this->module->plugins["modules"]->MimeXML();
		$mime = new CMime();
		$mime->Set("xml");

		$template = new CTemplateDynamic($this->tpl_path . "sitemap.xml");

		return $base->html->table(
			$template , 
			"Map" ,
			$links
		);
	}	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SiteMap() {
		global $_CONF , $_TSM;
		//check if the site is multilanguage
		$this->plugins["languages"]->LoadLanguages();
		$languages = $this->plugins["languages"]->languages;


		//read the sitemaps
		$modules = $this->plugins["modules"]->modules;
		if (is_array($modules)) {
			foreach ($modules as $key => $val) {

				if (!$val["module_protected"] && method_exists($this->plugins[$val["module_code"]] , "GetAllLinks") && ($val["mod_parent"] != "1100")) {					

					if (count($languages) ) {
						foreach ($languages as $k => $v) {
							$sitemaps[] = array(
								"url" => $_TSM["PRIV.BASE.HREF"] . ( $this->vars->data["set_multilanguage"] ? $v["lang_code"] . "/" : "" ) . "sitemap-xml/" . ($val["mod_id"] ? $val["mod_id"] : $val["module_code"]) . ".xml"
							);
						}
					}
					
				}

			}			
		}		


		global $base;


		//$this->module->plugins["modules"]->MimeXML();
		$mime = new CMime();
		$mime->Set("xml");

		$template = new CTemplateDynamic($this->tpl_path . "sitemaps.xml");

		return $base->html->table(
			$template , 
			"" ,
			$sitemaps
		);

	}
	

	function read_links() {
		global $_CONF;


		if (is_array($module = $this->plugins["modules"]->modules[$_GET["module"]])) {

			if (!$module["module_protected"] && method_exists($this->plugins[$module["module_code"]] , "GetAllLinks") ) {

				$this->module->plugins[$module["module_code"]]->GetAllLinks($module , $links);

			}

		}

		return $links;
	}

	
}

?>