<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CGoogleMaps extends CPlugin{
	
	var $tplvars; 

	function CGoogleMaps() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"gmap"				=> "gmap.htm",
			"widget"			=> "widget.htm",
			"header"			=> "header.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($slider , $widget = false) {
		global $_LANG_ID , $base;
		$this->__init();


		if (!is_array($slider)) {
			$slider = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:googlemaps']},
					{$this->tables['plugin:sliders']}

				WHERE 
					slider_module LIKE '{$this->name}' AND 
					gmap_id = slider_sid AND 
					slider_status = 1 AND 
					gmap_id='{$slider}'"
			);
		}

		if (!is_array($slider)) {
			return "";
		}
		

		$slider["widget"] = $widget;

		//set the default height
		if (!$slider["gmap_height"]) {
			$slider["gmap_height"] = "400";
		}

		$slider["lang_id"] = $_LANG_ID;

		$this->initScript();
		
		return $this->GoogleMap($slider);

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Add($slider) {

		if (!$slider) {
			return "";
		}
		

		$this->slider = $slider;

		//move the breadcrumb		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GoogleMap($slider) {
		global $base;


		$template = &$this->private->templates["gmap"];

		$slider["slider_gmap_type"] = strtoupper($slider["gmap_type"]);
		$slider["height"] = $slider["gmap_height"] ? "height:{$slider[gmap_height]}px" : "";

		//get all the markers
		$markers = $this->db->QFetchRowArray(
			"SELECT * FROM 
			{$this->tables['plugin:googlemaps_markers']} as i,
			{$this->tables['plugin:googlemaps_markers_lang']} as l

			WHERE 
				i.item_id = l.item_id AND 
				item_slider = {$slider[gmap_id]} AND 
				l.lang_id = {$slider[lang_id]}
			"
		);

		if (is_array($markers)) {
			foreach ($markers as $key => $val) {
				$markers[$key]["item_body"]		= trim(str_replace("\n" , "" , str_replace("\r" , "" , $val["item_body"])));
				$markers[$key]["image"]			= $val["item_image"] ? $template->blockREplace("Image" , $val) : "";
				$markers[$key]["item_title"]	= str_replace("'" , "\'" , $val["item_title"]);
				$markers[$key]["auto"]			= $val["item_show"] ? $template->blockREplace("Auto" , $val) : "";
			}			
		}
		
		$slider["markers"] = $base->html->Table(
			$template , 
			"Markers",
			$markers
		);

		$slider["grayscale"] = $slider["gmap_grayscale"] ? $template->blockReplace("Grayscale" , $slider)  : "";


		return $template->blockReplace(
			"Main",
			$slider
		);

	}
	
	function ShortCode($matches) {
		return $this->Render($matches[1]);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Widget($widget) {

		if (!is_array($widget)) {
			return "";
		}
		

		$this->__init();

		switch ($widget["widget_type"]) {
			case "1":
				return $this->WidgetSlider($widget);
			break;

		}

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function WidgetSlider($widget) {

		$content = $this->render($widget["settings"]["set_slider"] , true);

		if (!$content) {
			return "";
		}
		

		return $this->private->templates["widget"]->blockReplace(
			"Main" , 
			array(
				"title"	=> $widget["widget_show_title"] && $widget["widget_name"] ? $this->private->templates["widget"]->blockReplace("Title" , $widget) : "",
				"body"	=> $content,
			),
			$widget
		);
	}

	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function InitScript() {
		if ($this->scriptLoaded) {
			return "";
		}

		$this->scriptLoaded = true;

		$this->plugins["seo"]->AppendToHead($this->private->templates["header"]->blockReplace("Header"));		
	}

}

?>