<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CBackgrounds extends CPlugin{
	
	var $tplvars; 

	function CBackgrounds() {
		//$this->CPlugin($db, $tables , $templates);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetBackground($mod_id , $system = false) {
		global $_CONF , $_TSM;


		if ($system) {

			if ($mod_id != null) {
				$img = $this->db->QFetchArray(
					"SELECT * FROM {$this->tables['plugin:backgrounds']} WHERE find_in_set({$mod_id} , image_modules_global) ORDER BY rand() limit 1"
				);
			}
			
		} else {
			
			$img = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['plugin:backgrounds']} WHERE find_in_set({$mod_id} , image_modules) ORDER BY rand() limit 1"
			);
		}

		//load the default if exits
		if (!is_array($img)) {
			$img = $this->db->QFetchArray(
				"SELECT * FROM {$this->tables['plugin:backgrounds']} WHERE image_default=1 ORDER BY rand() limit 1"
			);
		}
		
		if (is_array($img)) {
			$this->__init();

			switch ($img["image_type"]) {

				//video
				case "2":
					$_TSM["BODY-EXTRA-ATTR"] .= $this->private->templates["main"]->blockReplace("Video" , $img);
				break;

				//solid color
				case "3":
					$_TSM["BODY-EXTRA-ATTR"] .= $this->private->templates["main"]->blockReplace(
						"Main" , 

						array(
							"image"	=> "",
							"color"	=> $this->private->templates["main"]->blockreplace("Color" , $this->plugins["layouts"]->Hex2Rgb($img["image_color"])  , array("alpha" => $img["image_color_alpha"])) ,
						)
					);
				break;

				//image
				default:
					$img["fixed"] = $img["image_img_fixed"] ? "fixed" : "scroll";

					$_TSM["BODY-EXTRA-ATTR"] .= $this->private->templates["main"]->blockReplace(
						"Main" , 

						array(
							"image"	=> $img["image_img"] ? $this->private->templates["main"]->blockreplace("Image" , $img) : "",
							"color"	=> $img["image_color"] ? $this->private->templates["main"]->blockreplace("Color" , $this->plugins["layouts"]->Hex2Rgb($img["image_color"])  , array("alpha" => $img["image_color_alpha"])) : "",
						)
					);
				break;
			}


			if ($img["image_inverted"]) {
				$_TSM["BODY-EXTRA-CLASS"] .= $this->private->templates["main"]->blockReplace("Inverted");
			}

			if ($img["image_overlay"]) {
				$_TSM["BODY-EXTRA-CLASS"] .= " " . $this->plugins["skineditor"]->Overlay($img["image_overlay"]);
			}

			
			

		}
		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {
		global $_LANG_ID , $_TSM;

		if (!$this->vars->data["set_style_boxed"]) {
//			return "";
		}
		
		if ($module["mod_id"]) {
			$this->GetBackground($module["mod_id"]);
		} elseif ($module["module_id"]) {
			$this->GetBackground($module["module_id"] , true);
		} else {
			$this->GetBackground(null , true);
		}
	}


	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"main"				=> "main.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	}

}

?>