<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CShortcodes extends CPlugin{
	
	var $tplvars; 
	var $dynamic;

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $template;
	
		

	function CShortcodes() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Process($content) {

		if (is_array($this->dynamic)) {
			foreach ($this->dynamic as $key => $val) {
				$content = preg_replace_callback(
					$val["pattern"],
					$val["method"],
					$content
				);
			}			
		}	

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM {$this->tables['plugin:shortcodes']} WHERE shortcode_status=1"
		);

		$template = new CTemplateDynamic($this->tpl_path . "developer.htm");

		//devsaver
		$items[] = array(
			"shortcode_pattern"	=> '[devsaver]',
			"shortcode_replace"	=> $template->blockReplace("Devsaver"),
			"shortcode_status"	=> 1,
			"shortcode_device"	=> "1,2,3"
		);
		//stempora
		$items[] = array(
			"shortcode_pattern"	=> '[stempora]',
			"shortcode_replace"	=> $template->blockReplace("Stempora"),
			"shortcode_status"	=> 1,
			"shortcode_device"	=> "1,2,3"
		);

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				
				$tmp = $val;

				//if multiline add the single line option too ( like bold or other stuff 
				if ($tmp["shortcode_multi"]) {
					$tmp["shortcode_multi"] = 0;
					$tmp = $this->ProcessShortCode($tmp);
					$pattern[] = $tmp["shortcode_pattern"];
					$replace[] = $tmp["shortcode_replace"];
				} 

				//then process the multline.
				$val = $this->ProcessShortCode($val);
				$pattern[] = $val["shortcode_pattern"];
				$replace[] = $val["shortcode_replace"];


			}
			

			$content = preg_replace(
				$pattern, 
				$replace, 
				$content
			);
		}
		
		return $content;
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessShortCode($data) {
		global $base;

		$replace = array(
			"/"	=> "\/",
			"["	=> "\[",
			"]"	=> "\]",
		);

		foreach ($replace as $key => $val) {
			$data["shortcode_pattern"] = str_replace($key , $val , $data["shortcode_pattern"]);
		}

		if ($data["shortcode_multi"]) {
			$data["shortcode_pattern"] = '/' . $data["shortcode_pattern"] . '/s';
		} else {
			$data["shortcode_pattern"] = '/' . $data["shortcode_pattern"] . '/';
		}

		$devices = explode("," , $data["shortcode_device"]);


		//tablet
		if ($base->device->isTablet()){

				//tablet
				if (!in_array(2, $devices)) {
					$data["shortcode_replace"] = "";
				}
				
		} elseif ($base->device->isMobile()) {

				//phone
				if (!in_array(3, $devices)) {
					$data["shortcode_replace"] = "";
				}

			} else {

				//desktop
				if (!in_array(1, $devices)) {
					$data["shortcode_replace"] = "";
				}

			}


		// if not valid for this device then replace with empty
		//$data[shortcode_replace] = "";
		return $data;

		
	}
	
	
}

?>