<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CPubMenu extends CPlugin{
	
	var $tplvars; 

	function CPubMenu() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		parent::DoEvents();

		if ($_GET["mod"] == "pubmenu") {
			$sub = $_GET["sub"];
			$action = $_GET["action"];

			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			switch ($sub) {


				case "landing":
					$_GET["sub"] = $sub = "items";
				case "items":
				case "cats":
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$this->PrepareFields($data->forms["forms"]);


					switch ($sub) {
						case "cats":
							$data->functions = array( 
									"ondelete" => array(&$this , "DeleteCat"),
							);					
						break;
					}
					
					return $data->DoEvents();
				break;


				case "texts":
					return $this->__adminTexts();
				break;


			}
		}
	}

	function adminGetWidgets($module) {

		$widgets = array(
			array(
				"type"				=> "4",
				"name"				=> "Categories",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
			),

			array(
				"type"				=> "1",
				"name"				=> "Special Offer",
				"module_name"		=> $module["mod_name"],
				"module"			=> $module["mod_id"],
				"module_type"		=> "1",
			),

		);

		return $widgets;

	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {

		//create default widgets

		$widgets = new CConfig($this->path . "install/widgets.xml");
		$widgets = $widgets->vars["widgets"];


		if (is_array($widgets)) {
			
			foreach ($widgets as $key => $val) {
				$val["module"] = $module_data["mod_id"];

				$wid = $this->plugins["widgets"]->AddWidget($val);

				$lay_widgets[$key] = $wid;
			}			
		}
	

		$lay_widgets["mod_name"] = $module_data["mod_name"];


		$layouts = array(
			"layout" => "0",
		);

		foreach ($layouts as $key => $val) {

			$layout_data = new CConfig(
				CTemplateStatic::Replace(
					CFile::GetContents($this->path . "install/"  . $key . ".xml"),
					$lay_widgets
				),
				"string"
			);

			$lid = $this->plugins["layouts"]->SaveLayout(
				$this->plugins["layouts"]->LoadFromString(
					$layout_data->vars["layout"]
				)
			);

			$layouts[$key] = $lid;
		}


		//update the layout id
		$this->plugins["modules"]->UpdateModuleSettings(
			$module_data["mod_id"] , 
			array(
//				"set_layout"				=> $layouts["layout"],
				"set_layout_cat"			=> $layouts["layout"],
				"set_layout_offer"			=> $layouts["layout"],
			)		
		);


		//execute any other standard operations
		parent::onCreate($module_data);		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {

		$tables  = array(
			"plugin:pubmenu_cats" , 
			"plugin:pubmenu_cats_lang",
			"plugin:pubmenu_images",
			"plugin:pubmenu_images_lang",
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}
	

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DeleteCat($record) {

		//delete images languages
		$this->db->Query("
			DELETE FROM {$this->tables['plugin:pubmenu_images_lang']}
			WHERE 
				item_id in ( 
					SELECT item_id FROM {$this->tables['plugin:pubmenu_images']} 
					WHERE 
						item_cat = {$record[cat_id]}
				);
		"
		);

		//delete images
		$this->db->Query("
			DELETE FROM {$this->tables['plugin:pubmenu_images']}
			WHERE item_cat = {$record[cat_id]}
		");

	}
	
}

?>