<?php 
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CWidgets extends CPlugin{
	
	var $tplvars; 

	function CWidgets() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"widgets"		=> "widgets.htm",
			"text"			=> "widget.text.htm",
			"fblike"		=> "widget.fblike.htm",
			"links"			=> "widget.links.htm",
			"social"		=> "widget.social.htm",
			"dropdown"		=> "widget.dropdown.htm",
			"acordeon"		=> "widget.acordeon.htm",
			"raw"			=> "widget.raw.htm",
			"tabs"			=> "widget.tabs.htm",
			"progress"		=> "widget.progress.htm",
			"countdown"		=> "widget.countdown.htm",

			"flipbox-set"	=> "widget.flipbox-set.htm",

			"counter"		=> "widget.counter.htm",
			"twitter"		=> "widget.twitter.htm",

			"image"			=> "widget.image.htm",

			"cards"			=> "widget.cards.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetWidget($wid , $settings = false) {
		global $_LANG_ID , $base;

		$wid = (int)$wid;


		if ($base->device->isTablet()) {
				$cond = " AND find_in_set(2,widget_device) ";
		} elseif ($base->device->isMobile()) {
				$cond = " AND find_in_set(3,widget_device) ";
			} else {
				$cond = " AND find_in_set(1,widget_device) ";
			}


		$data = $this->db->QFetchArray(
			"
				SELECT * FROM 
					{$this->tables['core:widgets']} as w,
					{$this->tables['core:widgets_lang']} as l
				WHERE 
					w.widget_id = l.widget_id AND 
					l.lang_id = {$_LANG_ID} AND
					w.widget_id = {$wid}
					{$cond}
			"
		);


		if (is_array($data) && $data["widget_settings"]) {
			$data["settings"] = unserialize(base64_decode($data["widget_settings"]));
		}


		return $data;

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Widgets($wdata , $return = "string") {
		global $base , $_LANG_ID;

		if (!$wdata) {
			return "";
		}

		$this->__init();

		//tablet
		if ($base->device->isTablet()) {
				$cond = " AND find_in_set(2,widget_device) ";
		} elseif ($base->device->isMobile()) {
				//phone
				$cond = " AND find_in_set(3,widget_device) ";
			} else {
				//desktop
				$cond = " AND find_in_set(1,widget_device) ";
			}
		
		//user modules
		$widgets = $this->db->QFetchRowArray(
			"
				SELECT * 
				FROM 
					{$this->tables['core:widgets']} as w,
					{$this->tables['core:widgets_lang']} as wl,
					{$this->tables['core:user_modules']} as m, 
					{$this->tables['core:user_modules_lang']} as l
				WHERE 
					w.widget_id = wl.widget_id AND 
					wl.lang_id=l.lang_id AND 
					mod_status=1 AND 
					widget_module=m.mod_id AND 
					w.widget_id IN ({$wdata}) AND 
					widget_status=1 AND 
					m.mod_id = l.mod_id AND 
					l.lang_id = {$_LANG_ID} AND
					widget_module_type=1 
					{$cond}
			"
		);

		if (is_Array($widgets)) {

			foreach ($widgets as $key => $val) {

				if (is_array($this->plugins["modules"]->modules[$val["mod_id"]]) && is_object($this->plugins[$val["mod_module_code"]])) {
					//check for database cache
					if ($val["widget_cache"] && ($val["widget_cache_update"] + $val["widget_cache"] > time()) ) {


						$content[$val["widget_id"]] = array(
							"link"		=> $val["link"],
							"content" => $val["widget_cache_data"]
						);
					} else {			
						if ($this->uwidgets_cache[$val["widget_id"]]) {
							$content[$val["widget_id"]] = $this->uwidgets_cache[$val["widget_id"]];
						} else {

							if (!$val["widget_show_title"]) {
								$val["widget_name"] = "";
							}
							

							$val["link"] = $this->module->plugins["modules"]->ModuleLink($val);

							if ($val["widget_settings"]) {
								$val["settings"] = unserialize(base64_decode($val["widget_settings"]));
							}

							$val["mod_settings"] = $this->plugins["modules"]->modules[$val["mod_id"]]["settings"];
						

							if ($val["widget_set_lang"]) {
								$tmp_settings = unserialize(base64_decode($val["widget_set_lang"]));

								if (is_array($tmp_settings)) {
									foreach ($tmp_settings as $k => $v) {
										$val["settings"][$k] = stripslashes($v);
									}						
								}					
							}
											
							$content[$val["widget_id"]] = array(
								"link"		=> $val["link"],
								"content" => CtemplateStatic::Replace(
									$this->module->plugins[$val["mod_module_code"]]->Widget($val), 
									$val
								)
							);

							$this->uwidgets_cache[$val["widget_id"]] = $content[$val["widget_id"]];
						}

						if ($val["widget_cache"]) {
							$this->db->QueryUpdate(
								$this->tables["core:widgets_lang"],
								array(
									"widget_cache_data"		=> $content[$val["widget_id"]]["content"],
									"widget_cache_update"	=> time()
								),

								"widget_id={$val[widget_id]} AND lang_id={$val[lang_id]}"

							);
						}
						
					}
				}
				

			}			
		}

		//core modules
		$widgets = $this->db->QFetchRowArray(
			"
				SELECT * 
				FROM 
					{$this->tables['core:widgets']} as w,
					{$this->tables['core:widgets_lang']} as wl,
					{$this->tables['core:modules']} 
				WHERE 
					w.widget_id = wl.widget_id AND 
					wl.lang_id = {$_LANG_ID} AND
					module_status=1 AND 
					widget_module=module_id AND 
					w.widget_id IN ({$wdata}) AND 
					widget_status=1 AND 
					widget_module_type=2 
					{$cond}
			"
		);

		if (is_Array($widgets)) {

			$wid = array();
			$_lang = array();


			foreach ($widgets as $key => $val) {


				if (is_array($mod = $this->plugins["modules"]->modules[$val["module_code"]]))  {

					$val["module_name"] = $mod["module_name"];
					$val["module_url"] = $mod["module_url"];
				

					//check for database cache
					if ($val["widget_cache"] && ($val["widget_cache_update"] + $val["widget_cache"] > time()) ) {

						$content[$val["widget_id"]] = array(
							"link"		=> $val["link"],
							"content" => $val["widget_cache_data"]
						);
					} else {			

						if (!$val["widget_show_title"]) {
							$val["widget_name"] = "";
						}

						$val["mod_settings"] = $this->plugins["modules"]->modules[$val["module_code"]]["settings"];


						$val["link"] = $this->module->plugins["modules"]->ModuleLink(array("mod_url" => $val["module_url"]));


						if ($val["widget_settings"]) {
							$val["settings"] = unserialize(base64_decode($val["widget_settings"]));
						}

						if ($val["widget_set_lang"]) {
							$tmp_settings = unserialize(base64_decode($val["widget_set_lang"]));

							if (is_array($tmp_settings)) {
								foreach ($tmp_settings as $k => $v) {
									$val["settings"][$k] = stripslashes($v);
								}
							}					

						}
						

						if (is_object($this->module->plugins[$val["module_code"]])) {
							$content[$val["widget_id"]] = array(
								"link"		=> $val["link"],
								"content" => CtemplateStatic::Replace(
									$this->module->plugins[$val["module_code"]]->Widget($val), 
									$val
								)
							);

						}
						

						if ($val["widget_cache"]) {
							$this->db->QueryUpdate(
								$this->tables["core:widgets_lang"],
								array(
									"widget_cache_data"		=> $content[$val["widget_id"]]["content"],
									"widget_cache_update"	=> time()
								),

								"widget_id={$val[widget_id]} AND lang_id={$val[lang_id]}"

							);
						}

					}
				}
			}			
		}		


		if (!count($content)) {
			return "";
		}
		

		switch ($return) {
			case "string":
				return $base->html->Table(
					$this->private->templates["widgets"],
					"",
					$content
				);

			break;

			case "array":

				if (is_array($content)) {
					return $content;
				}
				
			break;

		}		

	}


	
	function Widget($widget) {

		if (!is_array($widget)) {
			return "";
		}
		

		$this->__init();

		switch ($widget["widget_type"]) {
			case "1":
				return $this->widgetText($widget);
			break;

			case "2":
				return $this->widgetFacebook($widget);
			break;

			case "3":
				return $this->widgetLinks($widget);
			break;

			case "4":
				return $this->widgetAcordeon($widget);
			break;

			case "5":
				return $this->widgetDropdownMenu($widget);
			break;

			case "6":
				return $this->widgetRawHtml($widget);
			break;

			case "7":
				return $this->widgetTabs($widget);
			break;

			case "8":
				return $this->widgetProgress($widget);
			break;

			case "9":
				return $this->widgetCountdown($widget);
			break;

			case "10":
				return $this->widgetFlipBox($widget);
			break;

			case "11":
				return $this->widgetFlipBoxSet($widget);
			break;

			case "12":
				return $this->widgetCounter($widget);
			break;


			case "13":
				return $this->widgetTwitter($widget);
			break;

			case "15":
				return $this->widgetImage($widget);
			break;

			case "16":
				return $this->widgetCards($widget);
			break;


		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetText($widget) {

		$this->__init();

		switch ($widget["settings"]["lang_link_type"]) {
			case "0":
				$more = "";
			break;

			case "1":
				$more = $this->private->templates["text"]->blockReplace(
					"More",
					array(
						"link"		=> $widget["settings"]["lang_link_link"],
						"target"	=> $widget["settings"]["lang_link_target"],
						"text"		=> $widget["settings"]["lang_link_text"],
					)
				);
			break;

			case "2":


				if (is_array($this->plugins["modules"]->modules[$widget["settings"]["lang_link_module"]])) {
					$more = $this->private->templates["text"]->blockReplace(
						"More",
						array(
							"link"		=> $this->plugins["modules"]->modules[$widget["settings"]["lang_link_module"]]["link"],
							"target"	=> $widget["settings"]["lang_link_target"],
							"text"		=> $widget["settings"]["lang_link_text"],
						)
					);
				}						
			break;
		}

		return $this->private->templates["text"]->blockReplace(
			"Main" , 
			array(
				"body"	=> $widget["settings"]["lang_body"],
				"more"	=> $more,
				"image"	=> $widget["settings"]["lang_image"] ? $this->private->templates["text"]->blockReplace("Image" , $widget["settings"] , $widget ) : "",
			),
			$widget
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetCounter($widget) {

		$this->__init();

		$tpl = &$this->private->templates["counter"];

		$items = explode("\n" , $widget["settings"]["lang_body"]);
		$count = min(4, count($items));

		if (!$count) {
			return "";
		}
		

		for ($i = 0 ; $i < $count; $i ++ ) {
			$tmp = explode("|" , $items[$i]);
			$items[$i] = array(
				"no"	=> trim($tmp[1]),
				"text"	=> trim($tmp[0]),
			);			
		}
		

		for ($i = 0 ; $i < $count; $i ++ ) {
			$content .= $tpl->blockReplace(
				"Body" . $count,
				array(
					"data"	=> $tpl->blockReplace("Item" , $items[$i])
				)
			);
		}

		switch ($widget["settings"]["lang_link_type"]) {
			case "0":
				$more = "";
			break;

			case "1":
				$more = $tpl->blockReplace(
					"Link",
					array(
						"link"		=> $widget["settings"]["lang_link_link"],
						"target"	=> $widget["settings"]["lang_link_target"],
						"text"		=> $widget["settings"]["lang_link_text"],
					)
				);
			break;

			case "2":


				if (is_array($this->plugins["modules"]->modules[$widget["settings"]["lang_link_module"]])) {
					$more = $tpl->blockReplace(
						"Link",
						array(
							"link"		=> $this->plugins["modules"]->modules[$widget["settings"]["lang_link_module"]]["link"],
							"target"	=> $widget["settings"]["lang_link_target"],
							"text"		=> $widget["settings"]["lang_link_text"],
						)
					);
				}						
			break;
		}


		return $tpl->blockReplace(
			"Widget" ,
			array(
				"content"	=> $content,
				"more"		=> $more,
			),
			$widget
		
		);
	}
	
	function widgetFlipBoxSet($widget) {
		global $base;

		$this->__init();


		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['core:widgets_flipbox']} as r,
				{$this->tables['core:widgets_flipbox_lang']} as l
			WHERE
				r.item_id = l.item_id AND 
				l.lang_id={$widget[lang_id]} AND
				r.widget_id={$widget[widget_id]}
			ORDER BY 
				item_order ASC						"

		);


		if (!is_array($items)) {
			return "";
		}

		$template = &$this->private->templates["flipbox-set"];
		global $base;


		foreach ($items as $key => $val) {
			switch ($val["item_link_type"]) {
				case "0":
					$items[$key]["more"] = "";
				break;

				case "1":
					$items[$key]["more"] = $this->private->templates["flipbox-set"]->blockReplace(
						"Link",
						array(
							"link"		=> $val["item_link_link"],
							"target"	=> $val["item_link_target"],
							"text"		=> $val["item_link_text"],
						)
					);
				break;

				case "2":
					if (is_array($this->plugins["modules"]->modules[$val["item_link_module"]])) {
						$items[$key]["more"] = $this->private->templates["flipbox-set"]->blockReplace(
							"Link",
							array(
								"link"		=> $this->plugins["modules"]->modules[$val["item_link_module"]]["link"],
								"target"	=> $val["item_link_target"],
								"text"		=> $val["item_link_text"],
							)
						);
					}						
				break;
			}
			
		}

		return $this->private->templates["flipbox-set"]->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->Table(
					$this->private->templates["flipbox-set"] , 
					"" , 
					$items
				),
			),
			$widget["settings"],
			$widget
		);	
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetRawHtml($widget) {

		$this->__init();

		return $this->private->templates["raw"]->blockReplace(
			"Main" , 
			array(
				"title"	=> $widget["widget_show_title"] && $widget["widget_name"] ? $this->private->templates["raw"]->blockReplace("Title" , $widget) : "",
				"body"	=> stripslashes($widget["settings"]["set_html"]),
			)
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetFacebook($widget) {
		$this->__init();

		return $this->private->templates["fblike"]->blockReplace(
			"Main",
			array(
				"link"				=> $widget["settings"]["set_fb_link"],
				"set_fb_posts"		=> $widget["settings"]["set_fb_posts"] == "1" ? "true" : "false",
				"set_fb_faces"		=> $widget["settings"]["set_fb_faces"] == "1" ? "true" : "false",
				"set_fb_hide_cover"		=> $widget["settings"]["set_fb_hide_cover"] == "1" ? "true" : "false",
				"set_fb_small_header"		=> $widget["settings"]["set_fb_small_header"] == "1" ? "true" : "false", 
				"set_fb_height"		=> $widget["settings"]["set_fb_height"], 

				"title"				=> $widget["widget_name"],
			)
		);
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetLinks($widget) {

		if (!is_array($widget)) {
			return "";
		}
		
		$links = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['core:widgets_links']} as r,
				{$this->tables['core:widgets_links_lang']} as l
			WHERE
				r.item_id = l.item_id AND 
				l.lang_id={$widget[lang_id]} AND
				r.widget_id={$widget[widget_id]}
			ORDER BY 
				item_order ASC			
			"
		);

		if (!is_array($links)) {
			return "";
		}

		$this->__init();

		$template = &$this->private->templates["links"];

		
		global $base;
	
		foreach ($links as $key => $val) {
			
			switch ($val["item_link_type"]) {
				case "0":
					$more = "";
				break;

				case "1":
					$more = $val["item_link_link"];
				break;

				case "2":


					if (is_array($this->plugins["modules"]->modules[$val["item_link_module"]])) {
						$more = $this->plugins["modules"]->modules[$val["item_link_module"]]["link"];
					}						
				break;
			}

			$links[$key]["link"] = $more;
			$links[$key]["icon"] = $template->blockReplace($val["item_link_icon"] ? "Icon" : "NoIcon", $val);


			if ($val["item_link_type"]) {
				$links[$key]["content"] = $template->blockExists("Link") ? $template->blockReplace("Link" , $links[$key]) : "";
			} else {
				$links[$key]["content"] = $template->blockExists("NoLink") ?  $template->blockReplace("NoLink" , $links[$key]) : "";
			}
						
			
		}

		
		return $template->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->table(
					$template , 
					"",	
					$links
				)
			),
			$widget ,
			array(
				"selected"	=> ""
			)
		);
		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetAcordeon($widget) {

		if (!is_array($widget)) {
			return "";
		}

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['core:widgets_acordeon']} as r,
				{$this->tables['core:widgets_acordeon_lang']} as l
			WHERE
				r.item_id = l.item_id AND 
				l.lang_id={$widget[lang_id]} AND
				r.widget_id={$widget[widget_id]}
			ORDER BY 
				item_order ASC			
			"

		);


		if (!is_array($items)) {
			return "";
		}

		$template = &$this->private->templates["acordeon"];
		global $base;

		foreach ($items as $key => $val) {


			switch ($val["item_link_type"]) {
				case "0":
					$more = "";
				break;

				case "1":
					$more = $template->blockReplace(
						"Link",
						array(
							"link"		=> $val["item_link_link"],
							"target"	=> $val["item_link_target"],
							"text"		=> $val["item_link_text"],
						)
					);
				break;

				case "2":


					if (is_array($this->plugins["modules"]->modules[$val["item_link_module"]])) {
						$more = $template->blockReplace(
							"Link",
							array(
								"link"		=> $this->plugins["modules"]->modules[$val["item_link_module"]]["link"],
								"target"	=> $val["item_link_target"],
								"text"		=> $val["item_link_text"],
							)
						);
					}						
				break;
			}

			$items[$key]["link"] = $more;

			$items[$key]["icon"] = $template->blockReplace($val["item_icon"] ? "Icon" : "NoIcon" , $val);
			
		}
		
		return $template->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->table(
					$template , 
					"",	
					$items
				)
			),
			$widget 
		);

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetDropdownMenu($widget) {

		$links = $this->plugins["modules"]->GetModulesByParent($widget["settings"]["set_category"]);

		if (!is_array($links)) {
			return "";
		}

		$template = &$this->private->templates["dropdown"];



		//need to fix the global link m to get the original module link

		foreach ($links as $key => $module) {

			if ($module["mod_id"] && !$module["mod_invisible"]) {

				if (method_exists($this->plugins[$module["module_code"]] , "GetMenuButton")) {

					$tmp = $this->plugins[$module["module_code"]]->GetMenuButton($module);

					if (is_array($tmp)) {

						if (!is_array($tmp[0]) && count($tmp)) {
							$tmp = array( 0=> $tmp);
						}
					
						foreach ($tmp as $_key => $_val) {
							if (is_array($_val)) {
								$_val["mod_color"] = $module["mod_color"];
								$_links[]  = $_val;
							}
							
						}
						
					}
					
				}
			}
								
		}

		if (is_array($_links)) {

			foreach ($_links as $key => $val) {
				$_links[$key]["selected"] = $val["selected"] ? $template->blockReplace("Selected" , $val) : "";

				//keep old compatibility
				$_links[$key]["item_title"] = $val["title"];
				$_links[$key]["item_link"] = $val["link"];
				$_links[$key]["item_link_target"] = "";
			}
			
		}
		
		global $base;

		return $template->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->table(
					$template , 
					"",	
					$_links
				)
			),
			$widget 
		);
		
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetProgress($widget) {
		global $base;

		if (trim($widget["settings"]["set_options"])) {

			$tmp = explode("\n" ,$widget["settings"]["set_options"] );

			if (count($tmp)) {
				foreach ($tmp as $key => $val) {
					$_tmp = explode("|" , $val);
					$vals[] = array(
						"title"	=> $_tmp[0],
						"perc"	=> min(100 , trim($_tmp[1])),
					);
				}


				return $this->private->templates["progress"]->blockReplace(
					"Widget",
					array(
						"items"	=> $base->html->table(
							$this->private->templates["progress"],
							"",
							$vals
						)
					),
					$widget
				);
				
			}
			
		}
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetTabs($widget) {

		if (!is_array($widget)) {
			return "";
		}

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['core:widgets_acordeon']} as r,
				{$this->tables['core:widgets_acordeon_lang']} as l
			WHERE
				r.item_id = l.item_id AND 
				l.lang_id={$widget[lang_id]} AND
				r.widget_id={$widget[widget_id]}
			ORDER BY 
				item_order ASC			
			"

		);


		if (!is_array($items)) {
			return "";
		}

		$template = &$this->private->templates["tabs"];
		global $base;

		foreach ($items as $key => $val) {


			switch ($val["item_link_type"]) {
				case "0":
					$more = "";
				break;

				case "1":
					$more = $template->blockReplace(
						"Link",
						array(
							"link"		=> $val["item_link_link"],
							"target"	=> $val["item_link_target"],
							"text"		=> $val["item_link_text"],
						)
					);
				break;

				case "2":


					if (is_array($this->plugins["modules"]->modules[$val["item_link_module"]])) {
						$more = $template->blockReplace(
							"Link",
							array(
								"link"		=> $this->plugins["modules"]->modules[$val["item_link_module"]]["link"],
								"target"	=> $val["item_link_target"],
								"text"		=> $val["item_link_text"],
							)
						);
					}						
				break;
			}

			$items[$key]["link"] = $more;
			$items[$key]["icon"] = $template->blockReplace($val["item_icon"] ? "Icon" : "NoIcon", $val);
			
		}
		
		return $template->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->table(
					$template , 
					"",	
					$items
				),
				"tabs"	=> $base->html->table(
					$template , 
					"Tabs",	
					$items
				)

			),
			$widget ,
			$widget["settings"]
		);

	}

	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetCountdown($widget) {

		$this->__init();

		switch ($widget["settings"]["lang_link_type"]) {
			case "0":
				$more = "";
			break;

			case "1":
				$more = $this->private->templates["countdown"]->blockReplace(
					"Link",
					array(
						"link"		=> $widget["settings"]["lang_link_link"],
						"target"	=> $widget["settings"]["lang_link_target"],
						"text"		=> $widget["settings"]["lang_link_text"],
					)
				);
			break;

			case "2":


				if (is_array($this->plugins["modules"]->modules[$widget["settings"]["lang_link_module"]])) {
					$more = $this->private->templates["countdown"]->blockReplace(
						"Link",
						array(
							"link"		=> $this->plugins["modules"]->modules[$widget["settings"]["lang_link_module"]]["link"],
							"target"	=> $widget["settings"]["lang_link_target"],
							"text"		=> $widget["settings"]["lang_link_text"],
						)
					);
				}						
			break;
		}


		return $this->private->templates["countdown"]->blockReplace(
			"Widget" , 
			array(
				"date"	=> date("Y/m/j" , $widget["settings"]["set_date"]),
				"more"	=> $more
			),
			$widget
		);
	}

	

	function onGlobalHooksExecute($module) {
		$this->plugins["shortcodes"]->dynamic[] = array(
			"pattern"	=> '/\[widget=([0-9]+)\]/',
			"method"	=> array(&$this, "shortcode")
		);
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ShortCode($matches) {
		return $this->Widgets($matches[1]);
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetTwitter($widget) {

		global $base;

		External::Load("twitter");

		$tweet = new TweetPHP(array(
		  'consumer_key'              => $widget["settings"]["set_consumer_key"],
		  'consumer_secret'           => $widget["settings"]["set_consumer_secret"],
		  'access_token'              => $widget["settings"]["set_access_token"],
		  'access_token_secret'       => $widget["settings"]["set_access_secret"],
		  'twitter_screen_name'       => $widget["settings"]["set_screen_name"],
		  'cache_dir'				  => $_SERVER["DOCUMENT_ROOT"] . '/upload/tmp/cache/', // Where on the server to save cached tweets

		));
		

		$tweets = $tweet->get_tweet_array();

		if (!is_array($tweets) || !is_array($tweets[0])) {
			return "";
		}

		$template = &$this->private->templates["twitter"];

		foreach ($tweets as $key => $val) {
			$items[] = array(
				"user"	=> $val["user"]["screen_name"],
				"name"	=> $val["user"]["name"],
				"text"	=> autoLink($val["text"]),
				"date"	=> date("F j, Y, g:i a", strtotime($val["created_at"]))
			);
		}

		return $template->blockReplace(
			"Widget" , 
			array(
				"data"	=> $base->html->table(
					$template , 
					"",	
					$items
				),
			),
			$widget ,
			$widget["settings"]
		);
		

	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetImage($widget) {

		$this->__init();

		switch ($widget["settings"]["lang_link_type"]) {
			case "0":
				$more = $this->private->templates["image"]->blockReplace(
					"NoLink"
				);
					
			break;

			case "1":
				$more = $this->private->templates["image"]->blockReplace(
					"Link",
					array(
						"link"		=> $widget["settings"]["lang_link_link"],
						"target"	=> $widget["settings"]["lang_link_target"],
						"text"		=> $widget["settings"]["lang_link_text"],
					)
				);
			break;

			case "2":


				if (is_array($this->plugins["modules"]->modules[$widget["settings"]["lang_link_module"]])) {
					$more = $this->private->templates["image"]->blockReplace(
						"Link",
						array(
							"link"		=> $this->plugins["modules"]->modules[$widget["settings"]["lang_link_module"]]["link"],
							"target"	=> $widget["settings"]["lang_link_target"],
							"text"		=> $widget["settings"]["lang_link_text"],
						)
					);
				}						
			break;
		}

		return CTemplateStatic::Replace(
				$more , 
				$widget
		);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function WidgetCards($widget) {
		global $base;

		$this->__init();


		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['core:widgets_cards']} as r,
				{$this->tables['core:widgets_cards_lang']} as l
			WHERE
				r.item_id = l.item_id AND 
				l.lang_id={$widget[lang_id]} AND
				r.widget_id={$widget[widget_id]}
			ORDER BY 
				item_order ASC						
			"

		);


		if (!is_array($items)) {
			return "";
		}

		$template = &$this->private->templates["cards"];

		foreach ($items as $key => $val) {

			switch ($val["item_link_type"]) {
				case "0":
					$items[$key]["more"] = "";
				break;

				case "1":
					$items[$key]["more"] = $template->blockReplace(
						"Link",
						array(
							"link"		=> $val["item_link_link"],
							"target"	=> $val["item_link_target"],
							"text"		=> $val["item_link_text"],
						)
					);
				break;

				case "2":
					if (is_array($this->plugins["modules"]->modules[$val["item_link_module"]])) {
						$items[$key]["more"] = $template->blockReplace(
							"Link",
							array(
								"link"		=> $this->plugins["modules"]->modules[$val["item_link_module"]]["link"],
								"target"	=> $val["item_link_target"],
								"text"		=> $val["item_link_text"],
							)
						);
					} else { $items[$key]["more"] = ""; }
				break;
			}


			$items[$key]["title"]	= $val["item_title"] ? $template->blockreplace("Title" , $val ) : "";
			$items[$key]["body"]	= $val["item_desc"] ? $template->blockreplace("Body" , $val ) : "";

			switch ($val["item_type"]) {
				case "1": $items[$key]["resource"] = $template->blockReplace("Image" , $val); break;
				case "2": $items[$key]["resource"] = $template->blockReplace("Youtube" , $val); break;
				case "3": $items[$key]["resource"] = $template->blockReplace("Vimeo" , $val); break;
				case "4": $items[$key]["resource"] = $template->blockReplace("Icon" , $val); break;
				default: $items[$key]["resource"] = ""; break;
			}			
			
		}

		return $template->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->Table(
					$template , 
					"" , 
					$items
				),
			),
			$widget["settings"],
			$widget
		);	

	}
	

}

?>