<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CPubMenu extends CPlugin{
	
	var $tplvars; 

	function CPubMenu() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "pubmenu") {

			$this->__init();
			$this->plugins["globalhooks"]->SetModule($this->tpl_module);

			switch ($_GET["sub"]) {

				case "landing":
					return $this->Categories();
				break;

				case "category":
					return $this->Category();
				break;				

				case "offer":
					return $this->Offer();
				break;
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"categories"				=> "categories.htm",
			"category"					=> "category.htm",
			"offer"						=> "offer.htm",

			"widget.categories"			=> "widget.categories.htm",
			"widget.offers"				=> "widget.offers.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadModuleInfo();
	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Categories() {
		global $base;

		$text = $this->GetTexts();

		$this->module->plugins["modules"]->SetSeo(
			$text
		);

		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module

		);


		$cats = $this->ProcessCats($this->GetCategories());

		$template = &$this->private->templates["categories"];

		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$cats
					),
				),
				$text,
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Category() {
		global $base;

		$cat = $this->db->QFetchArray(
			"SELECT * FROM
				{$this->tables['plugin:pubmenu_cats']} as c,
				{$this->tables['plugin:pubmenu_cats_lang']} as l
			WHERE
				c.cat_id = l.cat_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				c.module_id = {$this->tpl_module[mod_id]} AND 
				c.cat_status = 1 AND 
				l.cat_url LIKE '%s'
			ORDER BY 
				c.cat_order ASC
			",
			array(
				$_GET["cat_id"]
			)
		);

		if (!is_array($cat)) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}


		$this->module->plugins["seo"]->PageMeta(
			$cat
		);

		$text = $this->GetTexts();

		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module

		);

		$cat["link"] = $this->tpl_module["link"] . $cat["cat_url"] . "/";


		$template = &$this->private->templates["category"];

		$items = $this->GetItems(array(
			"items"		=> $this->tpl_module["settings"]["set_ipp"] , 
			"page"		=> $_GET["page"],
			"item_cat"	=> $cat["cat_id"]
		));

		if (is_array($items["records"])) {
			$items["records"] = $this->ProcessMenu(
				$items["records"] , 
				$cat , 
				$template
			);
		}
		
		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_cat"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$items["records"]
					),

					"paging"	=> $this->module->plugins["paging"]->Paging(
						$items["pages"] , 
						$items["page"] , 
						array(
							"first"	=> $this->tpl_module["link"] . $cat["cat_url"] . "/",
							"all"	=> $this->tpl_module["link"] . $cat["cat_url"] . "/p{PAGE}",
						),
						$items["items"]
					),


				),
				$cat,
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);

	}
	

	function GetItems($params = array()) {
	
		$count	= $params["items"];
		$page	= $params["page"];

		$order		= "item_order";
		$order_mode = "ASC";

		$cond = "c.item_cat={$params[item_cat]} AND c.item_id=l.item_id AND l.lang_id={$this->tpl_module[lang_id]} AND c.module_id={$this->tpl_module[mod_id]} AND item_show=1  ";

		$item_count = $this->db->RowCount(
			"	{$this->tables['plugin:pubmenu_images']} as c,
				{$this->tables['plugin:pubmenu_images_lang']} as l
			",
			"	WHERE {$cond}"
		);

		if (!$page && $item_count) {
			$page = 1;
		} else 
			$page = max(1,(int)$page);

		$items = $this->db->QFetchRowArray(
			"SELECT * " . 
			"FROM 
				{$this->tables['plugin:pubmenu_images']} as c,
				{$this->tables['plugin:pubmenu_images_lang']} as l
			WHERE 				
				{$cond}
			ORDER BY  {$order} {$order_mode} 
			LIMIT " . ( max(0,($page - 1 ) * $count )) . " , " . $count 
		);

		return array(
			"records"	=> $items, 
			"count"		=> $item_count , 
			"pages"		=> $item_count ? ceil($item_count / $count) : 1,
			"page"		=> $page,

			"ipp"		=> $count
		);

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetCategories() {
		$cats = $this->db->QFetchRowArray(
			"SELECT * FROM
				{$this->tables['plugin:pubmenu_cats']} as c,
				{$this->tables['plugin:pubmenu_cats_lang']} as l
			WHERE
				c.cat_id = l.cat_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				c.cat_status = 1 AND 
				c.module_id = {$this->tpl_module[mod_id]}
			ORDER BY 
				c.cat_order ASC
			"
		);


		return $cats;

	}

	function Widget($widget) {

		$this->__init();

		switch ($widget["widget_type"]) {

			case "1":
				return $this->widgetOffers($widget);
			break;

			case "4":
				return $this->widgetCategories($widget);
			break;


		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function widgetCategories($widget) {
		global $_LANG_ID , $base;

		$labels = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:pubmenu_cats']} as p , 
				{$this->tables['plugin:pubmenu_cats_lang']} as l
			WHERE 
				p.cat_status = 1 AND 
				p.cat_id = l.cat_id AND 
				l.lang_id = {$widget[lang_id]} AND 
				p.module_id = {$widget[mod_id]} 

			ORDER BY 
				cat_order ASC
			"
		);


		if (is_array($labels)) {

			$template = $this->private->templates["widget.categories"];

			foreach ($labels as $key => $val) {
				
				$labels[$key]["link"] = $widget["link"] . "{$val[cat_url]}/";
				$labels[$key]["selected"] = ($_GET["module_id"] == $widget["widget_module"]) &&($_GET["cat_id"] == $val["cat_url"]) ? $template->blockReplace("Selected") : "";
			}

			return $template->blockreplace(
				"Main" , 
				array(
					"labels"	=> $base->html->Table(
						$template , 
						"", 
						$labels
					),
				),
				$widget,
				$widget["mod_settings"]
			);

		}

		return "";		
	}
	



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessCats($cats , $module = null) {

		if (!$module) {
			$module = &$this->tpl_module;
		}
		
		if (is_array($cats)) {
			foreach ($cats as $key => $val) {
				$cats[$key]["link"] = $module["link"] . $val["cat_url"] . "/";
				$cats[$key]["image"] = $val["cat_image"] ? "upload/pubmenu/cat_{$val[cat_id]}.jpg" : "upload/default-images/pubmenu-cat.png";
			}
			
		}


		return $cats;
		
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ProcessMenu($menu , $cat , &$template) {

		if (is_array($menu)) {
			$total = count($menu);
			foreach ($menu as $key => $val) {
				$cnt ++;

				$menu[$key]["tn_image"] = $val["item_image"] ? "upload/pubmenu/tn_{$val[item_id]}.jpg" : "upload/default-images/pubmenu-menu.png";
				$menu[$key]["image"] = $val["item_image"] ? "upload/pubmenu/{$val[item_id]}.jpg" : "upload/default-images/pubmenu-menu.png";
				$menu[$key]["item_description"] = nl2br($val["item_description"]);

				if ($val["item_special"]) {
					if ($val["item_special_items"]) {
						$total =  $this->db->QFetchArray(
							"SELECT sum(item_price) as price FROM
								{$this->tables['plugin:pubmenu_images']} as c,
								{$this->tables['plugin:pubmenu_images_lang']} as l
							WHERE
								c.item_id = l.item_id AND 
								l.lang_id = {$cat[lang_id]} AND 
								c.module_id = {$cat[module_id]}  AND 
								c.item_id IN ({$val[item_special_items]})
							ORDER BY 
								c.item_order ASC
							"
						);

						$content = //$this->db->Linear(
							$this->db->QFetchRowArray(
								"SELECT concat(item_title , ' (' , cat_title , ')') as title , c.item_id FROM
									{$this->tables['plugin:pubmenu_images']} as c,
									{$this->tables['plugin:pubmenu_images_lang']} as l,
									{$this->tables['plugin:pubmenu_cats']} as ct,
									{$this->tables['plugin:pubmenu_cats_lang']} as cl

								WHERE
									ct.cat_id=cl.cat_id AND 
									cl.lang_id = l.lang_id AND 
									c.item_cat = ct.cat_id AND
									c.item_id = l.item_id AND 
									l.lang_id = {$cat[lang_id]} AND 
									c.module_id = {$cat[module_id]}  AND 
									c.item_id IN ({$val[item_special_items]})
								ORDER BY 
									c.item_order ASC
								"
						//	)
						);

						$content = SortByKeys($content , "item_id" , $val["item_special_items"]);

						if (is_array($content)) {
							foreach ($content as $_key => $_val) {
								$content[$_key] = $_val["title"];
							}							
						}
						

						$menu[$key]["item_recepit"] = $val["item_recepit"] = implode(" + " , $content);

						$val["price_total"] = $menu[$key]["price_total"] = $val["item_price"] ? $template->blockReplace("PriceTotal" , $this->plugins["currency"]->FormatPrice( 0- ($val["item_price"] - $total["price"]), "split") ) : "";
					} else {
						$val["price_total"] = $menu[$key]["price_total"] = "";
						$menu[$key]["item_recepit"] = $val["item_recepit"] = "";
						
					}

					$menu[$key]["link"] = $cat["link"] . $val["item_url"] . "-" . $val["item_id"] . "/";
				} else {
					$val["price_total"] = $menu[$key]["price_total"] ="";
				}
				
				$menu[$key]["price"] = $val["item_price"] ? $template->blockReplace(
					"Price" , 
					$this->plugins["currency"]->FormatPrice($val["item_price"], "split") ,
					$val
				) : "";

	
				if ($val["item_special"] && $template->blockExists("Offer")) {
					$menu[$key]["content"] = $template->blockReplacE("Offer", $menu[$key]);
				} else {				
					$menu[$key]["content"] = $template->blockReplacE("Normal" , $menu[$key]);
				}
			}			
		}

		
		return $menu;
	}
	
	
	

	function GetAllLinks($module , &$links) {		
		$links[] = array(
			"url" => $module["link"],
		);


		//multipage then build the subalbums links
		$items = $this->db->QFetchRowArray(
			"SELECT 
				cat_url , c.cat_id 
			FROM 
				{$this->tables['plugin:pubmenu_cats']} as c,
				{$this->tables['plugin:pubmenu_cats_lang']} as l
			WHERE
				c.cat_id=l.cat_id AND 
				l.lang_id={$module[lang_id]} AND 
				c.module_id={$module[mod_id]} AND 
				c.cat_status = 1 
			"
		);


		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$links[] = array(
					"url" => $module["link"] . $val["cat_url"] . "/",
				);
			}
			
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Offer() {
		global $base;

		$cat = $this->db->QFetchArray(
			"SELECT * FROM
				{$this->tables['plugin:pubmenu_cats']} as c,
				{$this->tables['plugin:pubmenu_cats_lang']} as l,
				{$this->tables['plugin:pubmenu_images']} as i,
				{$this->tables['plugin:pubmenu_images_lang']} as il

			WHERE
				c.cat_id = l.cat_id AND 
				l.lang_id = {$this->tpl_module[lang_id]} AND 
				c.module_id = {$this->tpl_module[mod_id]} AND 
				c.cat_status = 1 AND 
				l.cat_url LIKE '%s' AND 
				i.item_id = il.item_id AND 
				il.lang_id = l.lang_id AND 
				i.item_cat = c.cat_id AND 
				i.item_id = %d
			",
			array(
				$_GET["cat_id"],
				$_GET["offer_id"]
			)
		);

		if (!is_array($cat) || !$cat["item_special_items"]) {
			return $this->module->plugins["redirects"]->ErrorPage("404" , true);
		}

		$this->module->plugins["seo"]->PageMeta(
			$cat
		);

		$text = $this->GetTexts();

		$this->module->plugins["breadcrumb"]->Add(
			array(
				"title"		=> $text["text_title"],
				"subtitle"	=> $text["text_subtitle"],
			),
			array(
				$this->tpl_module["link"]	=> $this->tpl_module["mod_name"]
			),
			$this->tpl_module["mod_protected"],
			$this->tpl_module

		);


		$template = &$this->private->templates["offer"];

		$items =  $this->ProcessMenu(
			$this->db->QFetchRowArray(
				"SELECT * FROM
					{$this->tables['plugin:pubmenu_images']} as c,
					{$this->tables['plugin:pubmenu_images_lang']} as l
				WHERE
					c.item_id = l.item_id AND 
					l.lang_id = {$this->tpl_module[lang_id]} AND 
					c.module_id = {$this->tpl_module[mod_id]}  AND 
					c.item_id IN ({$cat[item_special_items]}) AND
					item_special = 0
				ORDER BY 
					c.item_order ASC
				"
			) , 
			$cat , 
			$template
		);


		$items = SortByKeys($items , "item_id" , $cat["item_special_items"]);



		$total = 0;

		if (is_array($items)) {
			foreach ($items as $k => $v) {
				$total += $v["item_price"];
			}				
		}		


		$cat["link"] = $this->tpl_module["link"] . $cat["cat_url"] . "/";
		$cat["price_special"]  = $template->blockReplace("SpecialPrice" , $this->plugins["currency"]->FormatPrice($cat["item_price"] , "split"));
		$cat["price_total"]  =  $template->blockReplace("SpecialTotal" , $this->plugins["currency"]->FormatPrice($total , "split"));;



		return $this->module->plugins["layouts"]->Render(
			$this->plugins["layouts"]->Detect(
				$this->tpl_module["settings"]["set_layout_offer"],
				$this->tpl_module["mod_protected"]
			),
			$template->blockREplacE(
				"Main" , 
				array(

					"items"	=> $base->html->Table(
						$template, 
						"" , 
						$items
					),
				),
				$cat,
				$this->tpl_module,
				$this->tpl_module["settings"]
			)
		);

	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function WidgetOffers($widget) {
		global $base;


		$this->__init();
		$template = &$this->private->templates["widget.offers"];


		if ($widget["settings"]["set_show"] == "1") {
			$order = "rand()";
		} else {
			$order = "item_order ASC";
		}

		if (($widget["settings"]["set_show"] == "2") && $widget["settings"]["set_manual"]) {

			$cond = " AND i.item_id IN ({$widget['settings']['set_manual']} )";
		}
		
		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:pubmenu_cats']} as c , 
				{$this->tables['plugin:pubmenu_cats_lang']} as cl ,
				{$this->tables['plugin:pubmenu_images']} as i , 
				{$this->tables['plugin:pubmenu_images_lang']} as l 
			WHERE
				c.cat_status = 1 AND 
				c.cat_id = cl.cat_id AND 
				cl.lang_id = l.lang_id AND 
				c.cat_id = i.item_cat AND
				i.item_show = 1 AND
				i.item_id = l.item_id and 
				i.module_id = {$widget[mod_id]} AND 
				i.item_special=1 AND 
				l.lang_id = {$widget[lang_id]} {$cond}
			ORDER BY 
				{$order}
			LIMIT {$widget[settings][set_items]}
			"
		);	
/*

		$items = $this->ProcessItems(
			$items , 
			array(
				"set_items_size" => $widget["settings"]["set_size"]
			) , 
			$template
		);
*/
		
		if (is_array($items)) {
			foreach ($items as $key => $val) {

				$val["link"] = $widget["link"] . $val["cat_url"] . "/";

				$tmp = $this->ProcessMenu(array(0 => $val) , $val , $template);

				$items[$key] = $tmp["0"];

			}
			

			//debug($items,1);

			global $base;

			return $template->blockReplace(
				"Main" , 
				array(
					"items"	=> $base->html->table(
						$template , 
						"" , 
						$items
					)
				),
				$widget,
				$widget["settings"],
				$widget["mod_settings"]
			);
		}


	}
	
}

?>