<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2014 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CMaintenance extends CPlugin{
	
	var $tplvars; 

	function CMaintenance() {
		//$this->CPlugin($db, $tables , $templates);
		$this->name = "maintenance";

	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();


		if ($_GET["mod"] == "maintenance") {

			$this->__init();

			switch ($_GET["sub"]) {
				default:					
					return $this->Landing();
				break;

				case "ajax.send":
					return $this->AjaxSendMessage();
				break;
			}
		}
		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"main"	=> "main.htm",
			"lang"	=> "lang.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("maintenance");


		//$this->tpl_module["settings"]["link_dashboard"] = $this->tpl_module["link"] . "dashboard/";	
	} 

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Load() {
		global $_SESS;

		$this->__init();
		$ok = 1;

		if ($this->tpl_module["settings"]["set_active"]) {

			if ($this->tpl_module["settings"]["set_perm_admin"] && is_array($_SESS["minibase"])) {
			} else {			
				//force this module

				if ($_GET["invite"] || $_COOKIE["invite"]) {

					$invite = $_GET["invite"] ? $_GET["invite"] : $_COOKIE["invite"];

					$data = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:maintenance_users']} WHERE user_key LIKE '{$invite}'");

					if (is_array($data)) {

						//save the data in the cookie for 30days
						setcookie ( "invite", $invite, time() + 60*60*30 , "/" );

						$this->db->QueryUpdate(
							$this->tables["plugin:maintenance_users"],
							array(
								"user_last_login"		=> time(),
								"user_last_login_ip"	=> $_SERVER["REMOTE_ADDR"],
							),
							"user_id={$data['user_id']}"
						);

						return true;
						
					}
					
				}
				

				if ( !$this->tpl_module["settings"]["set_date"] ||  ($this->tpl_module["settings"]["set_date"] && ( $this->tpl_module["settings"]["set_date"] < time()))) {

					$_GET["mod"]	= "maintenance";
					$_GET["sub"]	= "landing";
					global $_PAGE;

					$_PAGE = "maintenance";

				}


			}
		}

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Landing() {
		global $_LANG , $_LANG_ID , $_SESS;



		$template = &$this->private->templates["main"];



		$link = $this->plugins["modules"]->ScriptLink("newsletters.ajax.subscribe.php");


		$texts = $this->GetTexts(array(
			"core"		=> $this->tables["plugin:maintenance_texts"],
			"lang"		=> $this->tables["plugin:maintenance_texts_lang"],
		));

		//if no language was set for ths, then fall back on default language
		if (!is_array($texts) && !is_array($_SESS["minibase"])) {


			if (is_array($this->plugins["languages"]->languages)) {
				unset($this->plugins["languages"]->languages);
			}
		
			$this->plugins["languages"]->DetectLang();

			//update the lang_id inside the module id 
			$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("maintenance" , true);


			//reload the text for the default language
			$texts = $this->GetTexts(array(
				"core"		=> $this->tables["plugin:maintenance_texts"],
				"lang"		=> $this->tables["plugin:maintenance_texts_lang"],
			));		
		}

		$this->plugins["seo"]->PageMeta(array(
			"seo_title"	=> $texts["seo_title"],
			"seo_desc"	=> $texts["seo_desc"],
		), "" , true);


		$images = $this->db->QFetchRowArray(
			"SELECT * FROM {$this->tables['plugin:maintenance_images']} ORDER BY item_order ASC"
		);

		global $base;

		if (is_array($images)) {

			$backgrounds = $base->html->table(
				$template , 
				"BG",
				$images
			);
		}
				
		//overwrite the http reponse vode
		switch ($this->tpl_module["settings"]["set_type"]) {
			case "1":
				header('HTTP/1.1 503 Service Temporarily Unavailable' , true);
				header('Status: 503 Service Temporarily Unavailable');

				if ($this->tpl_module["settings"]["set_date_end"] > time()) {
					header('Retry-After: ' . date( "D, j M Y H:i:s T" , $this->tpl_module["settings"]["set_date_end"]));
				}

			break;

			default:

			break;
		}



		return $template->blockReplace(
			"Main" , 
			array(

				"newsletter"			=> $this->tpl_module["settings"]["set_newsletter"] && is_object($this->plugins['newsletters']) ? $template->blockReplace("Newsletter" , array("script" => $link)) : "",
				"newsletter_control"	=> $this->tpl_module["settings"]["set_newsletter"] ? $template->blockReplace("NewsletterButton") : "",
				"countdown"				=> $this->tpl_module["settings"]["set_countdown"] && ($this->tpl_module["settings"]["set_date_end"] > time())? $template->blockReplace("Countdown" , array("date"=> date("+r" , $this->tpl_module["settings"]["set_date_end"]))) : "",
				"script"				=> $this->plugins["modules"]->ScriptLink("ajax.maintenance-send.php"),

				"backgrounds"			=> $backgrounds,


				"lang_menu"				=> $this->plugins["languages"]->Menu($this->private->templates["lang"])
			),

			$texts,

			$this->tpl_module["settings"]
		);
	}
	

	

	function AjaxSendMessage() {
		global $_CONF , $_NO_HTACCESS , $_SESS , $_LANG_ID;

		$this->__init();

		if (!is_array($this->tpl_module)) {
			return "Unknown error";
		}
		
		if (!$_POST["name"]) {
			return $this->module->plugins["common"]->ErrorMSG(
				$this->tpl_module["settings"]["lang_form_err_name"]
			);
		}
		

		if (!($_POST["email"] && Validate::Email($_POST["email"]))) {
			return $this->module->plugins["common"]->ErrorMsg(				
				$this->tpl_module["settings"]["lang_form_err_email"]
			);
		}


		if (!$_POST["message"]) {
			return $this->module->plugins["common"]->ErrorMSG(
				$this->tpl_module["settings"]["lang_form_err_message"]
			);
		}

		if (!$_POST["image_code"]) {
			return $this->module->plugins["common"]->ErrorMSG(
				"captcha:" . $this->tpl_module["settings"]["lang_form_err_capcha"]
			);
		}

		if ($_POST["image_code"] != $_SESS["XML_verify_key"]) {
			return $this->module->plugins["common"]->ErrorMSG(
				$this->tpl_module["settings"]["lang_form_err_capcha"]
			);
		}

		
		$vars = $_POST;
		


		//save the email to database
		$id = $this->db->QueryInsert(
			$this->tables["plugin:maintenance_messages"],
			$contact = array(
				"item_new"		=> 1,
				"item_date"		=> time(),
				"item_email"	=> $vars["email"],

				"item_name"		=> $vars["name"],
				"item_message"	=> $vars["message"],
			)
		);

		$mail_template = $this->module->plugins["mail"]->GetMail(
			$this->tpl_module["settings"]["set_mail_admin"],
			$vars
		);

		
		$responder_template = $this->module->plugins["mail"]->GetMail(
			$this->tpl_module["settings"]["set_mail_client"],
			$vars
		);

		if (is_array($responder_template)) {
			$email = $this->module->plugins["mail"]->SendMail(
				$responder_template
			);			
		}			

		//reset capcha
		$_SESS["XML_verify_key"] = "";

		return $this->module->plugins["common"]->SuccessMSG(
			$this->tpl_module["settings"]["lang_form_success"] . 
			$this->private->templates["main"]->blockReplace("Success")
		);

	}



}

?>